/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Platform;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.impl.ObjectVariantBinding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ComputationalValue;
import org.simantics.db.ExternalValueSupport;
import org.simantics.db.GraphHints;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.RelationInfo;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.primitiverequest.Builtin;
import org.simantics.db.common.primitiverequest.DatatypeBinding;
import org.simantics.db.common.primitiverequest.ForEachAssertedObject;
import org.simantics.db.common.primitiverequest.ForEachAssertedStatement;
import org.simantics.db.common.primitiverequest.HasStatement;
import org.simantics.db.common.primitiverequest.HasStatementSubject;
import org.simantics.db.common.primitiverequest.HasStatementSubjectObject;
import org.simantics.db.common.primitiverequest.HasValue;
import org.simantics.db.common.primitiverequest.Inverse;
import org.simantics.db.common.primitiverequest.IsInheritedFrom;
import org.simantics.db.common.primitiverequest.IsInstanceOf;
import org.simantics.db.common.primitiverequest.IsSubrelationOf;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.primitiverequest.PossibleInverse;
import org.simantics.db.common.primitiverequest.PossibleObject;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.primitiverequest.PossibleRelatedValueImplied;
import org.simantics.db.common.primitiverequest.PossibleStatement;
import org.simantics.db.common.primitiverequest.PossibleType;
import org.simantics.db.common.primitiverequest.PossibleUniqueAdapter;
import org.simantics.db.common.primitiverequest.PossibleValue;
import org.simantics.db.common.primitiverequest.PossibleValueImplied;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.common.primitiverequest.RelatedValueImplied;
import org.simantics.db.common.primitiverequest.SingleObject;
import org.simantics.db.common.primitiverequest.SingleStatement;
import org.simantics.db.common.primitiverequest.SingleType;
import org.simantics.db.common.primitiverequest.SingleTypeAny;
import org.simantics.db.common.primitiverequest.Types;
import org.simantics.db.common.primitiverequest.UniqueAdapter;
import org.simantics.db.common.primitiverequest.Value;
import org.simantics.db.common.primitiverequest.ValueImplied;
import org.simantics.db.common.primitiverequest.VariantValueImplied;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.procedure.adapter.SyncMultiProcedureAdapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.procedure.single.SyncReadProcedure;
import org.simantics.db.common.procedure.single.wrapper.DeepSingleOrErrorProcedure;
import org.simantics.db.common.procedure.single.wrapper.DeepSingleOrNullProcedure;
import org.simantics.db.common.procedure.single.wrapper.ExceptionToNullProcedure;
import org.simantics.db.common.procedure.single.wrapper.NullSingleOrNullProcedure;
import org.simantics.db.common.procedure.single.wrapper.SingleFunctionalOrNullProcedure;
import org.simantics.db.common.procedure.single.wrapper.SingleOrErrorProcedure;
import org.simantics.db.common.procedure.single.wrapper.SingleOrNullProcedure;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncListener;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncMultiListener;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncMultiProcedure;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncProcedure;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncSetProcedure;
import org.simantics.db.common.procedure.wrapper.NoneToSyncMultiListener;
import org.simantics.db.common.procedure.wrapper.NoneToSyncMultiProcedure;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncListener;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncMultiListener;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncMultiProcedure;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncProcedure;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncSetProcedure;
import org.simantics.db.common.request.AdaptValue;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.common.uri.ResourceToURI;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.ArgumentException;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.InvalidLiteralException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoInverseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.RelationContextImpl;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.AsyncBarrierImpl;
import org.simantics.db.impl.graph.InternalStatement;
import org.simantics.db.impl.graph.RandomAccessSubList;
import org.simantics.db.impl.graph.TIntArrayListInternal;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.impl.internal.RandomAccessValueSupport;
import org.simantics.db.impl.internal.ResourceData;
import org.simantics.db.impl.procedure.ResultCallWrappedSyncQueryProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryCacheBase;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncMultiListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.AsyncSetListener;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.MultiListener;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SetListener;
import org.simantics.db.procedure.StatementProcedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncMultiListener;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.procedure.SyncSetListener;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.DelayedWriteResult;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteOnlyResult;
import org.simantics.db.request.WriteResult;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;
import org.simantics.scl.reflection.ReflectionUtils;
import org.simantics.scl.reflection.ValueNotFoundException;
import org.simantics.scl.runtime.function.Function3;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadGraphImpl
implements AsyncReadGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadGraphImpl.class);
    static final boolean EMPTY_RESOURCE_CHECK = false;
    public final CacheEntry parent;
    public final ReadGraphImpl parentGraph;
    public final QueryProcessor processor;
    public final AsyncBarrierImpl asyncBarrier;
    static final Binding DATA_TYPE_BINDING_INTERNAL = Bindings.getBindingUnchecked(Datatype.class);
    static final Serializer DATA_TYPE_SERIALIZER = Bindings.getSerializerUnchecked((Binding)DATA_TYPE_BINDING_INTERNAL);
    public static final TObjectIntHashMap<String> counters = new TObjectIntHashMap();
    static final IdentityHashMap<Binding, Serializer> serializers = new IdentityHashMap();
    final AsyncProcedure<?> NONE = new AsyncProcedure<Object>(){

        public void execute(AsyncReadGraph graph, Object result) {
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
        }
    };
    protected static String INTERNAL_ERROR_STRING;
    private static GraphHints BASE_GRAPH_HINTS;
    private static ThreadLocal<GraphHints> syncGraph;

    static {
        serializers.put((Binding)Bindings.STRING, Bindings.STRING.serializer());
        INTERNAL_ERROR_STRING = "Transaction aborted due to internal client error.";
        BASE_GRAPH_HINTS = new GraphHintsImpl("sync", true);
        syncGraph = new ThreadLocal<GraphHints>(){

            @Override
            protected GraphHints initialValue() {
                return BASE_GRAPH_HINTS;
            }
        };
    }

    public static void resetCounters() {
        counters.clear();
    }

    public static String listCounters(File file) throws IOException {
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (Pair p : CollectionUtils.valueSortedEntries(counters)) {
            b.print(String.valueOf(-((Integer)p.second).intValue()) + " " + (String)p.first + "\n");
        }
        b.close();
        return "Dumped " + counters.size() + " queries.";
    }

    public final String getURI(Resource resource) throws AssumptionException, ValidationException, ServiceException {
        assert (resource != null);
        try {
            return (String)this.syncRequest((Read)new ResourceToURI(resource));
        }
        catch (AssumptionException e) {
            throw new AssumptionException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final String getPossibleURI(Resource resource) throws ValidationException, ServiceException {
        assert (resource != null);
        try {
            return (String)this.syncRequest((Read)new ResourceToPossibleURI(resource));
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Resource getResource(String id) throws ResourceNotFoundException, ValidationException, ServiceException {
        assert (id != null);
        try {
            Integer rid = QueryCache.resultURIToResource(this, id, this.parent, null);
            if (rid == 0) {
                throw new ResourceNotFoundException(id);
            }
            return this.processor.querySupport.getResource(rid);
        }
        catch (ResourceNotFoundException e) {
            throw new ResourceNotFoundException(id, (Throwable)e);
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Resource getPossibleResource(String id) throws ResourceNotFoundException, ValidationException, ServiceException {
        assert (id != null);
        try {
            return this.getResource(id);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public Map<String, Resource> getChildren(Resource resource) throws ValidationException, ServiceException {
        assert (resource != null);
        try {
            int rId = this.processor.querySupport.getId(resource);
            return QueryCache.resultChildMap(this, rId, this.parent, null);
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Resource getRootLibrary() {
        return this.processor.getRootLibraryResource();
    }

    public final Resource getBuiltin(String id) throws ResourceNotFoundException, ServiceException {
        assert (id != null);
        try {
            return (Resource)this.syncRequest((AsyncRead)new Builtin(id));
        }
        catch (ResourceNotFoundException e) {
            throw new ResourceNotFoundException(id, (Throwable)e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Collection<Statement> getStatements(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            StatementReadProcedure procedure = new StatementReadProcedure(this.getResourceSupport());
            this.processor.forEachStatement(this, subject, relation, procedure);
            procedure.checkAndThrow();
            return procedure;
        }
        catch (DatabaseException databaseException) {
            System.err.println(String.valueOf(INTERNAL_ERROR_STRING) + " getStatements " + subject + " " + relation);
            StatementReadProcedure procedure = new StatementReadProcedure(this.getResourceSupport());
            this.processor.forEachStatement(this, subject, relation, procedure);
            return Collections.emptyList();
        }
    }

    public final Collection<Statement> getAssertedStatements(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            return this.syncRequest((AsyncMultiRead)new ForEachAssertedStatement(subject, relation));
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            throw new ManyObjectsForFunctionalRelationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Collection<Resource> getPredicates(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            return this.processor.getPredicates(this, subject);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
        catch (Throwable e) {
            throw new ServiceException(e);
        }
    }

    public final Collection<Resource> getPrincipalTypes(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            AsyncMultiReadProcedure<Resource> procedure = new AsyncMultiReadProcedure<Resource>();
            this.processor.forEachPrincipalType(this, subject, procedure);
            procedure.checkAndThrow();
            return procedure;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Set<Resource> getTypes(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            return this.processor.getTypes(this, subject);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
        catch (Throwable e) {
            throw new ServiceException(e);
        }
    }

    public final Set<Resource> getSupertypes(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            SyncReadProcedure procedure = new SyncReadProcedure();
            this.processor.forSupertypes(this, subject, (AsyncProcedure<Set<Resource>>)procedure);
            procedure.checkAndThrow();
            return (Set)procedure.result;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Set<Resource> getSuperrelations(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            SyncReadProcedure procedure = new SyncReadProcedure();
            this.processor.forSuperrelations(this, subject, (AsyncProcedure<Set<Resource>>)procedure);
            procedure.checkAndThrow();
            return (Set)procedure.result;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public Resource getPossibleSuperrelation(Resource subject) throws ServiceException {
        try {
            SyncReadProcedure procedure = new SyncReadProcedure();
            this.processor.forPossibleSuperrelation(this, subject, (AsyncProcedure<Resource>)procedure);
            procedure.checkAndThrow();
            return (Resource)procedure.result;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Collection<Resource> getObjects(Resource subject, Resource relation) throws ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            AsyncMultiReadProcedure<Resource> procedure = new AsyncMultiReadProcedure<Resource>();
            this.processor.forEachObject(this, subject, relation, procedure);
            procedure.checkAndThrow();
            return procedure;
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Collection<Resource> getAssertedObjects(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        if (subject == null) {
            throw new ArgumentException("Subject must not be null.");
        }
        if (relation == null) {
            throw new ArgumentException("Relation must not be null. Subject=" + subject);
        }
        try {
            return this.syncRequest((AsyncMultiRead)new ForEachAssertedObject(subject, relation));
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            throw new ManyObjectsForFunctionalRelationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Resource getInverse(Resource relation) throws NoInverseException, ServiceException {
        assert (relation != null);
        try {
            return this.getSingleObject(relation, this.processor.querySupport.getResource(this.processor.getInverseOf()));
        }
        catch (NoSingleResultException e) {
            throw new NoInverseException((DatabaseException)((Object)e));
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final Resource getSingleObject(Resource subject, Resource relation) throws NoSingleResultException, ServiceException {
        if (subject == null) {
            throw new IllegalArgumentException("subject can not be null");
        }
        if (relation == null) {
            throw new IllegalArgumentException("relation can not be null");
        }
        try {
            int single = this.processor.getSingleObject(this, subject, relation);
            if (single == 0) {
                throw new NoSingleResultException("No single object for subject " + this.debugString(subject) + " and relation " + this.debugString(relation), single);
            }
            return this.processor.querySupport.getResource(single);
        }
        catch (NoSingleResultException e) {
            throw e;
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public final Statement getSingleStatement(Resource subject, Resource relation) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            Collection<Statement> statements = this.getStatements(subject, relation);
            if (statements.size() == 1) {
                return statements.iterator().next();
            }
            throw new NoSingleResultException("No single statement for subject " + this.debugString(subject) + " and relation " + this.debugString(relation), statements.size());
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final Resource getSingleType(Resource subject) throws NoSingleResultException, ServiceException {
        assert (subject != null);
        try {
            ArrayList principalTypes = (ArrayList)this.getPrincipalTypes(subject);
            if (principalTypes.size() == 1) {
                return (Resource)principalTypes.get(0);
            }
            throw new NoSingleResultException("No single type for subject " + this.debugString(subject), principalTypes.size());
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final Resource getSingleType(Resource subject, Resource baseType) throws NoSingleResultException, ServiceException {
        assert (subject != null);
        assert (baseType != null);
        try {
            return (Resource)this.syncRequest((AsyncRead)new SingleType(subject, baseType));
        }
        catch (DatabaseException e) {
            throw new NoSingleResultException("subject=" + subject + ", baseType=" + baseType, 0, (Throwable)e);
        }
    }

    public final <T> T getValue(Resource subject) throws DoesNotContainValueException, ServiceException {
        assert (subject != null);
        try {
            Layer0 L0 = this.processor.getL0((ReadGraph)this);
            int object = this.processor.getSingleObject(this, subject, L0.HasDataType);
            if (object == 0) {
                throw new DoesNotContainValueException("No data type for " + subject);
            }
            if (this.processor.isImmutable(object)) {
                Binding binding = (Binding)this.syncRequest((Read<T>)new DatatypeBinding(this.processor.querySupport.getResource(object)), (Listener<T>)TransientCacheListener.instance());
                return this.getValue(subject, binding);
            }
            byte[] dt = this.processor.getValue(this, object);
            if (dt == null) {
                throw new ServiceException("No data type for " + subject);
            }
            Datatype datatype = (Datatype)DATA_TYPE_SERIALIZER.deserialize(dt);
            Binding binding = Bindings.getBinding((Datatype)datatype);
            return this.getValue(subject, binding);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (DoesNotContainValueException e) {
            throw new DoesNotContainValueException((DatabaseException)((Object)e), new Resource[]{subject});
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Variant getVariantValue(Resource subject) throws DoesNotContainValueException, ServiceException {
        assert (subject != null);
        try {
            Layer0 L0 = this.processor.getL0((ReadGraph)this);
            int object = this.processor.getSingleObject(this, subject, L0.HasDataType);
            if (object == 0) {
                throw new DoesNotContainValueException("No data type for " + subject);
            }
            if (this.processor.isImmutable(object)) {
                Binding binding = (Binding)this.syncRequest((Read)new DatatypeBinding(this.processor.querySupport.getResource(object)), (Listener)TransientCacheListener.instance());
                return new Variant(binding, this.getValue(subject, binding));
            }
            byte[] dt = this.processor.getValue(this, object);
            if (dt == null) {
                throw new ServiceException("No data type for " + subject);
            }
            Datatype datatype = (Datatype)DATA_TYPE_SERIALIZER.deserialize(dt);
            Binding binding = Bindings.getBinding((Datatype)datatype);
            return new Variant(binding, this.getValue(subject, binding));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (DoesNotContainValueException e) {
            throw new DoesNotContainValueException((DatabaseException)((Object)e), new Resource[]{subject});
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    protected final Serializer getSerializer(Binding binding) {
        return binding.serializer();
    }

    public final <T> T getValue(Resource subject, Binding binding) throws DoesNotContainValueException, BindingException, ServiceException {
        assert (subject != null);
        byte[] bytes = null;
        try {
            bytes = this.processor.getValue(this, subject);
            if (bytes == null) {
                throw new DoesNotContainValueException("No value for resource " + subject);
            }
            Serializer serializer = this.getSerializer(binding);
            return (T)serializer.deserialize(bytes);
        }
        catch (DoesNotContainValueException e) {
            throw new DoesNotContainValueException((DatabaseException)((Object)e), new Resource[0]);
        }
        catch (Throwable t) {
            throw new ServiceException("Could not getValue for subject " + this.debugString(subject) + " and binding " + String.valueOf(binding) + " with bytes " + ReadGraphImpl.safeArrayToString(bytes), t);
        }
    }

    public final <T> T getRelatedValue(Resource subject, Resource relation) throws NoSingleResultException, DoesNotContainValueException, ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            Resource object = this.getSingleObject(subject, relation);
            return this.getValue(object);
        }
        catch (NoSingleResultException e) {
            throw new NoSingleResultException("No single value found for subject " + this.debugString(subject) + " and relation " + this.debugString(relation), e.getResultCount(), (Throwable)e);
        }
        catch (DoesNotContainValueException e) {
            try {
                Layer0 L0 = this.processor.getL0((ReadGraph)this);
                Resource object = this.getPossibleObject(subject, relation);
                if (this.isInstanceOf(object, L0.Value)) {
                    if (this.isInstanceOf(object, L0.Literal)) {
                        throw new DoesNotContainValueException((DatabaseException)((Object)e), new Resource[0]);
                    }
                    throw new InvalidLiteralException("The object " + object + " is not an instance of L0.Literal (use getRelatedValue2 instead)", (Throwable)e);
                }
                throw new DoesNotContainValueException("The object " + object + " is not an instance of L0.Value", (Throwable)e);
            }
            catch (DoesNotContainValueException e2) {
                throw e2;
            }
            catch (DatabaseException databaseException) {
                throw new InternalException("The client failed to analyse the cause of the following exception", (Throwable)e);
            }
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final Variant getRelatedVariantValue(Resource subject, Resource relation) throws NoSingleResultException, DoesNotContainValueException, ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            Resource object = this.getSingleObject(subject, relation);
            return this.getVariantValue(object);
        }
        catch (NoSingleResultException e) {
            throw new NoSingleResultException("No single object for subject " + this.debugString(subject) + " and relation " + this.debugString(relation), e.getResultCount(), (Throwable)e);
        }
        catch (DoesNotContainValueException e) {
            try {
                Layer0 L0 = this.processor.getL0((ReadGraph)this);
                Resource object = this.getPossibleObject(subject, relation);
                if (this.isInstanceOf(object, L0.Value)) {
                    if (this.isInstanceOf(object, L0.Literal)) {
                        throw new DoesNotContainValueException((DatabaseException)((Object)e), new Resource[0]);
                    }
                    throw new InvalidLiteralException("The object " + object + " is not an instance of L0.Literal (use getRelatedValue2 instead)", (Throwable)e);
                }
                throw new DoesNotContainValueException("The object " + object + " is not an instance of L0.Value", (Throwable)e);
            }
            catch (DoesNotContainValueException e2) {
                throw e2;
            }
            catch (DatabaseException databaseException) {
                throw new InternalException("The client failed to analyse the cause of the following exception", (Throwable)e);
            }
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final <T> T getRelatedValue(Resource subject, Resource relation, Binding binding) throws NoSingleResultException, DoesNotContainValueException, BindingException, ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            Resource object = this.getSingleObject(subject, relation);
            return this.getValue(object, binding);
        }
        catch (NoSingleResultException e) {
            String message = "";
            try {
                String subjectName = NameUtils.getSafeName((ReadGraph)this, (Resource)subject, (boolean)true);
                String relationName = NameUtils.getSafeName((ReadGraph)this, (Resource)relation, (boolean)true);
                message = "Subject: " + subjectName + ", Relation: " + relationName;
            }
            catch (DatabaseException databaseException) {}
            throw new NoSingleResultException(message, e.getResultCount(), (Throwable)e);
        }
        catch (DoesNotContainValueException e) {
            throw new DoesNotContainValueException((DatabaseException)((Object)e), new Resource[0]);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final <T> T adapt(Resource resource, Class<T> clazz) throws AdaptionException, ValidationException, ServiceException {
        assert (resource != null);
        assert (clazz != null);
        try {
            return this.syncRequest((Read<T>)new Adapter(resource, clazz));
        }
        catch (AdaptionException e) {
            throw new AdaptionException(e);
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final <T, C> T adaptContextual(Resource resource, C context, final Class<C> contextClass, Class<T> clazz) throws AdaptionException, ValidationException, ServiceException {
        assert (resource != null);
        assert (context != null);
        try {
            class ContextualAdapter
            implements AsyncRead<T> {
                private final Resource resource;
                private final C context;
                private final Class<T> clazz;

                public int hashCode() {
                    return this.resource.hashCode() + 31 * (this.clazz.hashCode() + 41 * this.context.hashCode());
                }

                public final int threadHash() {
                    return this.resource.getThreadHash();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    ContextualAdapter r = (ContextualAdapter)object;
                    return this.resource.equals(r.resource) && this.context.equals(r.context) && this.clazz.equals(r.clazz);
                }

                public int getFlags() {
                    return 0;
                }

                public ContextualAdapter(Resource resource, C context, Class<T> clazz) {
                    this.resource = resource;
                    this.context = context;
                    this.clazz = clazz;
                }

                public void perform(AsyncReadGraph graph, AsyncProcedure<T> procedure) {
                    AdaptionService service = (AdaptionService)this.getSession().peekService(AdaptionService.class);
                    if (service == null) {
                        procedure.exception(graph, (Throwable)new ServiceException("No AdaptionService available"));
                    } else {
                        service.adapt(graph, this.resource, this.context, contextClass, this.clazz, false, procedure);
                    }
                }

                public String toString() {
                    return "Adapter for (" + this.resource + "," + this.context + ") as " + this.clazz.getName();
                }
            }
            return this.syncRequest(new ContextualAdapter(resource, context, clazz));
        }
        catch (AdaptionException e) {
            throw new AdaptionException(e);
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final <T> T adaptRelated(Resource resource, Resource relation, Class<T> clazz) throws AdaptionException, NoSingleResultException, ValidationException, ServiceException {
        assert (resource != null);
        assert (clazz != null);
        Statement stm = this.getSingleStatement(resource, relation);
        T o = this.adaptContextual(stm.getObject(), new RelationContextImpl(resource, stm), RelationContext.class, clazz);
        if (clazz.isInstance(o)) {
            return o;
        }
        throw new AdaptionException("Returned value is not expected class , got " + o.getClass().getName() + " , expected " + clazz.getName());
    }

    public final <T> T getPossibleRelatedAdapter(Resource resource, Resource relation, Class<T> clazz) throws ValidationException, ServiceException {
        try {
            return this.adaptRelated(resource, relation, clazz);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public final <T, C> T getPossibleContextualAdapter(Resource resource, C context, final Class<C> contextClass, Class<T> clazz) throws ValidationException, ServiceException {
        assert (resource != null);
        assert (context != null);
        try {
            class PossibleContextualAdapter
            implements AsyncRead<T> {
                private final Resource resource;
                private final C context;
                private final Class<T> clazz;

                public int hashCode() {
                    return this.resource.hashCode() + 31 * (this.clazz.hashCode() + 41 * this.context.hashCode());
                }

                public final int threadHash() {
                    return this.resource.getThreadHash();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    PossibleContextualAdapter r = (PossibleContextualAdapter)object;
                    return this.resource.equals(r.resource) && this.context.equals(r.context) && this.clazz.equals(r.clazz);
                }

                public int getFlags() {
                    return 0;
                }

                public PossibleContextualAdapter(Resource resource, C context, Class<T> clazz) {
                    this.resource = resource;
                    this.context = context;
                    this.clazz = clazz;
                }

                public void perform(AsyncReadGraph graph, AsyncProcedure<T> procedure) {
                    AdaptionService service = (AdaptionService)this.getSession().peekService(AdaptionService.class);
                    if (service == null) {
                        procedure.exception(graph, (Throwable)new ServiceException("No AdaptionService available"));
                    } else {
                        service.adapt(graph, this.resource, this.context, contextClass, this.clazz, true, procedure);
                    }
                }

                public String toString() {
                    return "Possible adapter for (" + this.resource + "," + this.context + ") as " + this.clazz.getName();
                }
            }
            return this.syncRequest(new PossibleContextualAdapter(resource, context, clazz));
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final <T> T adaptUnique(Resource resource, Class<T> clazz) throws AdaptionException, ValidationException, ServiceException {
        assert (resource != null);
        assert (clazz != null);
        try {
            return this.syncRequest((AsyncRead<T>)new UniqueAdapter(resource, clazz));
        }
        catch (AdaptionException e) {
            throw new AdaptionException(e);
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final Resource getPossibleInverse(Resource relation) throws ServiceException {
        assert (relation != null);
        try {
            return this.getPossibleObject(relation, this.processor.querySupport.getResource(this.processor.getInverseOf()));
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public Resource getPossibleObject(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        int result;
        block6: {
            assert (subject != null);
            assert (relation != null);
            result = this.processor.getSingleObject(this, subject, relation);
            if (result != 0) break block6;
            return null;
        }
        try {
            return this.processor.querySupport.getResource(result);
        }
        catch (ManyObjectsForFunctionalRelationException manyObjectsForFunctionalRelationException) {
            throw new ManyObjectsForFunctionalRelationException("Many objects in " + subject + " for functional relation " + relation);
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public final Statement getPossibleStatement(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            Collection<Statement> statements = this.getStatements(subject, relation);
            if (statements.size() == 1) {
                return statements.iterator().next();
            }
            return null;
        }
        catch (ManyObjectsForFunctionalRelationException manyObjectsForFunctionalRelationException) {
            throw new ManyObjectsForFunctionalRelationException("Many objects in " + subject + " for functional relation " + relation);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final Resource getPossibleType(Resource subject, Resource baseType) throws ServiceException {
        assert (subject != null);
        assert (baseType != null);
        try {
            AsyncReadProcedure<Resource> procedure = new AsyncReadProcedure<Resource>();
            this.forPossibleType(subject, baseType, procedure);
            procedure.checkAndThrow();
            return (Resource)procedure.result;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final <T> T getPossibleValue(Resource subject) throws ServiceException {
        byte[] dt;
        block9: {
            int object;
            block8: {
                assert (subject != null);
                object = this.processor.getSingleObject(this, subject, this.processor.getL0((ReadGraph)this).HasDataType);
                if (object != 0) break block8;
                return null;
            }
            if (this.processor.isImmutable(object)) {
                Binding binding = (Binding)this.syncRequest((Read<T>)new DatatypeBinding(this.processor.querySupport.getResource(object)), (Listener<T>)TransientCacheListener.instance());
                return this.getPossibleValue(subject, binding);
            }
            dt = this.processor.getValue(this, object);
            if (dt != null) break block9;
            return null;
        }
        try {
            Datatype datatype = (Datatype)DATA_TYPE_SERIALIZER.deserialize(dt);
            Binding binding = Bindings.getBinding((Datatype)datatype);
            return this.getPossibleValue(subject, binding);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final <T> T getPossibleValue(Resource subject, Binding binding) throws BindingException, ServiceException {
        byte[] dt;
        block8: {
            assert (subject != null);
            assert (binding != null);
            dt = this.processor.getValue(this, subject);
            if (dt != null) break block8;
            return null;
        }
        try {
            Serializer serializer = this.getSerializer(binding);
            return (T)serializer.deserialize(dt);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (BindingException e) {
            throw new BindingException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public <T> T getPossibleRelatedValue(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Resource object;
        block6: {
            assert (subject != null);
            assert (relation != null);
            object = this.getPossibleObject(subject, relation);
            if (object != null) break block6;
            return null;
        }
        try {
            return this.getPossibleValue(object);
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            throw new ManyObjectsForFunctionalRelationException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public <T> T getPossibleRelatedValue(Resource subject, Resource relation, Binding binding) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        Resource object;
        block8: {
            assert (subject != null);
            assert (relation != null);
            assert (binding != null);
            object = this.getPossibleObject(subject, relation);
            if (object != null) break block8;
            return null;
        }
        try {
            return this.getPossibleValue(object, binding);
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            throw new ManyObjectsForFunctionalRelationException(e);
        }
        catch (BindingException e) {
            throw new BindingException(e);
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public <T> T getPossibleAdapter(Resource resource, Class<T> clazz) throws ValidationException, ServiceException {
        assert (resource != null);
        assert (clazz != null);
        try {
            return this.syncRequest((Read<T>)new PossibleAdapter(resource, clazz));
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (AdaptionException adaptionException) {
            return null;
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public <T> T getPossibleUniqueAdapter(Resource resource, Class<T> clazz) throws ValidationException, ServiceException {
        assert (resource != null);
        assert (clazz != null);
        try {
            return this.syncRequest((AsyncRead<T>)new PossibleUniqueAdapter(resource, clazz));
        }
        catch (AdaptionException adaptionException) {
            return null;
        }
        catch (ValidationException e) {
            throw new ValidationException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public final boolean isInstanceOf(Resource resource, Resource type) throws ServiceException {
        assert (resource != null);
        assert (type != null);
        Set<Resource> resources = this.getTypes(resource);
        if (resources == null) {
            return false;
        }
        return resources.contains(type);
    }

    public final boolean isInheritedFrom(Resource resource, Resource type) throws ServiceException {
        block5: {
            assert (resource != null);
            assert (type != null);
            try {
                if (!resource.equals(type)) break block5;
                return true;
            }
            catch (ServiceException e) {
                throw new ServiceException(e);
            }
        }
        return this.getSupertypes(resource).contains(type);
    }

    public final boolean isSubrelationOf(Resource resource, Resource type) throws ServiceException {
        block5: {
            assert (resource != null);
            assert (type != null);
            try {
                if (!resource.equals(type)) break block5;
                return true;
            }
            catch (ServiceException e) {
                throw new ServiceException(e);
            }
        }
        return this.getSuperrelations(resource).contains(type);
    }

    public final boolean hasStatement(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            SyncReadProcedure procedure = new SyncReadProcedure();
            this.processor.forHasStatement(this, subject, (AsyncProcedure<Boolean>)procedure);
            procedure.checkAndThrow();
            return (Boolean)procedure.result;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean hasStatement(Resource subject, Resource relation) throws ServiceException {
        assert (subject != null);
        assert (relation != null);
        try {
            Resource predicate;
            RelationInfo rinfo = this.processor.getRelationInfo(this, relation);
            Collection<Resource> predicates = this.getPredicates(subject);
            if (rinfo.isFinal) {
                return predicates.contains(relation);
            }
            if (rinfo.isFunctional) {
                try {
                    return this.processor.getSingleObject(this, subject, relation) != 0;
                }
                catch (ManyObjectsForFunctionalRelationException manyObjectsForFunctionalRelationException) {
                    return true;
                }
                catch (DatabaseException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            Iterator<Resource> iterator = this.getPredicates(subject).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.isSubrelationOf(predicate = iterator.next(), relation));
            return true;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean hasStatement(Resource subject, Resource relation, Resource object) throws ServiceException {
        assert (subject != null);
        assert (relation != null);
        assert (object != null);
        try {
            Resource o;
            Iterator<Resource> iterator = this.getObjects(subject, relation).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!object.equals(o = iterator.next()));
            return true;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
    }

    public final boolean hasValue(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            SyncReadProcedure procedure = new SyncReadProcedure();
            this.processor.forHasValue(this, subject, (AsyncProcedure<Boolean>)procedure);
            procedure.checkAndThrow();
            return (Boolean)procedure.result;
        }
        catch (ServiceException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public <T> T syncRequest(Read<T> request) throws DatabaseException {
        assert (request != null);
        return (T)QueryCache.runnerReadEntry(this, request, this.parent, null, null, true);
    }

    public <T> T syncRequest(Read<T> request, SyncListener<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncProcedure<T>)new SyncToAsyncListener(procedure));
    }

    public <T> T syncRequest(Read<T> request, Listener<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncProcedure<T>)new NoneToAsyncListener(procedure));
    }

    public <T> T syncRequest(Read<T> request, AsyncProcedure<T> procedure) throws DatabaseException {
        assert (request != null);
        ListenerBase listener = procedure != null ? this.getListenerBase(procedure) : null;
        return (T)QueryCache.runnerReadEntry(this, request, this.parent, listener, procedure, true);
    }

    public <T> T syncRequest(Read<T> request, SyncProcedure<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> T syncRequest(Read<T> request, Procedure<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> T syncRequest(AsyncRead<T> request) throws DatabaseException {
        assert (request != null);
        return this.syncRequest(request, (AsyncProcedure<T>)new AsyncProcedureAdapter());
    }

    public <T> T syncRequest(AsyncRead<T> request, AsyncListener<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncProcedure<T>)procedure);
    }

    public <T> T syncRequest(AsyncRead<T> request, SyncListener<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncListener<T>)new SyncToAsyncListener(procedure));
    }

    public <T> T syncRequest(AsyncRead<T> request, Listener<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncListener<T>)new NoneToAsyncListener(procedure));
    }

    public final <T> T syncRequest(AsyncRead<T> request, AsyncProcedure<T> procedure) throws DatabaseException {
        assert (request != null);
        ListenerBase listener = this.getListenerBase(procedure);
        return (T)QueryCache.runnerAsyncReadEntry(this, request, this.parent, listener, procedure, true);
    }

    public <T> T syncRequest(AsyncRead<T> request, SyncProcedure<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public final <T> T syncRequest(AsyncRead<T> request, Procedure<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> Collection<T> syncRequest(final MultiRead<T> request) throws DatabaseException {
        assert (request != null);
        final ArrayList result = new ArrayList();
        final DataContainer exception = new DataContainer();
        this.syncRequest(request, new SyncMultiProcedure<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ReadGraph graph, T t) {
                ArrayList arrayList = result;
                synchronized (arrayList) {
                    result.add(t);
                }
            }

            public void finished(ReadGraph graph) {
            }

            public void exception(ReadGraph graph, Throwable t) {
                exception.set((Object)t);
            }

            public String toString() {
                return "syncRequest(MultiRead) -> " + request;
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(Read)", t);
        }
        return result;
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, SyncMultiListener<T> procedure) {
        return this.syncRequest(request, (SyncMultiProcedure<T>)procedure);
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, MultiListener<T> procedure) {
        return this.syncRequest(request, (SyncMultiListener<T>)new NoneToSyncMultiListener(procedure));
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, SyncMultiProcedure<T> procedure) {
        assert (request != null);
        ListenerBase listener = this.getListenerBase(procedure);
        ResultCallWrappedSyncQueryProcedure<T> wrapper = new ResultCallWrappedSyncQueryProcedure<T>(procedure);
        if (this.parent != null || listener != null) {
            this.processor.query(this, request, this.parent, wrapper, listener);
        } else {
            try {
                request.perform((ReadGraph)this, wrapper);
            }
            catch (Throwable t) {
                wrapper.exception((ReadGraph)this, t);
            }
        }
        return wrapper.get();
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, MultiProcedure<T> procedure) {
        return this.syncRequest(request, (SyncMultiProcedure<T>)new NoneToSyncMultiProcedure(procedure));
    }

    public final <T> Collection<T> syncRequest(AsyncMultiRead<T> request) throws DatabaseException {
        assert (request != null);
        AsyncMultiReadProcedure procedure = new AsyncMultiReadProcedure();
        this.syncRequest(request, procedure);
        procedure.checkAndThrow();
        return procedure;
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, AsyncMultiListener<T> procedure) {
        return this.syncRequest(request, (AsyncMultiProcedure<T>)procedure);
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, SyncMultiListener<T> procedure) {
        return this.syncRequest(request, (AsyncMultiListener<T>)new SyncToAsyncMultiListener(procedure));
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, MultiListener<T> procedure) {
        return this.syncRequest(request, (AsyncMultiListener<T>)new NoneToAsyncMultiListener(procedure));
    }

    private final <T> void syncRequest(AsyncMultiRead<T> request, AsyncMultiReadProcedure<T> procedure) {
        assert (request != null);
        assert (procedure != null);
        ListenerBase listener = this.getListenerBase(procedure);
        if (this.parent != null || listener != null) {
            this.processor.query(this, request, this.parent, procedure, listener);
            this.waitAsyncProcedure(procedure);
        } else {
            try {
                request.perform((AsyncReadGraph)this, procedure);
                this.waitAsyncProcedure(procedure);
            }
            catch (Throwable throwable) {
                this.waitAsyncProcedure(procedure);
            }
        }
    }

    public final <T> Collection<T> syncRequest(AsyncMultiRead<T> request, final AsyncMultiProcedure<T> procedure) {
        assert (request != null);
        assert (procedure != null);
        ListenerBase listener = this.getListenerBase(procedure);
        if (this.parent != null || listener != null) {
            this.processor.query(this, request, this.parent, procedure, listener);
        } else {
            try {
                request.perform((AsyncReadGraph)this, new AsyncMultiProcedure<T>(){

                    public void execute(AsyncReadGraph graph, T result) {
                        procedure.execute(graph, result);
                    }

                    public void finished(AsyncReadGraph graph) {
                        procedure.finished(graph);
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        procedure.exception(graph, t);
                    }

                    public String toString() {
                        return "syncRequest(AsyncMultiRead) -> " + procedure;
                    }
                });
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, SyncMultiProcedure<T> procedure) {
        return this.syncRequest(request, (AsyncMultiProcedure<T>)new SyncToAsyncMultiProcedure(procedure));
    }

    public final <T> Collection<T> syncRequest(AsyncMultiRead<T> request, MultiProcedure<T> procedure) {
        return this.syncRequest(request, (AsyncMultiProcedure<T>)new NoneToAsyncMultiProcedure(procedure));
    }

    public <T> T syncRequest(final ExternalRead<T> request) throws DatabaseException {
        assert (request != null);
        return this.syncRequest(request, new Procedure<T>(){

            public void execute(T t) {
            }

            public void exception(Throwable t) {
            }

            public String toString() {
                return "syncRequest(AsyncRead) -> " + request;
            }
        });
    }

    public <T> T syncRequest(ExternalRead<T> request, Listener<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (Procedure<T>)procedure);
    }

    public final <T> T syncRequest(ExternalRead<T> request, Procedure<T> procedure) throws DatabaseException {
        assert (request != null);
        ListenerBase listener = procedure != null ? this.getListenerBase(procedure) : null;
        return QueryCache.resultExternalReadEntry(this, request, this.parent, listener, procedure);
    }

    public void syncRequest(Write request) throws DatabaseException {
        assert (request != null);
        throw new DatabaseException("Write operations are not supported during read transactions!");
    }

    public <T> T syncRequest(WriteResult<T> request) throws DatabaseException {
        assert (request != null);
        throw new DatabaseException("Write operations are not supported during read transactions!");
    }

    public void syncRequest(DelayedWrite request) throws DatabaseException {
        assert (request != null);
        throw new DatabaseException("Write operations are not supported during read transactions!");
    }

    public <T> T syncRequest(DelayedWriteResult<T> request) throws DatabaseException {
        assert (request != null);
        throw new DatabaseException("Write operations are not supported during read transactions!");
    }

    public void syncRequest(WriteOnly request) throws DatabaseException {
        assert (request != null);
        throw new DatabaseException("Write operations are not supported during read transactions!");
    }

    public <T> T syncRequest(WriteOnlyResult<T> request) throws DatabaseException {
        assert (request != null);
        throw new DatabaseException("Write operations are not supported during read transactions!");
    }

    public <T> void async(ReadInterface<T> r, AsyncProcedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, Procedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, SyncProcedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, AsyncListener<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, Listener<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, SyncListener<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> T sync(ReadInterface<T> r) throws DatabaseException {
        return (T)r.request((RequestProcessor)this);
    }

    public <T> T sync(WriteInterface<T> r) throws DatabaseException {
        return (T)r.request((RequestProcessor)this);
    }

    public <T> void async(WriteInterface<T> r, Procedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(WriteInterface<T> r) {
        r.request((AsyncRequestProcessor)this, (Procedure)new ProcedureAdapter());
    }

    public void forURI(Resource resource, AsyncListener<String> listener) {
        this.asyncRequest((Read)new ResourceToURI(resource), (AsyncListener)listener);
    }

    public void forURI(Resource resource, SyncListener<String> listener) {
        this.asyncRequest((Read)new ResourceToURI(resource), (SyncListener)listener);
    }

    public void forURI(Resource resource, Listener<String> listener) {
        this.asyncRequest((Read)new ResourceToURI(resource), (Listener)listener);
    }

    public final void forURI(Resource resource, AsyncProcedure<String> procedure) {
        assert (resource != null);
        assert (procedure != null);
        this.asyncRequest((Read)new ResourceToURI(resource), (AsyncProcedure)procedure);
    }

    public void forURI(Resource resource, SyncProcedure<String> procedure) {
        this.forURI(resource, (AsyncProcedure<String>)new SyncToAsyncProcedure(procedure));
    }

    public void forURI(Resource resource, Procedure<String> procedure) {
        this.forURI(resource, (AsyncProcedure<String>)new NoneToAsyncProcedure(procedure));
    }

    public void forResource(String id, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new org.simantics.db.common.primitiverequest.Resource(id), (AsyncListener)listener);
    }

    public void forResource(String id, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new org.simantics.db.common.primitiverequest.Resource(id), (SyncListener)listener);
    }

    public void forResource(String id, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new org.simantics.db.common.primitiverequest.Resource(id), (Listener)listener);
    }

    public final void forResource(String id, AsyncProcedure<Resource> procedure) {
        assert (id != null);
        assert (procedure != null);
        this.processor.forResource(this, id, procedure);
    }

    public void forResource(String id, SyncProcedure<Resource> procedure) {
        this.forResource(id, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forResource(String id, Procedure<Resource> procedure) {
        this.forResource(id, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public void forBuiltin(String id, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new Builtin(id), (AsyncListener)listener);
    }

    public void forBuiltin(String id, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new Builtin(id), (SyncListener)listener);
    }

    public void forBuiltin(String id, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new Builtin(id), (Listener)listener);
    }

    public final void forBuiltin(String id, AsyncProcedure<Resource> procedure) {
        assert (id != null);
        assert (procedure != null);
        this.processor.forBuiltin(this, id, procedure);
    }

    public void forBuiltin(String id, SyncProcedure<Resource> procedure) {
        this.forBuiltin(id, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forBuiltin(String id, Procedure<Resource> procedure) {
        this.forBuiltin(id, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public final void forEachStatement(Resource subject, Resource relation, AsyncMultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachStatement(this, subject, relation, procedure);
    }

    public void forEachStatement(Resource subject, Resource relation, SyncMultiProcedure<Statement> procedure) {
        this.forEachStatement(subject, relation, (AsyncMultiProcedure<Statement>)new SyncToAsyncMultiProcedure(procedure));
    }

    public final void forEachStatement(Resource subject, Resource relation, MultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachStatement(this, subject, relation, procedure);
    }

    public final void forStatementSet(Resource subject, Resource relation, AsyncSetListener<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forStatementSet(this, subject, relation, procedure);
    }

    public final void forStatementSet(Resource subject, Resource relation, SyncSetListener<Statement> procedure) {
        this.forStatementSet(subject, relation, (AsyncSetListener<Statement>)new SyncToAsyncSetProcedure(procedure));
    }

    public void forStatementSet(Resource subject, Resource relation, SetListener<Statement> listener) {
        this.forStatementSet(subject, relation, (AsyncSetListener<Statement>)new NoneToAsyncSetProcedure(listener));
    }

    public final void forEachAssertedStatement(Resource subject, Resource relation, AsyncMultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachAssertedStatement(this, subject, relation, procedure);
    }

    public void forEachAssertedStatement(Resource subject, Resource relation, SyncMultiProcedure<Statement> procedure) {
        this.forEachAssertedStatement(subject, relation, (AsyncMultiProcedure<Statement>)new SyncToAsyncMultiProcedure(procedure));
    }

    public void forEachAssertedStatement(Resource subject, Resource relation, MultiProcedure<Statement> procedure) {
        this.forEachAssertedStatement(subject, relation, (AsyncMultiProcedure<Statement>)new NoneToAsyncMultiProcedure(procedure));
    }

    public void forAssertedStatementSet(Resource subject, Resource relation, AsyncSetListener<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forAssertedStatementSet(this, subject, relation, procedure);
    }

    public void forAssertedStatementSet(Resource subject, Resource relation, SyncSetListener<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forAssertedStatementSet(subject, relation, (AsyncSetListener<Statement>)new SyncToAsyncSetProcedure(procedure));
    }

    public void forAssertedStatementSet(Resource subject, Resource relation, SetListener<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forAssertedStatementSet(subject, relation, (AsyncSetListener<Statement>)new NoneToAsyncSetProcedure(procedure));
    }

    public final void forEachPredicate(Resource subject, AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forEachPredicate(this, subject, procedure);
    }

    public void forEachPredicate(Resource subject, SyncMultiProcedure<Resource> procedure) {
        this.forEachPredicate(subject, (AsyncMultiProcedure<Resource>)new SyncToAsyncMultiProcedure(procedure));
    }

    public final void forEachPredicate(Resource subject, MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forEachPredicate(this, subject, procedure);
    }

    public final void forPredicateSet(Resource subject, AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forPredicateSet(this, subject, procedure);
    }

    public final void forPredicateSet(Resource subject, SyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forPredicateSet(subject, (AsyncSetListener<Resource>)new SyncToAsyncSetProcedure(procedure));
    }

    public final void forPredicateSet(Resource subject, SetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forPredicateSet(subject, (AsyncSetListener<Resource>)new NoneToAsyncSetProcedure(procedure));
    }

    public final void forEachPrincipalType(Resource subject, AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forEachPrincipalType(this, subject, procedure);
    }

    public void forEachPrincipalType(Resource subject, SyncMultiProcedure<Resource> procedure) {
        this.forEachPrincipalType(subject, (AsyncMultiProcedure<Resource>)new SyncToAsyncMultiProcedure(procedure));
    }

    public final void forEachPrincipalType(Resource subject, MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forEachPrincipalType(this, subject, procedure);
    }

    public final void forPrincipalTypeSet(Resource subject, AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forPrincipalTypeSet(this, subject, procedure);
    }

    public final void forPrincipalTypeSet(Resource subject, SyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forPrincipalTypeSet(subject, (AsyncSetListener<Resource>)new SyncToAsyncSetProcedure(procedure));
    }

    public final void forPrincipalTypeSet(Resource subject, SetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forPrincipalTypeSet(subject, (AsyncSetListener<Resource>)new NoneToAsyncSetProcedure(procedure));
    }

    public void forTypes(Resource subject, AsyncListener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (AsyncListener)listener);
    }

    public void forTypes(Resource subject, SyncListener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (SyncListener)listener);
    }

    public void forTypes(Resource subject, Listener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (Listener)listener);
    }

    public final void forTypes(Resource subject, AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forTypes(this, subject, procedure);
    }

    public void forTypes(Resource subject, SyncProcedure<Set<Resource>> procedure) {
        this.forTypes(subject, (AsyncProcedure<Set<Resource>>)new SyncToAsyncProcedure(procedure));
    }

    public void forTypes(Resource subject, Procedure<Set<Resource>> procedure) {
        this.forTypes(subject, (AsyncProcedure<Set<Resource>>)new NoneToAsyncProcedure(procedure));
    }

    public void forSupertypes(Resource subject, AsyncListener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (AsyncListener)listener);
    }

    public void forSupertypes(Resource subject, SyncListener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (SyncListener)listener);
    }

    public void forSupertypes(Resource subject, Listener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (Listener)listener);
    }

    public final void forSupertypes(Resource subject, AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forSupertypes(this, subject, procedure);
    }

    public void forSupertypes(Resource subject, SyncProcedure<Set<Resource>> procedure) {
        this.forSupertypes(subject, (AsyncProcedure<Set<Resource>>)new SyncToAsyncProcedure(procedure));
    }

    public void forSupertypes(Resource subject, Procedure<Set<Resource>> procedure) {
        this.forSupertypes(subject, (AsyncProcedure<Set<Resource>>)new NoneToAsyncProcedure(procedure));
    }

    public void forDirectSuperrelations(Resource subject, AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forDirectSuperrelations(this, subject, procedure);
    }

    public void forPossibleSuperrelation(Resource subject, AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forPossibleSuperrelation(this, subject, procedure);
    }

    public void forSuperrelations(Resource subject, AsyncListener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (AsyncListener)listener);
    }

    public void forSuperrelations(Resource subject, SyncListener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (SyncListener)listener);
    }

    public void forSuperrelations(Resource subject, Listener<Set<Resource>> listener) {
        this.asyncRequest((AsyncRead)new Types(subject), (Listener)listener);
    }

    public final void forSuperrelations(Resource subject, AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forSuperrelations(this, subject, procedure);
    }

    public void forSuperrelations(Resource subject, SyncProcedure<Set<Resource>> procedure) {
        this.forSuperrelations(subject, (AsyncProcedure<Set<Resource>>)new SyncToAsyncProcedure(procedure));
    }

    public void forSuperrelations(Resource subject, Procedure<Set<Resource>> procedure) {
        this.forSuperrelations(subject, (AsyncProcedure<Set<Resource>>)new NoneToAsyncProcedure(procedure));
    }

    public final void forEachObject(Resource subject, Resource relation, AsyncMultiProcedure<Resource> procedure) {
        this.processor.forEachObject(this, subject, relation, procedure);
    }

    public void forEachObject(Resource subject, Resource relation, SyncMultiProcedure<Resource> procedure) {
        this.forEachObject(subject, relation, (AsyncMultiProcedure<Resource>)new SyncToAsyncMultiProcedure(procedure));
    }

    public void forEachObject(Resource subject, Resource relation, MultiProcedure<Resource> procedure) {
        this.processor.forEachObject(this, subject, relation, procedure);
    }

    public final void forEachDirectPredicate(Resource subject, AsyncProcedure<Set<Resource>> procedure) {
        this.processor.forEachDirectPredicate(this, subject, procedure);
    }

    public final void forEachDirectPredicate(Resource subject, SyncProcedure<Set<Resource>> procedure) {
        this.forEachDirectPredicate(subject, (AsyncProcedure<Set<Resource>>)new SyncToAsyncProcedure(procedure));
    }

    public void forEachDirectPredicate(Resource subject, Procedure<Set<Resource>> procedure) {
        this.forEachDirectPredicate(subject, (AsyncProcedure<Set<Resource>>)new NoneToAsyncProcedure(procedure));
    }

    public final void forObjectSet(Resource subject, Resource relation, AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forObjectSet(this, subject, relation, procedure);
    }

    public final void forObjectSet(Resource subject, Resource relation, SyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forObjectSet(subject, relation, (AsyncSetListener<Resource>)new SyncToAsyncSetProcedure(procedure));
    }

    public final void forObjectSet(Resource subject, Resource relation, SetListener<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forObjectSet(subject, relation, (AsyncSetListener<Resource>)new NoneToAsyncSetProcedure(procedure));
    }

    public final void forEachAssertedObject(Resource subject, Resource relation, AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachAssertedObject(this, subject, relation, procedure);
    }

    public void forEachAssertedObject(Resource subject, Resource relation, SyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forEachAssertedObject(subject, relation, (AsyncMultiProcedure<Resource>)new SyncToAsyncMultiProcedure(procedure));
    }

    public void forEachAssertedObject(Resource subject, Resource relation, MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forEachAssertedObject(subject, relation, (AsyncMultiProcedure<Resource>)new NoneToAsyncMultiProcedure(procedure));
    }

    public void forAssertedObjectSet(Resource subject, Resource relation, AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forAssertedObjectSet(this, subject, relation, procedure);
    }

    public void forAssertedObjectSet(Resource subject, Resource relation, SyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forAssertedObjectSet(subject, relation, (AsyncSetListener<Resource>)new SyncToAsyncSetProcedure(procedure));
    }

    public void forAssertedObjectSet(Resource subject, Resource relation, SetListener<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.forAssertedObjectSet(subject, relation, (AsyncSetListener<Resource>)new NoneToAsyncSetProcedure(procedure));
    }

    public void forInverse(Resource relation, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new Inverse(relation), (AsyncListener)listener);
    }

    public void forInverse(Resource relation, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new Inverse(relation), (SyncListener)listener);
    }

    public void forInverse(Resource relation, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new Inverse(relation), (Listener)listener);
    }

    public final void forInverse(final Resource relation, final AsyncProcedure<Resource> procedure) {
        assert (relation != null);
        assert (procedure != null);
        this.processor.forInverse(this, relation, new AsyncProcedure<Resource>(){

            public void execute(AsyncReadGraph graph, Resource result) {
                if (result != null) {
                    procedure.execute(graph, (Object)result);
                } else {
                    procedure.exception(graph, (Throwable)new NoInverseException(relation.toString()));
                }
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public String toString() {
                return "forInverse -> " + procedure;
            }
        });
    }

    public void forInverse(Resource relation, SyncProcedure<Resource> procedure) {
        this.forInverse(relation, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forInverse(Resource relation, Procedure<Resource> procedure) {
        this.forInverse(relation, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public void forSingleObject(Resource subject, Resource relation, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleObject(subject, relation), (AsyncListener)listener);
    }

    public void forSingleObject(Resource subject, Resource relation, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleObject(subject, relation), (SyncListener)listener);
    }

    public void forSingleObject(Resource subject, Resource relation, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleObject(subject, relation), (Listener)listener);
    }

    public final void forSingleObject(Resource subject, Resource relation, AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachObject(this, subject, relation, (AsyncMultiProcedure<Resource>)new SingleOrErrorProcedure(procedure));
    }

    public void forSingleObject(Resource subject, Resource relation, SyncProcedure<Resource> procedure) {
        this.forSingleObject(subject, relation, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forSingleObject(Resource subject, Resource relation, Procedure<Resource> procedure) {
        this.forSingleObject(subject, relation, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public void forSingleStatement(Resource subject, Resource relation, AsyncListener<Statement> listener) {
        this.asyncRequest((AsyncRead)new SingleStatement(subject, relation), (AsyncListener)listener);
    }

    public void forSingleStatement(Resource subject, Resource relation, SyncListener<Statement> listener) {
        this.asyncRequest((AsyncRead)new SingleStatement(subject, relation), (SyncListener)listener);
    }

    public void forSingleStatement(Resource subject, Resource relation, Listener<Statement> listener) {
        this.asyncRequest((AsyncRead)new SingleStatement(subject, relation), (Listener)listener);
    }

    public final void forSingleStatement(Resource subject, Resource relation, AsyncProcedure<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachStatement(this, subject, relation, (AsyncMultiProcedure<Statement>)new SingleOrErrorProcedure(procedure));
    }

    public void forSingleStatement(Resource subject, Resource relation, SyncProcedure<Statement> procedure) {
        this.forSingleStatement(subject, relation, (AsyncProcedure<Statement>)new SyncToAsyncProcedure(procedure));
    }

    public void forSingleStatement(Resource subject, Resource relation, Procedure<Statement> procedure) {
        this.forSingleStatement(subject, relation, (AsyncProcedure<Statement>)new NoneToAsyncProcedure(procedure));
    }

    public void forSingleType(Resource subject, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleTypeAny(subject), (AsyncListener)listener);
    }

    public void forSingleType(Resource subject, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleTypeAny(subject), (SyncListener)listener);
    }

    public void forSingleType(Resource subject, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleTypeAny(subject), (Listener)listener);
    }

    public final void forSingleType(Resource subject, final AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        final DeepSingleOrErrorProcedure checkedProcedure = new DeepSingleOrErrorProcedure(procedure);
        this.processor.forEachPrincipalType(this, subject, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){

            public void execute(AsyncReadGraph graph, Resource principalType) {
                checkedProcedure.offer(graph, (Object)principalType);
            }

            public void finished(AsyncReadGraph graph) {
                checkedProcedure.dec(graph);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                checkedProcedure.exception(graph, t);
            }

            public String toString() {
                return "forSingleType -> " + procedure;
            }
        });
    }

    public void forSingleType(Resource subject, SyncProcedure<Resource> procedure) {
        this.forSingleType(subject, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forSingleType(Resource subject, Procedure<Resource> procedure) {
        this.forSingleType(subject, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public void forSingleType(Resource subject, Resource relation, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleType(subject, relation), (AsyncListener)listener);
    }

    public void forSingleType(Resource subject, Resource relation, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleType(subject, relation), (SyncListener)listener);
    }

    public void forSingleType(Resource subject, Resource relation, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new SingleType(subject, relation), (Listener)listener);
    }

    public final void forSingleType(Resource subject, final Resource baseType, final AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        final DeepSingleOrErrorProcedure checkedProcedure = new DeepSingleOrErrorProcedure(procedure);
        this.processor.forEachPrincipalType(this, subject, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){

            public void execute(AsyncReadGraph graph, final Resource principalType) {
                checkedProcedure.inc();
                if (baseType == null) {
                    checkedProcedure.offer(graph, (Object)principalType);
                    checkedProcedure.dec(graph);
                } else if (principalType.equals(baseType)) {
                    checkedProcedure.offer(graph, (Object)principalType);
                    checkedProcedure.dec(graph);
                } else {
                    ReadGraphImpl.this.processor.forSupertypes((ReadGraphImpl)graph, principalType, new AsyncProcedure<Set<Resource>>(){

                        public void execute(AsyncReadGraph graph, Set<Resource> result) {
                            if (result.contains(baseType)) {
                                checkedProcedure.offer(graph, (Object)principalType);
                            }
                            checkedProcedure.dec(graph);
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            checkedProcedure.exception(graph, t);
                        }
                    });
                }
            }

            public void finished(AsyncReadGraph graph) {
                checkedProcedure.dec(graph);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                checkedProcedure.exception(graph, t);
            }

            public String toString() {
                return "forSingleType -> " + procedure;
            }
        });
    }

    public void forSingleType(Resource subject, Resource relation, SyncProcedure<Resource> procedure) {
        this.forSingleType(subject, relation, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forSingleType(Resource subject, Resource relation, Procedure<Resource> procedure) {
        this.forSingleType(subject, relation, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forValue(Resource subject, Binding binding, AsyncListener<T> listener) {
        this.asyncRequest((Read<T>)new Value(subject, binding), listener);
    }

    public <T> void forValue(Resource subject, Binding binding, SyncListener<T> listener) {
        this.asyncRequest((Read<T>)new Value(subject, binding), listener);
    }

    public <T> void forValue(Resource subject, Binding binding, Listener<T> listener) {
        this.asyncRequest((Read<T>)new Value(subject, binding), listener);
    }

    public <T> void forValue(final Resource resource, final Binding binding, final AsyncProcedure<T> procedure) {
        assert (resource != null);
        assert (binding != null);
        assert (procedure != null);
        this.processor.forValue(this, resource, new AsyncProcedure<byte[]>(){

            public void execute(AsyncReadGraph graph, byte[] result) {
                try {
                    if (result == null) {
                        procedure.exception(graph, (Throwable)new DoesNotContainValueException("No value for resource " + resource));
                        return;
                    }
                    Serializer serializer = binding.serializer();
                    Object obj = serializer.deserialize(result);
                    procedure.execute(graph, obj);
                }
                catch (Throwable t) {
                    procedure.exception(graph, (Throwable)new ServiceException("Could not forValue for subject " + ReadGraphImpl.this.debugString(resource) + " and binding " + String.valueOf(binding) + " with bytes " + ReadGraphImpl.safeArrayToString(result), t));
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return "forValue -> " + procedure;
            }
        });
    }

    private static String safeArrayToString(byte[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (i < 100) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
        return b.append(", ... (" + a.length + ")]").toString();
    }

    public <T> void forValue(Resource subject, Binding binding, SyncProcedure<T> procedure) {
        this.forValue(subject, binding, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forValue(Resource subject, Binding binding, Procedure<T> procedure) {
        this.forValue(subject, binding, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forValue(Resource subject, AsyncListener<T> listener) {
        this.asyncRequest((Read<T>)new ValueImplied(subject), listener);
    }

    public <T> void forValue(Resource subject, SyncListener<T> listener) {
        this.asyncRequest((Read<T>)new ValueImplied(subject), listener);
    }

    public <T> void forValue(Resource subject, Listener<T> listener) {
        this.asyncRequest((Read<T>)new ValueImplied(subject), listener);
    }

    public final <T> void forValue(final Resource subject, final AsyncProcedure<T> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forRelatedValue(subject, this.processor.getL0((ReadGraph)this).HasDataType, DATA_TYPE_BINDING_INTERNAL, new AsyncProcedure<Datatype>(){

            public void execute(AsyncReadGraph graph, Datatype type) {
                Binding binding = Bindings.getBinding((Datatype)type);
                graph.forValue(subject, binding, procedure);
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, (Throwable)new DoesNotContainValueException("Invalid data type", throwable));
            }
        });
    }

    public <T> void forValue(Resource subject, SyncProcedure<T> procedure) {
        this.forValue(subject, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forValue(Resource subject, Procedure<T> procedure) {
        this.forValue(subject, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, AsyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new RelatedValueImplied(subject, relation), listener);
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, SyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new RelatedValueImplied(subject, relation), listener);
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, Listener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new RelatedValueImplied(subject, relation), listener);
    }

    public final <T> void forRelatedValue(Resource subject, Resource relation, final AsyncProcedure<T> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        final DeepSingleOrErrorProcedure checkedProcedure = new DeepSingleOrErrorProcedure(procedure);
        this.processor.forEachObject(this, subject, relation, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){

            public void execute(AsyncReadGraph graph, Resource object) {
                checkedProcedure.inc();
                graph.forValue(object, (AsyncProcedure)new AsyncProcedure<Object>(){

                    public void execute(AsyncReadGraph graph, Object result) {
                        checkedProcedure.offer(graph, result);
                        checkedProcedure.dec(graph);
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        checkedProcedure.exception(graph, t);
                    }

                    public String toString() {
                        return "forRelatedValue -> " + procedure;
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                checkedProcedure.dec(graph);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                checkedProcedure.exception(graph, t);
            }
        });
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, SyncProcedure<T> procedure) {
        this.forRelatedValue(subject, relation, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, Procedure<T> procedure) {
        this.forRelatedValue(subject, relation, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, Binding binding, AsyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new RelatedValue(subject, relation, binding), listener);
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, Binding binding, SyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new RelatedValue(subject, relation, binding), listener);
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, Binding binding, Listener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new RelatedValue(subject, relation, binding), listener);
    }

    public final <T> void forRelatedValue(Resource subject, Resource relation, final Binding binding, final AsyncProcedure<T> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (binding != null);
        assert (procedure != null);
        final DeepSingleOrErrorProcedure checkedProcedure = new DeepSingleOrErrorProcedure(procedure);
        this.processor.forEachObject(this, subject, relation, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){

            public void execute(AsyncReadGraph graph, Resource object) {
                checkedProcedure.inc();
                graph.forValue(object, binding, (AsyncProcedure)new AsyncProcedure<Object>(){

                    public void execute(AsyncReadGraph graph, Object result) {
                        checkedProcedure.offer(graph, result);
                        checkedProcedure.dec(graph);
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        checkedProcedure.exception(graph, t);
                    }

                    public String toString() {
                        return "forRelatedValue -> " + procedure;
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                checkedProcedure.dec(graph);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                checkedProcedure.exception(graph, t);
            }
        });
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, Binding binding, SyncProcedure<T> procedure) {
        this.forRelatedValue(subject, relation, binding, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forRelatedValue(Resource subject, Resource relation, Binding binding, Procedure<T> procedure) {
        this.forRelatedValue(subject, relation, binding, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forAdapted(Resource resource, Class<T> clazz, AsyncListener<T> listener) {
        this.asyncRequest((Read<T>)new Adapter(resource, clazz), listener);
    }

    public <T> void forAdapted(Resource resource, Class<T> clazz, SyncListener<T> listener) {
        this.asyncRequest((Read<T>)new Adapter(resource, clazz), listener);
    }

    public <T> void forAdapted(Resource resource, Class<T> clazz, Listener<T> listener) {
        this.asyncRequest((Read<T>)new Adapter(resource, clazz), listener);
    }

    public final <T> void forAdapted(Resource resource, Class<T> clazz, AsyncProcedure<T> procedure) {
        assert (resource != null);
        assert (clazz != null);
        assert (procedure != null);
        AdaptionService service = (AdaptionService)this.getSession().peekService(AdaptionService.class);
        if (service == null) {
            procedure.exception((AsyncReadGraph)this, (Throwable)new ServiceException("No AdaptionService available"));
        } else {
            service.adapt((AsyncReadGraph)this, resource, (Object)resource, Resource.class, clazz, false, procedure);
        }
    }

    public <T> void forAdapted(Resource resource, Class<T> clazz, SyncProcedure<T> procedure) {
        this.forAdapted(resource, clazz, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forAdapted(Resource resource, Class<T> clazz, Procedure<T> procedure) {
        this.forAdapted(resource, clazz, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forUniqueAdapted(Resource resource, Class<T> clazz, AsyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new UniqueAdapter(resource, clazz), listener);
    }

    public <T> void forUniqueAdapted(Resource resource, Class<T> clazz, SyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new UniqueAdapter(resource, clazz), listener);
    }

    public <T> void forUniqueAdapted(Resource resource, Class<T> clazz, Listener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new UniqueAdapter(resource, clazz), listener);
    }

    public final <T> void forUniqueAdapted(Resource resource, Class<T> clazz, AsyncProcedure<T> procedure) {
        assert (resource != null);
        assert (clazz != null);
        assert (procedure != null);
        AdaptionService service = (AdaptionService)this.getSession().peekService(AdaptionService.class);
        if (service == null) {
            procedure.exception((AsyncReadGraph)this, (Throwable)new ServiceException("No AdaptionService available"));
        } else {
            service.adaptNew((AsyncReadGraph)this, resource, clazz, false, procedure);
        }
    }

    public <T> void forUniqueAdapted(Resource resource, Class<T> clazz, SyncProcedure<T> procedure) {
        this.forUniqueAdapted(resource, clazz, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forUniqueAdapted(Resource resource, Class<T> clazz, Procedure<T> procedure) {
        this.forUniqueAdapted(resource, clazz, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public void forPossibleInverse(Resource subject, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleInverse(subject), (AsyncListener)listener);
    }

    public void forPossibleInverse(Resource subject, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleInverse(subject), (SyncListener)listener);
    }

    public void forPossibleInverse(Resource subject, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleInverse(subject), (Listener)listener);
    }

    public final void forPossibleInverse(Resource relation, AsyncProcedure<Resource> procedure) {
        assert (relation != null);
        assert (procedure != null);
        this.processor.forInverse(this, relation, (AsyncProcedure<Resource>)new ExceptionToNullProcedure(procedure));
    }

    public void forPossibleInverse(Resource subject, SyncProcedure<Resource> procedure) {
        this.forPossibleInverse(subject, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forPossibleInverse(Resource subject, Procedure<Resource> procedure) {
        this.forPossibleInverse(subject, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public void forPossibleObject(Resource subject, Resource relation, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleObject(subject, relation), (AsyncListener)listener);
    }

    public void forPossibleObject(Resource subject, Resource relation, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleObject(subject, relation), (SyncListener)listener);
    }

    public void forPossibleObject(Resource subject, Resource relation, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleObject(subject, relation), (Listener)listener);
    }

    public final void forPossibleObject(Resource subject, Resource relation, AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachObject(this, subject, relation, (AsyncMultiProcedure<Resource>)new SingleOrNullProcedure(procedure));
    }

    public void forPossibleObject(Resource subject, Resource relation, SyncProcedure<Resource> procedure) {
        this.forPossibleObject(subject, relation, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forPossibleObject(Resource subject, Resource relation, Procedure<Resource> procedure) {
        this.forPossibleObject(subject, relation, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public void forPossibleStatement(Resource subject, Resource relation, AsyncListener<Statement> listener) {
        this.asyncRequest((AsyncRead)new PossibleStatement(subject, relation), (AsyncListener)listener);
    }

    public void forPossibleStatement(Resource subject, Resource relation, SyncListener<Statement> listener) {
        this.asyncRequest((AsyncRead)new PossibleStatement(subject, relation), (SyncListener)listener);
    }

    public void forPossibleStatement(Resource subject, Resource relation, Listener<Statement> listener) {
        this.asyncRequest((AsyncRead)new PossibleStatement(subject, relation), (Listener)listener);
    }

    public final void forPossibleStatement(Resource subject, Resource relation, AsyncProcedure<Statement> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forEachStatement(this, subject, relation, (AsyncMultiProcedure<Statement>)new SingleFunctionalOrNullProcedure("forPossibleStatement", procedure));
    }

    public void forPossibleStatement(Resource subject, Resource relation, SyncProcedure<Statement> procedure) {
        this.forPossibleStatement(subject, relation, (AsyncProcedure<Statement>)new SyncToAsyncProcedure(procedure));
    }

    public void forPossibleStatement(Resource subject, Resource relation, Procedure<Statement> procedure) {
        this.forPossibleStatement(subject, relation, (AsyncProcedure<Statement>)new NoneToAsyncProcedure(procedure));
    }

    public void forPossibleType(Resource subject, Resource relation, AsyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleType(subject, relation), (AsyncListener)listener);
    }

    public void forPossibleType(Resource subject, Resource relation, SyncListener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleType(subject, relation), (SyncListener)listener);
    }

    public void forPossibleType(Resource subject, Resource relation, Listener<Resource> listener) {
        this.asyncRequest((AsyncRead)new PossibleType(subject, relation), (Listener)listener);
    }

    public final void forPossibleType(Resource subject, final Resource baseType, final AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        final NullSingleOrNullProcedure checkedProcedure = new NullSingleOrNullProcedure(procedure);
        this.processor.forEachPrincipalType(this, subject, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){

            public void execute(AsyncReadGraph graph, final Resource principalType) {
                if (baseType == null) {
                    checkedProcedure.offer(graph, (Object)principalType);
                } else if (principalType.equals(baseType)) {
                    checkedProcedure.offer(graph, (Object)principalType);
                } else {
                    checkedProcedure.inc();
                    ReadGraphImpl.this.processor.forSupertypes((ReadGraphImpl)graph, principalType, new AsyncProcedure<Set<Resource>>(){

                        public void execute(AsyncReadGraph graph, Set<Resource> result) {
                            if (result.contains(baseType)) {
                                checkedProcedure.offer(graph, (Object)principalType);
                            }
                            checkedProcedure.dec(graph);
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            checkedProcedure.exception(graph, t);
                            checkedProcedure.dec(graph);
                        }

                        public String toString() {
                            return "forPossibleType -> " + procedure;
                        }
                    });
                }
            }

            public void finished(AsyncReadGraph graph) {
                checkedProcedure.dec(graph);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                checkedProcedure.exception(graph, t);
                checkedProcedure.dec(graph);
            }
        });
    }

    public void forPossibleType(Resource subject, Resource relation, SyncProcedure<Resource> procedure) {
        this.forPossibleType(subject, relation, (AsyncProcedure<Resource>)new SyncToAsyncProcedure(procedure));
    }

    public void forPossibleType(Resource subject, Resource relation, Procedure<Resource> procedure) {
        this.forPossibleType(subject, relation, (AsyncProcedure<Resource>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forPossibleValue(Resource subject, AsyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleValueImplied(subject), listener);
    }

    public <T> void forPossibleValue(Resource subject, SyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleValueImplied(subject), listener);
    }

    public <T> void forPossibleValue(Resource subject, Listener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleValueImplied(subject), listener);
    }

    public final <T> void forPossibleValue(final Resource subject, final AsyncProcedure<T> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forPossibleRelatedValue(subject, this.processor.getL0((ReadGraph)this).HasDataType, DATA_TYPE_BINDING_INTERNAL, new AsyncProcedure<Datatype>(){

            public void execute(AsyncReadGraph graph, Datatype type) {
                if (type == null) {
                    procedure.execute(graph, null);
                } else {
                    try {
                        Binding binding = Bindings.getBinding((Datatype)type);
                        graph.forPossibleValue(subject, binding, procedure);
                    }
                    catch (RuntimeBindingConstructionException e) {
                        procedure.exception(graph, (Throwable)e);
                    }
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forPossibleValue -> " + procedure;
            }
        });
    }

    public <T> void forPossibleValue(Resource subject, SyncProcedure<T> procedure) {
        this.forPossibleValue(subject, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forPossibleValue(Resource subject, Procedure<T> procedure) {
        this.forPossibleValue(subject, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forPossibleValue(Resource subject, Binding binding, AsyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleValue(subject, binding), listener);
    }

    public <T> void forPossibleValue(Resource subject, Binding binding, SyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleValue(subject, binding), listener);
    }

    public <T> void forPossibleValue(Resource subject, Binding binding, Listener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleValue(subject, binding), listener);
    }

    public final <T> void forPossibleValue(final Resource resource, final Binding binding, final AsyncProcedure<T> procedure) {
        assert (resource != null);
        assert (binding != null);
        assert (procedure != null);
        this.processor.forValue(this, resource, new AsyncProcedure<byte[]>(){

            public void execute(AsyncReadGraph graph, byte[] result) {
                try {
                    if (result == null) {
                        procedure.execute(graph, null);
                        return;
                    }
                    Serializer serializer = Bindings.getSerializer((Binding)binding);
                    Object obj = serializer.deserialize(result);
                    if (!binding.isInstance(obj)) {
                        procedure.exception(graph, (Throwable)new ClassCastException("Cannot get value " + obj + " with binding " + binding));
                    } else {
                        procedure.execute(graph, obj);
                    }
                }
                catch (Throwable t) {
                    procedure.exception(graph, (Throwable)new ServiceException("Could not forValue for subject " + ReadGraphImpl.this.debugString(resource) + " and binding " + String.valueOf(binding) + " with bytes " + ReadGraphImpl.safeArrayToString(result), t));
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return "forPossibleValue -> " + procedure;
            }
        });
    }

    public <T> void forPossibleValue(Resource subject, Binding binding, SyncProcedure<T> procedure) {
        this.forPossibleValue(subject, binding, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forPossibleValue(Resource subject, Binding binding, Procedure<T> procedure) {
        this.forPossibleValue(subject, binding, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, AsyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleRelatedValueImplied(subject, relation), listener);
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, SyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleRelatedValueImplied(subject, relation), listener);
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, Listener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleRelatedValueImplied(subject, relation), listener);
    }

    public final <T> void forPossibleRelatedValue(Resource subject, Resource relation, final AsyncProcedure<T> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        final DeepSingleOrNullProcedure checkedProcedure = new DeepSingleOrNullProcedure(procedure);
        this.processor.forEachObject(this, subject, relation, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){

            public void execute(AsyncReadGraph graph, Resource object) {
                checkedProcedure.inc();
                graph.forValue(object, (AsyncProcedure)new AsyncProcedure<Object>(){

                    public void execute(AsyncReadGraph graph, Object result) {
                        checkedProcedure.offer(graph, result);
                        checkedProcedure.dec(graph);
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        checkedProcedure.exception(graph, t);
                        checkedProcedure.dec(graph);
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                checkedProcedure.dec(graph);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                checkedProcedure.exception(graph, t);
                checkedProcedure.dec(graph);
            }

            public String toString() {
                return "forPossibleRelatedValue -> " + procedure;
            }
        });
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, SyncProcedure<T> procedure) {
        this.forPossibleRelatedValue(subject, relation, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, Procedure<T> procedure) {
        this.forPossibleRelatedValue(subject, relation, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, Binding binding, AsyncListener<T> listener) {
        this.asyncRequest((Read<T>)new PossibleRelatedValue(subject, relation, binding), listener);
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, Binding binding, SyncListener<T> listener) {
        this.asyncRequest((Read<T>)new PossibleRelatedValue(subject, relation, binding), listener);
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, Binding binding, Listener<T> listener) {
        this.asyncRequest((Read<T>)new PossibleRelatedValue(subject, relation, binding), listener);
    }

    public final <T> void forPossibleRelatedValue(Resource subject, Resource relation, final Binding binding, final AsyncProcedure<T> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forPossibleObject(this, subject, relation, new AsyncProcedure<Resource>(){

            public void execute(AsyncReadGraph graph, Resource object) {
                if (object == null) {
                    procedure.execute(graph, null);
                    return;
                }
                ReadGraphImpl.this.processor.forPossibleValue((ReadGraphImpl)graph, object, new AsyncProcedure<byte[]>(){

                    public void execute(AsyncReadGraph graph, byte[] bytes) {
                        block5: {
                            if (bytes != null) {
                                try {
                                    Serializer serializer = binding.serializer();
                                    Object obj = serializer.deserialize(bytes);
                                    if (!binding.isInstance(obj)) {
                                        procedure.exception(graph, (Throwable)new ClassCastException("Cannot get value " + obj + " with binding " + binding));
                                        break block5;
                                    }
                                    procedure.execute(graph, obj);
                                }
                                catch (Throwable t) {
                                    procedure.exception(graph, t);
                                }
                            } else {
                                procedure.execute(graph, null);
                            }
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        procedure.exception(graph, t);
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
                procedure.exception(graph, throwable);
            }
        });
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, Binding binding, SyncProcedure<T> procedure) {
        this.forPossibleRelatedValue(subject, relation, binding, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forPossibleRelatedValue(Resource subject, Resource relation, Binding binding, Procedure<T> procedure) {
        this.forPossibleRelatedValue(subject, relation, binding, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public void forIsInstanceOf(Resource subject, Resource relation, AsyncListener<Boolean> listener) {
        this.asyncRequest((Read)new IsInstanceOf(subject, relation), (AsyncListener)listener);
    }

    public void forIsInstanceOf(Resource subject, Resource relation, SyncListener<Boolean> listener) {
        this.asyncRequest((Read)new IsInstanceOf(subject, relation), (SyncListener)listener);
    }

    public void forIsInstanceOf(Resource subject, Resource relation, Listener<Boolean> listener) {
        this.asyncRequest((Read)new IsInstanceOf(subject, relation), (Listener)listener);
    }

    public final void forIsInstanceOf(Resource resource, final Resource type, final AsyncProcedure<Boolean> procedure) {
        assert (resource != null);
        assert (type != null);
        assert (procedure != null);
        this.forTypes(resource, new AsyncProcedure<Set<Resource>>(){

            public void execute(AsyncReadGraph graph, Set<Resource> result) {
                try {
                    if (result.contains(type)) {
                        procedure.execute(graph, (Object)true);
                    } else {
                        procedure.execute(graph, (Object)false);
                    }
                }
                catch (Throwable t) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return "forIsInstanceOf -> " + procedure;
            }
        });
    }

    public void forIsInstanceOf(Resource subject, Resource relation, SyncProcedure<Boolean> procedure) {
        this.forIsInstanceOf(subject, relation, (AsyncProcedure<Boolean>)new SyncToAsyncProcedure(procedure));
    }

    public void forIsInstanceOf(Resource subject, Resource relation, Procedure<Boolean> procedure) {
        this.forIsInstanceOf(subject, relation, (AsyncProcedure<Boolean>)new NoneToAsyncProcedure(procedure));
    }

    public void forIsInheritedFrom(Resource subject, Resource relation, AsyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new IsInheritedFrom(subject, relation), (AsyncListener)listener);
    }

    public void forIsInheritedFrom(Resource subject, Resource relation, SyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new IsInheritedFrom(subject, relation), (SyncListener)listener);
    }

    public void forIsInheritedFrom(Resource subject, Resource relation, Listener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new IsInheritedFrom(subject, relation), (Listener)listener);
    }

    public final void forIsInheritedFrom(Resource resource, final Resource type, final AsyncProcedure<Boolean> procedure) {
        assert (resource != null);
        assert (type != null);
        assert (procedure != null);
        if (resource.equals(type)) {
            try {
                procedure.execute((AsyncReadGraph)this, (Object)true);
            }
            catch (Throwable t) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            }
            return;
        }
        this.forSupertypes(resource, new AsyncProcedure<Set<Resource>>(){

            public void execute(AsyncReadGraph graph, Set<Resource> result) {
                try {
                    if (result.contains(type)) {
                        procedure.execute(graph, (Object)true);
                    } else {
                        procedure.execute(graph, (Object)false);
                    }
                }
                catch (Throwable t) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return "forIsInheritedFrom -> " + procedure;
            }
        });
    }

    public void forIsInheritedFrom(Resource subject, Resource relation, SyncProcedure<Boolean> procedure) {
        this.forIsInheritedFrom(subject, relation, (AsyncProcedure<Boolean>)new SyncToAsyncProcedure(procedure));
    }

    public void forIsInheritedFrom(Resource subject, Resource relation, Procedure<Boolean> procedure) {
        this.forIsInheritedFrom(subject, relation, (AsyncProcedure<Boolean>)new NoneToAsyncProcedure(procedure));
    }

    public void forIsSubrelationOf(Resource subject, Resource relation, AsyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new IsSubrelationOf(subject, relation), (AsyncListener)listener);
    }

    public void forIsSubrelationOf(Resource subject, Resource relation, SyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new IsSubrelationOf(subject, relation), (SyncListener)listener);
    }

    public void forIsSubrelationOf(Resource subject, Resource relation, Listener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new IsSubrelationOf(subject, relation), (Listener)listener);
    }

    public final void forIsSubrelationOf(Resource resource, final Resource relation, final AsyncProcedure<Boolean> procedure) {
        assert (resource != null);
        assert (relation != null);
        assert (procedure != null);
        if (resource.equals(relation)) {
            procedure.execute((AsyncReadGraph)this, (Object)true);
            return;
        }
        this.forSuperrelations(resource, new AsyncProcedure<Set<Resource>>(){

            public void execute(AsyncReadGraph graph, Set<Resource> result) {
                try {
                    if (result.contains(relation)) {
                        procedure.execute(graph, (Object)true);
                    } else {
                        procedure.execute(graph, (Object)false);
                    }
                }
                catch (Throwable t) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return "forIsSubrelationOf -> " + procedure;
            }
        });
    }

    public void forIsSubrelationOf(Resource subject, Resource relation, SyncProcedure<Boolean> procedure) {
        this.forIsSubrelationOf(subject, relation, (AsyncProcedure<Boolean>)new SyncToAsyncProcedure(procedure));
    }

    public void forIsSubrelationOf(Resource subject, Resource relation, Procedure<Boolean> procedure) {
        this.forIsSubrelationOf(subject, relation, (AsyncProcedure<Boolean>)new NoneToAsyncProcedure(procedure));
    }

    public void forHasStatement(Resource subject, AsyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatementSubject(subject), (AsyncListener)listener);
    }

    public void forHasStatement(Resource subject, SyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatementSubject(subject), (SyncListener)listener);
    }

    public void forHasStatement(Resource subject, Listener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatementSubject(subject), (Listener)listener);
    }

    public final void forHasStatement(Resource subject, AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forHasStatement(this, subject, procedure);
    }

    public void forHasStatement(Resource subject, SyncProcedure<Boolean> procedure) {
        this.forHasStatement(subject, (AsyncProcedure<Boolean>)new SyncToAsyncProcedure(procedure));
    }

    public void forHasStatement(Resource subject, Procedure<Boolean> procedure) {
        this.forHasStatement(subject, (AsyncProcedure<Boolean>)new NoneToAsyncProcedure(procedure));
    }

    public void forHasStatement(Resource subject, Resource relation, AsyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatement(subject, relation), (AsyncListener)listener);
    }

    public void forHasStatement(Resource subject, Resource relation, SyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatement(subject, relation), (SyncListener)listener);
    }

    public void forHasStatement(Resource subject, Resource relation, Listener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatement(subject, relation), (Listener)listener);
    }

    public final void forHasStatement(Resource subject, Resource relation, AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (procedure != null);
        this.processor.forHasStatement(this, subject, relation, procedure);
    }

    public void forHasStatement(Resource subject, Resource relation, SyncProcedure<Boolean> procedure) {
        this.forHasStatement(subject, relation, (AsyncProcedure<Boolean>)new SyncToAsyncProcedure(procedure));
    }

    public void forHasStatement(Resource subject, Resource relation, Procedure<Boolean> procedure) {
        this.forHasStatement(subject, relation, (AsyncProcedure<Boolean>)new NoneToAsyncProcedure(procedure));
    }

    public void forHasStatement(Resource subject, Resource relation, Resource object, AsyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatementSubjectObject(subject, relation, object), (AsyncListener)listener);
    }

    public void forHasStatement(Resource subject, Resource relation, Resource object, SyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatementSubjectObject(subject, relation, object), (SyncListener)listener);
    }

    public void forHasStatement(Resource subject, Resource relation, Resource object, Listener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasStatementSubjectObject(subject, relation, object), (Listener)listener);
    }

    public final void forHasStatement(Resource subject, Resource relation, Resource object, AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (relation != null);
        assert (object != null);
        assert (procedure != null);
        this.processor.forHasStatement(this, subject, relation, object, procedure);
    }

    public void forHasStatement(Resource subject, Resource relation, Resource object, SyncProcedure<Boolean> procedure) {
        this.forHasStatement(subject, relation, object, (AsyncProcedure<Boolean>)new SyncToAsyncProcedure(procedure));
    }

    public void forHasStatement(Resource subject, Resource relation, Resource object, Procedure<Boolean> procedure) {
        this.forHasStatement(subject, relation, object, (AsyncProcedure<Boolean>)new NoneToAsyncProcedure(procedure));
    }

    public void forHasValue(Resource subject, AsyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasValue(subject), (AsyncListener)listener);
    }

    public void forHasValue(Resource subject, SyncListener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasValue(subject), (SyncListener)listener);
    }

    public void forHasValue(Resource subject, Listener<Boolean> listener) {
        this.asyncRequest((AsyncRead)new HasValue(subject), (Listener)listener);
    }

    public final void forHasValue(Resource subject, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forValue(this, subject, new AsyncProcedure<byte[]>(){

            public void execute(AsyncReadGraph graph, byte[] result) {
                try {
                    if (result == null) {
                        procedure.execute(graph, (Object)false);
                    } else {
                        procedure.execute(graph, (Object)true);
                    }
                }
                catch (Throwable t) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return "forHasValue -> " + procedure;
            }
        });
    }

    public void forHasValue(Resource subject, SyncProcedure<Boolean> procedure) {
        this.forHasValue(subject, (AsyncProcedure<Boolean>)new SyncToAsyncProcedure(procedure));
    }

    public void forHasValue(Resource subject, Procedure<Boolean> procedure) {
        this.forHasValue(subject, (AsyncProcedure<Boolean>)new NoneToAsyncProcedure(procedure));
    }

    public void forOrderedSet(Resource subject, AsyncMultiListener<Resource> listener) {
        this.asyncRequest((AsyncMultiRead)new OrderedSet(subject), (AsyncMultiListener)listener);
    }

    public void forOrderedSet(Resource subject, SyncMultiListener<Resource> listener) {
        this.asyncRequest((AsyncMultiRead)new OrderedSet(subject), (SyncMultiListener)listener);
    }

    public void forOrderedSet(Resource subject, MultiListener<Resource> listener) {
        this.asyncRequest((AsyncMultiRead)new OrderedSet(subject), (MultiListener)listener);
    }

    public final void forOrderedSet(Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.processor.forOrderedSet(this, subject, new AsyncMultiProcedure<Resource>(){

            public void finished(AsyncReadGraph graph) {
                try {
                    procedure.finished(graph);
                }
                catch (Throwable t) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
                }
            }

            public void execute(AsyncReadGraph graph, Resource result) {
                try {
                    procedure.execute(graph, (Object)result);
                }
                catch (Throwable t) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return "forOrderedSet -> " + procedure;
            }
        });
    }

    public void forOrderedSet(Resource subject, SyncMultiProcedure<Resource> procedure) {
        this.forOrderedSet(subject, (AsyncMultiProcedure<Resource>)new SyncToAsyncMultiProcedure(procedure));
    }

    public void forOrderedSet(Resource subject, MultiProcedure<Resource> procedure) {
        this.forOrderedSet(subject, (AsyncMultiProcedure<Resource>)new NoneToAsyncMultiProcedure(procedure));
    }

    public <T> void forPossibleAdapted(Resource resource, Class<T> clazz, AsyncListener<T> listener) {
        this.asyncRequest((Read<T>)new PossibleAdapter(resource, clazz), listener);
    }

    public <T> void forPossibleAdapted(Resource resource, Class<T> clazz, SyncListener<T> listener) {
        this.asyncRequest((Read<T>)new PossibleAdapter(resource, clazz), listener);
    }

    public <T> void forPossibleAdapted(Resource resource, Class<T> clazz, Listener<T> listener) {
        this.asyncRequest((Read<T>)new PossibleAdapter(resource, clazz), listener);
    }

    public final <T> void forPossibleAdapted(Resource resource, Class<T> clazz, AsyncProcedure<T> procedure) {
        assert (resource != null);
        assert (clazz != null);
        assert (procedure != null);
        AdaptionService service = (AdaptionService)this.getSession().peekService(AdaptionService.class);
        if (service == null) {
            procedure.exception((AsyncReadGraph)this, (Throwable)new ServiceException("No AdaptionService available"));
        } else {
            service.adapt((AsyncReadGraph)this, resource, (Object)resource, Resource.class, clazz, true, procedure);
        }
    }

    public <T> void forPossibleAdapted(Resource resource, Class<T> clazz, SyncProcedure<T> procedure) {
        this.forPossibleAdapted(resource, clazz, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forPossibleAdapted(Resource resource, Class<T> clazz, Procedure<T> procedure) {
        this.forPossibleAdapted(resource, clazz, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void forPossibleUniqueAdapted(Resource resource, Class<T> clazz, AsyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleUniqueAdapter(resource, clazz), listener);
    }

    public <T> void forPossibleUniqueAdapted(Resource resource, Class<T> clazz, SyncListener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleUniqueAdapter(resource, clazz), listener);
    }

    public <T> void forPossibleUniqueAdapted(Resource resource, Class<T> clazz, Listener<T> listener) {
        this.asyncRequest((AsyncRead<T>)new PossibleUniqueAdapter(resource, clazz), listener);
    }

    public final <T> void forPossibleUniqueAdapted(Resource resource, Class<T> clazz, AsyncProcedure<T> procedure) {
        assert (resource != null);
        assert (clazz != null);
        assert (procedure != null);
        AdaptionService service = (AdaptionService)this.getSession().peekService(AdaptionService.class);
        if (service == null) {
            procedure.exception((AsyncReadGraph)this, (Throwable)new ServiceException("No AdaptionService available"));
        } else {
            service.adaptNew((AsyncReadGraph)this, resource, clazz, true, procedure);
        }
    }

    public <T> void forPossibleUniqueAdapted(Resource resource, Class<T> clazz, SyncProcedure<T> procedure) {
        this.forPossibleUniqueAdapted(resource, clazz, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void forPossibleUniqueAdapted(Resource resource, Class<T> clazz, Procedure<T> procedure) {
        this.forPossibleUniqueAdapted(resource, clazz, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public final Session getSession() {
        return this.processor.getSession();
    }

    public <T> void asyncRequest(final Read<T> request) {
        this.asyncRequest(request, new AsyncProcedure<T>(){

            public void execute(AsyncReadGraph graph, T result) {
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            }

            public String toString() {
                return "asyncRequest(Read) -> " + request;
            }
        });
    }

    public <T> void asyncRequest(Read<T> request, AsyncListener<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)procedure);
    }

    public <T> void asyncRequest(Read<T> request, SyncListener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new SyncToAsyncListener(procedure));
    }

    public <T> void asyncRequest(Read<T> request, Listener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new NoneToAsyncListener(procedure));
    }

    public <T> void asyncRequest(final Read<T> request, final AsyncProcedure<T> procedure) {
        assert (request != null);
        assert (procedure != null);
        final AsyncBarrierImpl barrier = this.asyncBarrier;
        if (barrier != null) {
            barrier.inc();
        }
        this.processor.scheduleNow(new QueryProcessor.SessionTask(this){

            @Override
            public void run0(int thread) {
                try {
                    try {
                        ListenerBase listener = ReadGraphImpl.this.getListenerBase(procedure);
                        QueryCache.runnerReadEntry(ReadGraphImpl.this, request, ReadGraphImpl.this.parent, listener, procedure, false);
                    }
                    catch (DatabaseException e) {
                        org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                        if (barrier != null) {
                            barrier.dec();
                        }
                    }
                }
                finally {
                    if (barrier != null) {
                        barrier.dec();
                    }
                }
            }
        });
    }

    public static ReadGraphImpl createAsync(QueryProcessor support) {
        return new ReadGraphImpl(null, null, support);
    }

    public <T> void asyncRequest(Read<T> request, SyncProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void asyncRequest(Read<T> request, Procedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public final <T> void asyncRequest(final AsyncRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, new AsyncProcedure<T>(){

            public void execute(AsyncReadGraph graph, T result) {
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            }

            public String toString() {
                return "asyncRequest(AsyncRead) -> " + request;
            }
        });
    }

    public <T> void asyncRequest(AsyncRead<T> request, AsyncListener<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)procedure);
    }

    public final <T> void asyncRequest(AsyncRead<T> request, SyncListener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new SyncToAsyncListener(procedure));
    }

    public final <T> void asyncRequest(AsyncRead<T> request, Listener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new NoneToAsyncListener(procedure));
    }

    public final <T> void asyncRequest(final AsyncRead<T> request, final AsyncProcedure<T> procedure) {
        assert (request != null);
        assert (procedure != null);
        final AsyncBarrierImpl barrier = this.asyncBarrier;
        if (barrier != null) {
            barrier.inc();
        }
        this.processor.scheduleNow(new QueryProcessor.SessionTask(this){

            @Override
            public void run0(int thread) {
                if (barrier != null) {
                    barrier.inc();
                }
                try {
                    try {
                        ListenerBase listener = ReadGraphImpl.this.getListenerBase(procedure);
                        QueryCache.runnerAsyncReadEntry(ReadGraphImpl.this, request, ReadGraphImpl.this.parent, listener, new AsyncProcedure<T>(){

                            public void execute(AsyncReadGraph graph, T result) {
                                procedure.execute(graph, result);
                                if (barrier != null) {
                                    barrier.dec();
                                }
                            }

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                procedure.exception(graph, throwable);
                                if (barrier != null) {
                                    barrier.dec();
                                }
                            }
                        }, false);
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Error while executing async request", (Throwable)e);
                        if (barrier != null) {
                            barrier.dec();
                        }
                    }
                }
                finally {
                    if (barrier != null) {
                        barrier.dec();
                    }
                }
            }
        });
    }

    public <T> void asyncRequest(AsyncRead<T> request, SyncProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public final <T> void asyncRequest(AsyncRead<T> request, Procedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void asyncRequest(final MultiRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, (SyncMultiProcedure<T>)new SyncMultiProcedureAdapter<T>(){

            public void exception(ReadGraph graph, Throwable t) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            }

            public String toString() {
                return "asyncRequest(MultiRead) -> " + request;
            }
        });
    }

    public <T> void asyncRequest(MultiRead<T> request, SyncMultiListener<T> procedure) {
        this.asyncRequest(request, (SyncMultiProcedure<T>)procedure);
    }

    public <T> void asyncRequest(MultiRead<T> request, MultiListener<T> procedure) {
        this.asyncRequest(request, (SyncMultiListener<T>)new NoneToSyncMultiListener(procedure));
    }

    public <T> void asyncRequest(MultiRead<T> request, SyncMultiProcedure<T> procedure) {
        assert (request != null);
        assert (procedure != null);
        ListenerBase listener = this.getListenerBase(procedure);
        if (this.parent != null || listener != null) {
            this.processor.query(this, request, this.parent, procedure, listener);
        } else {
            try {
                request.perform((ReadGraph)this, procedure);
            }
            catch (Throwable t) {
                try {
                    procedure.exception((ReadGraph)this, t);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Unexpected exception while handling exception", (Throwable)e);
                }
            }
        }
    }

    public <T> void asyncRequest(MultiRead<T> request, MultiProcedure<T> procedure) {
        this.asyncRequest(request, (SyncMultiProcedure<T>)new NoneToSyncMultiProcedure(procedure));
    }

    public final <T> void asyncRequest(final AsyncMultiRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new AsyncMultiProcedureAdapter<T>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            }

            public String toString() {
                return "asyncRequest(AsyncMultiRead) -> " + request;
            }
        });
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, AsyncMultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)procedure);
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, SyncMultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiListener<T>)new SyncToAsyncMultiListener(procedure));
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, MultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiListener<T>)new NoneToAsyncMultiListener(procedure));
    }

    public final <T> void asyncRequest(AsyncMultiRead<T> request, final AsyncMultiProcedure<T> procedure) {
        assert (request != null);
        assert (procedure != null);
        ListenerBase listener = this.getListenerBase(procedure);
        if (this.parent != null || listener != null) {
            this.processor.query(this, request, this.parent, procedure, listener);
        } else {
            try {
                request.perform((AsyncReadGraph)this, new AsyncMultiProcedure<T>(){

                    public void execute(AsyncReadGraph graph, T result) {
                        procedure.execute(graph, result);
                    }

                    public void finished(AsyncReadGraph graph) {
                        procedure.finished(graph);
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        procedure.exception(graph, t);
                    }

                    public String toString() {
                        return "asyncRequest(AsyncMultiRead) -> " + procedure;
                    }
                });
            }
            catch (Throwable t) {
                procedure.exception((AsyncReadGraph)this, (Throwable)new DatabaseException(t));
            }
        }
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, SyncMultiProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new SyncToAsyncMultiProcedure(procedure));
    }

    public final <T> void asyncRequest(AsyncMultiRead<T> request, MultiProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new NoneToAsyncMultiProcedure(procedure));
    }

    public final <T> void asyncRequest(final ExternalRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, new Procedure<T>(){

            public void execute(T result) {
            }

            public void exception(Throwable t) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            }

            public String toString() {
                return "asyncRequest(PrimitiveRead) -> " + request;
            }
        });
    }

    public <T> void asyncRequest(ExternalRead<T> request, Listener<T> procedure) {
        this.asyncRequest(request, (Procedure<T>)procedure);
    }

    public final <T> void asyncRequest(final ExternalRead<T> request, final Procedure<T> procedure) {
        assert (request != null);
        assert (procedure != null);
        ListenerBase listener = this.getListenerBase(procedure);
        if (this.parent != null || listener != null) {
            try {
                QueryCacheBase.resultExternalReadEntry(this, request, this.parent, listener, procedure);
            }
            catch (DatabaseException e) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            }
        } else {
            request.register((ReadGraph)this, new Listener<T>(){

                public void execute(T result) {
                    procedure.execute(result);
                }

                public void exception(Throwable t) {
                    procedure.exception(t);
                }

                public String toString() {
                    return "asyncRequest(PrimitiveRead) -> " + request;
                }

                public boolean isDisposed() {
                    return true;
                }
            });
        }
    }

    public void asyncRequest(Write request) {
        assert (request != null);
        this.getSession().asyncRequest(request);
    }

    public <T> void asyncRequest(WriteResult<T> request, Procedure<T> procedure) {
        throw new Error("Not implemented.");
    }

    public void asyncRequest(Write request, Consumer<DatabaseException> callback) {
        assert (request != null);
        this.getSession().asyncRequest(request, callback);
    }

    public void asyncRequest(DelayedWrite request) {
        assert (request != null);
        this.getSession().asyncRequest(request);
    }

    public <T> void asyncRequest(DelayedWriteResult<T> request, Procedure<T> procedure) {
        throw new Error("Not implemented.");
    }

    public void asyncRequest(DelayedWrite r, Consumer<DatabaseException> callback) {
        throw new Error("Not implemented.");
    }

    public void asyncRequest(WriteOnly request) {
        assert (request != null);
        this.getSession().asyncRequest(request);
    }

    public <T> void asyncRequest(WriteOnlyResult<T> request, Procedure<T> procedure) {
        throw new Error("Not implemented.");
    }

    public void asyncRequest(WriteOnly r, Consumer<DatabaseException> callback) {
        throw new Error("Not implemented.");
    }

    public <T> T getService(Class<T> api) {
        if (WriteSupport.class == api && this instanceof WriteGraphImpl) {
            WriteGraphImpl impl = (WriteGraphImpl)this;
            return (T)impl.writeSupport;
        }
        return (T)this.getSession().getService(api);
    }

    public <T> T peekService(Class<T> api) {
        return (T)this.getSession().peekService(api);
    }

    public boolean hasService(Class<?> api) {
        return this.getSession().hasService(api);
    }

    public <T> void registerService(Class<T> api, T service) {
        this.getSession().registerService(api, service);
    }

    public boolean isImmutable(Resource resource) throws DatabaseException {
        ResourceImpl impl = (ResourceImpl)resource;
        return this.processor.isImmutable(impl.id);
    }

    ReadGraphImpl(ReadGraphImpl parentGraph, CacheEntry parent, QueryProcessor support) {
        this.parentGraph = parentGraph;
        this.parent = parent;
        this.processor = support;
        this.asyncBarrier = ReadGraphImpl.prepareBarrier(parentGraph, parent, null, false);
    }

    ReadGraphImpl(ReadGraphImpl parentGraph, CacheEntry parent, QueryProcessor support, AsyncBarrierImpl asyncBarrier) {
        this.parentGraph = parentGraph;
        this.parent = parent;
        this.processor = support;
        this.asyncBarrier = asyncBarrier;
    }

    ReadGraphImpl(ReadGraphImpl graph, CacheEntry parent) {
        this(graph, parent, graph.processor);
    }

    ReadGraphImpl(ReadGraphImpl parentGraph, CacheEntry parent, Runnable callback, boolean needsToBlock) {
        this(parentGraph, parent, parentGraph.processor, ReadGraphImpl.prepareBarrier(parentGraph, parent, callback, needsToBlock));
    }

    static AsyncBarrierImpl prepareBarrier(ReadGraphImpl parentGraph, CacheEntry parent, Runnable callback, boolean needsToBlock) {
        return new AsyncBarrierImpl(parentGraph != null ? parentGraph.asyncBarrier : null, parent, callback, needsToBlock);
    }

    ReadGraphImpl(ReadGraphImpl graph) {
        this(graph, graph.parent);
    }

    public ReadGraphImpl withParent(CacheEntry parent, Runnable callback, boolean needsToBlock) {
        return new ReadGraphImpl(this, parent, callback, needsToBlock);
    }

    public ReadGraphImpl forRecompute(CacheEntry parent) {
        return new ReadGraphImpl(null, parent, this.processor);
    }

    public static ReadGraphImpl create(QueryProcessor support) {
        ReadGraphImpl result = new ReadGraphImpl(null, null, support);
        return result;
    }

    public ReadGraphImpl newRestart(ReadGraphImpl impl) {
        WriteGraphImpl write = (WriteGraphImpl)this.processor.getSession().getService(WriteGraphImpl.class);
        return write;
    }

    private final ListenerBase getListenerBase(Object procedure) {
        if (procedure instanceof ListenerBase) {
            return (ListenerBase)procedure;
        }
        return null;
    }

    public <T> void waitAsyncProcedure(AsyncMultiReadProcedure<T> procedure) {
        assert (procedure.done());
    }

    public <T> void waitAsyncProcedure(AsyncReadProcedure<T> procedure) {
        assert (procedure.done());
    }

    public boolean resumeTasks() {
        return this.processor.resumeTasks(this);
    }

    Class<?> singleClass(Set<Resource> types) {
        Class<?> result = null;
        for (Resource type : types) {
            Class<?> clazz = this.processor.getBuiltinValue(type);
            if (clazz == null) continue;
            if (result != null) {
                return null;
            }
            result = clazz;
        }
        return result;
    }

    private String debugString(Resource r) {
        String name = null;
        try {
            name = (String)this.getPossibleRelatedValue(r, this.processor.getL0((ReadGraph)this).HasName);
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
        }
        catch (ServiceException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
        }
        return "[" + name + " - " + r + "]";
    }

    public String toString() {
        return "ReadGraphImpl[thread=" + Thread.currentThread() + "]";
    }

    public final int thread() {
        return 0;
    }

    public Datatype getDataType(Resource subject) throws DatabaseException {
        Iterator<Resource> iterator = this.getObjects(subject, this.processor.getL0((ReadGraph)this).HasDataType).iterator();
        if (iterator.hasNext()) {
            Resource dataTypeResource = iterator.next();
            return (Datatype)this.getValue(dataTypeResource, Bindings.getBindingUnchecked(Datatype.class));
        }
        throw new DoesNotContainValueException("The literal has no data type.");
    }

    protected <T extends Accessor> T getAccessor4File(Resource subject) throws DatabaseException {
        return null;
    }

    public <T extends Accessor> T getAccessor(Resource subject) throws DatabaseException {
        RandomAccessBinary rab = this.getRandomAccessBinary(subject);
        try {
            return (T)Accessors.getAccessor((RandomAccessBinary)rab, (Datatype)this.getDataType(subject));
        }
        catch (AccessorConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected <T extends Accessor> T createAccessor(Resource resource, Datatype datatype, Object intialValue) throws DatabaseException {
        RandomAccessBinary rab = this.createRandomAccessBinary(resource, datatype, intialValue);
        try {
            return (T)Accessors.getAccessor((RandomAccessBinary)rab, (Datatype)datatype);
        }
        catch (AccessorConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public RandomAccessBinary getRandomAccessBinary(Resource subject) throws DatabaseException {
        RandomAccessValueSupport ravs = (RandomAccessValueSupport)this.getSession().getService(RandomAccessValueSupport.class);
        ResourceData rd = ravs.get(subject);
        if (rd != null) {
            return rd;
        }
        try {
            ExternalValueSupport evs = this.getService(ExternalValueSupport.class);
            long size = evs.getValueSize((ReadGraph)this, subject);
            try {
                File platform = Platform.getLocation().toFile();
                File tempFiles = new File(platform, "tempFiles");
                File dbDir = new File(tempFiles, "db");
                dbDir.mkdirs();
                File file = new File(dbDir, "ResourceFile" + subject.getResourceId());
                rd = new ResourceData(new BinaryFile(file), true);
                long left = size;
                long offset = 0L;
                while (left > 0L) {
                    int length = 0x100000L < left ? 0x100000 : (int)left;
                    byte[] bytes = evs.readValue((ReadGraph)this, subject, offset, length);
                    offset += (long)bytes.length;
                    left -= (long)bytes.length;
                    rd.binaryFile.write(bytes);
                }
                ravs.put(subject, rd);
                return rd;
            }
            catch (Exception e) {
                throw new DatabaseException("Resource " + subject + " have value but there was problem with accessing value data.", (Throwable)e);
            }
        }
        catch (Exception evs) {
            Datatype datatype = this.getDataType(subject);
            Object value = this.getPossibleValue(subject, Bindings.getBinding((Datatype)datatype));
            return this.createRandomAccessBinary(subject, datatype, value);
        }
    }

    public RandomAccessBinary createRandomAccessBinary(Resource resource, Datatype datatype, Object initialValue) throws DatabaseException {
        RandomAccessValueSupport ravs = (RandomAccessValueSupport)this.getSession().getService(RandomAccessValueSupport.class);
        try {
            File platform = Platform.getLocation().toFile();
            File tempFiles = new File(platform, "tempFiles");
            File dbDir = new File(tempFiles, "db");
            dbDir.mkdirs();
            File file = new File(dbDir, "ResourceFile" + resource.getResourceId());
            ResourceData rd = new ResourceData(new BinaryFile(file), false);
            Binding binding = Bindings.getBinding((Datatype)datatype);
            if (initialValue == null) {
                initialValue = binding.createDefault();
            }
            Serializer serializer = binding.serializer();
            byte[] bytes = serializer.serialize(initialValue);
            rd.binaryFile.setLength((long)bytes.length);
            rd.binaryFile.write(bytes);
            ravs.put(resource, rd);
            return rd;
        }
        catch (Exception e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)((Object)e);
            }
            throw new DatabaseException((Throwable)e);
        }
    }

    public <T> T getValue2(Resource r, Object context) throws DatabaseException {
        Layer0 L0 = this.processor.getL0((ReadGraph)this);
        Set<Resource> types = this.getTypes(r);
        if (types.contains(L0.Literal)) {
            if (this.isImmutable(r)) {
                return this.syncRequest((Read<T>)new ValueImplied(r));
            }
            return this.getValue(r);
        }
        if (types.contains(L0.ExternalValue)) {
            return this.syncRequest((Read<T>)new AdaptValue(r), (Listener<T>)TransientCacheListener.instance());
        }
        Function3<ReadGraph, Resource, Object, T> function = this.requestValueFunction(r);
        if (function == null) {
            throw new DoesNotContainValueException("Couldn't convert to a value function " + r);
        }
        try {
            return (T)function.apply((Object)this, (Object)r, context);
        }
        catch (RuntimeException e) {
            DatabaseException dte = ReadGraphImpl.findPossibleRootException(e);
            if (dte != null) {
                throw dte;
            }
            throw new DatabaseException((Throwable)e);
        }
    }

    public Variant getVariantValue2(Resource r, Object context) throws DatabaseException {
        Layer0 L0 = this.processor.getL0((ReadGraph)this);
        Set<Resource> types = this.getTypes(r);
        if (types.contains(L0.Literal)) {
            if (this.isImmutable(r)) {
                return (Variant)this.syncRequest((Read)new VariantValueImplied(r));
            }
            return this.getVariantValue(r);
        }
        if (types.contains(L0.ExternalValue)) {
            Object value = this.syncRequest((Read)new AdaptValue(r), (Listener)TransientCacheListener.instance());
            try {
                return new Variant(Bindings.OBJECT.getContentBinding(value), value);
            }
            catch (org.simantics.databoard.binding.error.BindingException e) {
                throw new BindingException("No binding found for class " + value.getClass().getName(), (Throwable)e);
            }
        }
        Function3 function = this.requestValueFunction(r);
        if (function == null) {
            throw new DoesNotContainValueException("Couldn't convert to a value function " + r);
        }
        try {
            Object value = function.apply((Object)this, (Object)r, context);
            try {
                return new Variant(Bindings.OBJECT.getContentBinding(value), value);
            }
            catch (org.simantics.databoard.binding.error.BindingException e) {
                throw new BindingException("No binding found for class " + value.getClass().getName(), (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            DatabaseException dte = ReadGraphImpl.findPossibleRootException(e);
            if (dte != null) {
                throw dte;
            }
            throw new DatabaseException((Throwable)e);
        }
    }

    public <T> T getPossibleValue2(Resource subject, Object context) throws DatabaseException {
        try {
            return this.getValue2(subject, context);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    <T> Function3<ReadGraph, Resource, Object, T> requestValueFunction(Resource r) throws DatabaseException {
        if (this.isImmutable(r)) {
            return (Function3)this.syncRequest((Read<T>)new PossibleConverterFunction(r), (AsyncProcedure<T>)TransientCacheAsyncListener.instance());
        }
        return (Function3)this.syncRequest((Read<T>)new PossibleConverterFunction(r));
    }

    public <T> T getValue2(Resource r, Object context, Binding binding) throws DatabaseException {
        Object value;
        block16: {
            if (binding instanceof ObjectVariantBinding) {
                return this.getValue2(r, context);
            }
            Layer0 L0 = this.processor.getL0((ReadGraph)this);
            Set<Resource> types = this.getTypes(r);
            if (types.contains(L0.Literal)) {
                if (this.isImmutable(r)) {
                    return this.syncRequest((Read<T>)new Value(r, binding));
                }
                return this.getValue(r, binding);
            }
            if (types.contains(L0.ExternalValue)) {
                ComputationalValue cv = (ComputationalValue)this.syncRequest((Read<T>)new PossibleAdapter(r, ComputationalValue.class), (AsyncProcedure<T>)TransientCacheAsyncListener.instance());
                if (cv != null) {
                    return (T)cv.getValue((ReadGraph)this, r);
                }
                try {
                    return (T)ReflectionUtils.getValue((String)this.getURI(r)).getValue();
                }
                catch (ValueNotFoundException e) {
                    throw new DatabaseException((Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            Function3<ReadGraph, Resource, Object, T> function = this.requestValueFunction(r);
            if (function == null) {
                throw new DoesNotContainValueException("Couldn't convert to a value function.");
            }
            value = function.apply((Object)this, (Object)r, context);
            if (value != null) break block16;
            return null;
        }
        try {
            if (binding.isInstance(value)) {
                return (T)value;
            }
            Binding srcBinding = Bindings.OBJECT.getContentBinding(value);
            return (T)Bindings.adapt((Object)value, (Binding)srcBinding, (Binding)binding);
        }
        catch (RuntimeException e) {
            DatabaseException dte = ReadGraphImpl.findPossibleRootException(e);
            if (dte != null) {
                throw dte;
            }
            throw new DatabaseException((Throwable)e);
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (org.simantics.databoard.binding.error.BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public <T> T getPossibleValue2(Resource subject, Object context, Binding binding) throws DatabaseException {
        try {
            return this.getValue2(subject, context, binding);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    private static DatabaseException findPossibleRootException(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof DatabaseException) {
            return (DatabaseException)t;
        }
        if (t instanceof RuntimeException || t instanceof InvocationTargetException) {
            return ReadGraphImpl.findPossibleRootException(t.getCause());
        }
        return null;
    }

    public <T> T getRelatedValue2(Resource subject, Resource relation) throws DatabaseException {
        return this.getRelatedValue2(subject, relation, subject);
    }

    public Variant getRelatedVariantValue2(Resource subject, Resource relation) throws DatabaseException {
        return this.getRelatedVariantValue2(subject, relation, subject);
    }

    public <T> T getPossibleRelatedValue2(Resource subject, Resource relation) throws DatabaseException {
        Resource object;
        block3: {
            try {
                object = this.getPossibleObject(subject, relation);
                if (object != null) break block3;
            }
            catch (DatabaseException databaseException) {
                return null;
            }
            return null;
        }
        return this.getValue2(object, subject);
    }

    public <T> T getRelatedValue2(Resource subject, Resource relation, Object context) throws DatabaseException {
        return this.getValue2(this.getSingleObject(subject, relation), context);
    }

    public Variant getRelatedVariantValue2(Resource subject, Resource relation, Object context) throws DatabaseException {
        return this.getVariantValue2(this.getSingleObject(subject, relation), context);
    }

    public <T> T getPossibleRelatedValue2(Resource subject, Resource relation, Object context) throws DatabaseException {
        Resource object;
        block3: {
            try {
                object = this.getPossibleObject(subject, relation);
                if (object != null) break block3;
            }
            catch (DatabaseException databaseException) {
                return null;
            }
            return null;
        }
        return this.getValue2(object, context);
    }

    public <T> T getRelatedValue2(Resource subject, Resource relation, Binding binding) throws DatabaseException {
        return this.getRelatedValue2(subject, relation, subject, binding);
    }

    public <T> T getPossibleRelatedValue2(Resource subject, Resource relation, Binding binding) throws DatabaseException {
        Resource object;
        block3: {
            try {
                object = this.getPossibleObject(subject, relation);
                if (object != null) break block3;
            }
            catch (DatabaseException databaseException) {
                return null;
            }
            return null;
        }
        return this.getValue2(object, subject, binding);
    }

    public <T> T getRelatedValue2(Resource subject, Resource relation, Object context, Binding binding) throws DatabaseException {
        return this.getValue2(this.getSingleObject(subject, relation), context, binding);
    }

    public <T> T getPossibleRelatedValue2(Resource subject, Resource relation, Object context, Binding binding) throws DatabaseException {
        Resource object;
        block3: {
            try {
                object = this.getPossibleObject(subject, relation);
                if (object != null) break block3;
            }
            catch (DatabaseException databaseException) {
                return null;
            }
            return null;
        }
        return this.getValue2(object, context, binding);
    }

    public Type getRelatedValueType(Resource subject, Resource relation) throws DatabaseException {
        Layer0 L0 = this.processor.getL0((ReadGraph)this);
        Resource property = this.getSingleObject(subject, relation);
        String typeText = (String)this.getRelatedValue(property, L0.HasValueType, (Binding)Bindings.STRING);
        try {
            return org.simantics.scl.compiler.types.Types.parseType((String)typeText);
        }
        catch (SCLTypeParseException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public GraphHints getHints() {
        return syncGraph.get();
    }

    public GraphHints setHints(GraphHints hints) {
        GraphHints old = this.getHints();
        if (hints != old) {
            syncGraph.set(hints);
        }
        return old;
    }

    public <T> T getHintValue(String key) {
        return (T)this.getHints().get(key);
    }

    public <T> GraphHints setHintValue(String key, T value) {
        GraphHints old = this.getHints();
        GraphHints newHints = old.withValue(key, value);
        if (newHints != old) {
            syncGraph.set(newHints);
        }
        return old;
    }

    public boolean getSynchronous() {
        return (Boolean)this.getHints().get("sync");
    }

    public boolean setSynchronous(boolean value) {
        boolean old = this.getSynchronous();
        this.setHintValue("sync", value);
        return old;
    }

    public void ensureLoaded(int resource) {
        this.processor.querySupport.ensureLoaded(this, resource);
    }

    public void ensureLoaded(int resource, int predicate) {
        this.processor.querySupport.ensureLoaded(this, resource, predicate);
    }

    public byte[] getValue(int resource) {
        return this.processor.querySupport.getValue(this, resource);
    }

    public int thread(int resource) {
        return resource >>> 16 & this.processor.THREAD_MASK;
    }

    public int thread(Resource resource) {
        return ((ResourceImpl)resource).id >>> 16 & this.processor.THREAD_MASK;
    }

    public ResourceSupport getResourceSupport() {
        return this.processor.getResourceSupport();
    }

    public Object getModificationCounter() {
        return this.processor.getSession().getModificationCounter();
    }

    public boolean performPending() {
        return this.processor.performPending(this);
    }

    public Set<ReadGraphImpl> ancestorSet() {
        HashSet<ReadGraphImpl> result = new HashSet<ReadGraphImpl>();
        ReadGraphImpl g = this;
        while (g != null) {
            result.add(g);
            g = g.parentGraph;
        }
        return result;
    }

    public int getLevel() {
        return ReadGraphImpl.getLevelStatic(this);
    }

    private static int getLevelStatic(ReadGraphImpl impl) {
        if (impl == null) {
            return 0;
        }
        return 1 + ReadGraphImpl.getLevelStatic(impl.parentGraph);
    }

    public boolean isParent(ReadGraphImpl impl) {
        if (impl == null) {
            return false;
        }
        if (this == impl) {
            return true;
        }
        return this.isParent(impl.parentGraph);
    }

    public ReadGraphImpl getTopLevelGraph() {
        return ReadGraphImpl.getTopLevelGraphStatic(this);
    }

    private static ReadGraphImpl getTopLevelGraphStatic(ReadGraphImpl impl) {
        if (impl.parentGraph == null) {
            return impl;
        }
        return ReadGraphImpl.getTopLevelGraphStatic(impl.parentGraph);
    }

    public <T> T l0() {
        return (T)this.processor.getL0();
    }

    public String clusterAndIndex(int r) {
        if (r < 0) {
            return "";
        }
        return this.processor.querySupport.getClusterId(r) + ":" + (r & 0xFFF);
    }

    static class AsyncMultiReadProcedure<T>
    extends ArrayList<T>
    implements AsyncMultiProcedure<T> {
        private static Throwable DONE = new Throwable();
        private static final long serialVersionUID = -6494230465108115812L;
        Throwable exception = null;

        AsyncMultiReadProcedure() {
        }

        public synchronized void execute(AsyncReadGraph graph, T t) {
            this.add(t);
        }

        public void finished(AsyncReadGraph graph) {
            this.exception = DONE;
        }

        public void exception(AsyncReadGraph graph, Throwable t) {
            this.exception = t;
        }

        public void checkAndThrow() throws DatabaseException {
            if (this.exception != DONE) {
                if (this.exception instanceof DatabaseException) {
                    throw (DatabaseException)this.exception;
                }
                throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(AsyncMultiRead)", this.exception);
            }
        }

        public boolean done() {
            return this.exception != null;
        }
    }

    static class AsyncReadProcedure<T>
    implements AsyncProcedure<T> {
        private static Throwable DONE = new Throwable();
        T result = null;
        Throwable exception = null;

        AsyncReadProcedure() {
        }

        public void execute(AsyncReadGraph graph, T t) {
            this.result = t;
            this.exception = DONE;
        }

        public void exception(AsyncReadGraph graph, Throwable t) {
            this.exception = t;
        }

        public void checkAndThrow() throws DatabaseException {
            if (this.exception != DONE) {
                if (this.exception instanceof DatabaseException) {
                    throw (DatabaseException)this.exception;
                }
                throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(AsyncRead)", this.exception);
            }
        }

        public boolean done() {
            return this.exception != null;
        }
    }

    private static class GraphHintsImpl
    implements GraphHints {
        private final ArrayMap<String, Object> map;

        public GraphHintsImpl(String key, Object value) {
            this.map = ArrayMap.make((Object[])new String[]{key}, (Object[])new Object[]{value});
        }

        public GraphHintsImpl(GraphHintsImpl base, String key, Object value) {
            if (base.map.containsKey((Object)key)) {
                this.map = ArrayMap.make((Object[])((String[])base.map.getKeys()), (Object[])base.map.getValuesCopy());
                this.map.put((Object)key, value);
            } else {
                Object[] newKeys = (String[])base.map.getKeysWithSpace(1);
                newKeys[newKeys.length - 1] = key;
                Object[] newValues = base.map.getValuesCopyWithSpace(1);
                newValues[newValues.length - 1] = value;
                this.map = new ArrayMap(newKeys, newValues);
            }
        }

        public <T> T get(String key) {
            return (T)this.map.get((Object)key);
        }

        public GraphHints withValue(String key, Object value) {
            return new GraphHintsImpl(this, key, value);
        }
    }

    static class MultiTripleIntProcedure
    implements TripleIntProcedure {
        private final AsyncMultiProcedure<Statement> procedure;
        private final ReadGraphImpl impl;
        private final QuerySupport support;

        public MultiTripleIntProcedure(AsyncMultiProcedure<Statement> procedure, ReadGraphImpl impl, QuerySupport support) {
            this.procedure = procedure;
            this.impl = impl;
            this.support = support;
        }

        @Override
        public void execute(ReadGraphImpl graph, int s, int p, int o) {
            try {
                this.procedure.execute((AsyncReadGraph)graph, (Object)this.support.getStatement(s, p, o));
            }
            catch (Throwable t2) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
            }
        }

        @Override
        public void finished(ReadGraphImpl graph) {
            try {
                this.procedure.finished((AsyncReadGraph)graph);
            }
            catch (Throwable t2) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
            }
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable t) {
            try {
                this.procedure.exception((AsyncReadGraph)graph, t);
            }
            catch (Throwable t2) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t2);
            }
        }

        public String toString() {
            return "forEachObject with " + this.procedure;
        }
    }

    static class PossibleConverterFunction<T>
    extends ResourceRead<Function3<ReadGraph, Resource, Object, T>> {
        public PossibleConverterFunction(Resource resource) {
            super(resource);
        }

        public Function3<ReadGraph, Resource, Object, T> perform(ReadGraph graph) throws DatabaseException {
            return PossibleConverterFunction.compute(graph, this.resource);
        }

        public static <T> Function3<ReadGraph, Resource, Object, T> compute(ReadGraph graph, Resource resource) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Iterator iterator = graph.getObjects(resource, L0.ConvertsToValueWith).iterator();
            if (iterator.hasNext()) {
                Resource converter = (Resource)iterator.next();
                try {
                    if (L0.Functions_functionApplication.equals(converter)) {
                        return (Function3)graph.syncRequest((Read)new AdaptValue(resource));
                    }
                    return (Function3)graph.getValue2(converter, (Object)resource);
                }
                catch (RuntimeException e) {
                    DatabaseException dte = ReadGraphImpl.findPossibleRootException(e);
                    if (dte != null) {
                        throw dte;
                    }
                    throw new DatabaseException((Throwable)e);
                }
            }
            return null;
        }
    }

    static class StatementReadProcedure
    extends TIntArrayListInternal
    implements StatementProcedure {
        private static Throwable DONE = new Throwable();
        Throwable exception = null;
        final ResourceSupport support;

        public StatementReadProcedure(ResourceSupport support) {
            this.support = support;
        }

        public synchronized void execute(AsyncReadGraph graph, int s, int p, int o) {
            this.add(s);
            this.add(p);
            this.add(o);
        }

        public void finished(AsyncReadGraph graph) {
            this.exception = DONE;
        }

        public void exception(AsyncReadGraph graph, Throwable t) {
            this.exception = t;
        }

        public void checkAndThrow() throws DatabaseException {
            if (this.exception != DONE) {
                if (this.exception instanceof DatabaseException) {
                    throw (DatabaseException)this.exception;
                }
                throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(AsyncMultiRead)", this.exception);
            }
        }

        public boolean done() {
            return this.exception != null;
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof InternalStatement)) {
                return false;
            }
            InternalStatement statement = (InternalStatement)obj;
            int s = statement.s;
            int p = statement.p;
            int o = statement.o;
            int i = 0;
            while (i < this.sizeInternal()) {
                if (s == this.getQuick(i) && p == this.getQuick(i + 1) && o == this.getQuick(i + 2)) {
                    return true;
                }
                i += 3;
            }
            return false;
        }

        public <T> T[] toArray(T[] a) {
            int length = this.sizeInternal() / 3;
            if (length > a.length) {
                Class<?> arrayType = a.getClass();
                a = arrayType == Object[].class ? new Object[length] : (Object[])Array.newInstance(arrayType.getComponentType(), length);
            } else {
                int i = length;
                while (i < a.length) {
                    a[i] = null;
                    ++i;
                }
            }
            int i = 0;
            int j = 0;
            while (i < this.sizeInternal()) {
                a[j] = new InternalStatement(this.support, this.getQuick(i), this.getQuick(i + 1), this.getQuick(i + 2));
                i += 3;
                ++j;
            }
            return a;
        }

        public boolean add(Statement e) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection<? extends Statement> c) {
            throw new UnsupportedOperationException();
        }

        public Iterator<Statement> iterator() {
            return new IteratorImpl(0);
        }

        public int size() {
            return this.sizeInternal() / 3;
        }

        public Object[] toArray() {
            Object[] result = new Object[this.sizeInternal() / 3];
            int i = 0;
            int j = 0;
            while (j < this.sizeInternal()) {
                result[i] = new InternalStatement(this.support, this.getQuick(j), this.getQuick(j + 1), this.getQuick(j + 2));
                ++i;
                j += 3;
            }
            return result;
        }

        public boolean addAll(int index, Collection<? extends Statement> c) {
            throw new UnsupportedOperationException();
        }

        public Statement get(int index) {
            if ((index += 3) < 0 || index >= this.sizeInternal()) {
                throw new IndexOutOfBoundsException();
            }
            return new InternalStatement(this.support, this.getQuick(index), this.getQuick(index + 1), this.getQuick(index + 2));
        }

        public Statement set(int index, Statement element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Statement element) {
            throw new UnsupportedOperationException();
        }

        public Statement remove(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object obj) {
            if (!(obj instanceof InternalStatement)) {
                return -1;
            }
            InternalStatement statement = (InternalStatement)obj;
            int s = statement.s;
            int p = statement.p;
            int o = statement.o;
            int i = 0;
            while (i < this.sizeInternal()) {
                if (s == this.getQuick(i) && p == this.getQuick(i + 1) && o == this.getQuick(i + 2)) {
                    return i / 3;
                }
                i += 3;
            }
            return -1;
        }

        public int lastIndexOf(Object obj) {
            if (!(obj instanceof InternalStatement)) {
                return -1;
            }
            InternalStatement statement = (InternalStatement)obj;
            int s = statement.s;
            int p = statement.p;
            int o = statement.o;
            int i = this.sizeInternal() - 3;
            while (i >= 0) {
                if (s == this.getQuick(i) && p == this.getQuick(i + 1) && o == this.getQuick(i + 2)) {
                    return i / 3;
                }
                i -= 3;
            }
            return -1;
        }

        public ListIterator<Statement> listIterator() {
            return new IteratorImpl(0);
        }

        public ListIterator<Statement> listIterator(int index) {
            return new IteratorImpl(index * 3);
        }

        public List<Statement> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex * 3 >= this.sizeInternal() || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            return new RandomAccessSubList<Statement>((List<Statement>)((Object)this), fromIndex, toIndex - fromIndex);
        }

        class IteratorImpl
        implements ListIterator<Statement> {
            int index;

            public IteratorImpl(int index) {
                this.index = index;
            }

            @Override
            public boolean hasNext() {
                return this.index < StatementReadProcedure.this.sizeInternal();
            }

            @Override
            public Statement next() {
                InternalStatement result = new InternalStatement(StatementReadProcedure.this.support, StatementReadProcedure.this.getQuick(this.index), StatementReadProcedure.this.getQuick(this.index + 1), StatementReadProcedure.this.getQuick(this.index + 2));
                this.index += 3;
                return result;
            }

            @Override
            public void remove() {
                throw new Error("Not supported");
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Statement previous() {
                this.index -= 3;
                InternalStatement result = new InternalStatement(StatementReadProcedure.this.support, StatementReadProcedure.this.getQuick(this.index), StatementReadProcedure.this.getQuick(this.index + 1), StatementReadProcedure.this.getQuick(this.index + 2));
                return result;
            }

            @Override
            public int nextIndex() {
                return this.index / 3;
            }

            @Override
            public int previousIndex() {
                return this.index / 3 - 1;
            }

            @Override
            public void set(Statement e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Statement e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

