package org.simantics.db.impl.query;

import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.exception.DatabaseException;

public class ChildMapFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException {
        ChildMap result = reference(deserializer);
        ObjectResourceIdMap<String> map = deserializer.createChildMap();
        int size = deserializer.readLE4();
        for(int i=0;i<size;i++) {
            String key = deserializer.readString();
            int r2 = deserializer.readResource();
            map.putId(key, r2);
        }
        result.setResult(map);
        result.setReady();
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializer deserializer) throws DatabaseException {
        return (T)deserializer.readChildMap();
    }

}
