/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;


public class DataTypeDefinition {

	String name;
	Datatype dataType;
	
	public DataTypeDefinition(String name, Datatype dataType)
	{
		this.name = name;
		this.dataType = dataType;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public Datatype getDataType() {
		return dataType;
	}
	
	@Override
	public String toString() {
		return name+" = "+dataType.toString();
	}

	@Override
	public int hashCode() {
		return name.hashCode() + dataType.hashCode()*7;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof DataTypeDefinition==false) return false;
		DataTypeDefinition other = (DataTypeDefinition) obj;
		return other.name.equals(name) && other.dataType.equals(dataType);
	}
	
}

