/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.mutable;

import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.MutableInteger;
import org.simantics.databoard.type.IntegerType;

public class MutableIntegerBinding extends IntegerBinding {

	public MutableIntegerBinding(IntegerType type) {
		super(type);
	}

	@Override
	public Object create(int value) {
		MutableInteger result = new MutableInteger();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Integer value) {
		MutableInteger result = new MutableInteger();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Number value) {
		MutableInteger result = new MutableInteger();
		result.value = value.intValue();
		return result;
	}

	@Override
	public Object create(String value) throws BindingException {
		try {
			MutableInteger result = new MutableInteger();
			result.value = Integer.valueOf(value);
			return result;
		} catch (java.lang.NumberFormatException e) {
			throw new BindingException( e );
		}
	}

	@Override
	public int getValue_(Object obj) throws BindingException {
		MutableInteger result = (MutableInteger) obj;
		return result.value;
	}

	@Override
	public Integer getValue(Object obj) throws BindingException {
		MutableInteger result = (MutableInteger) obj;
		return result.value;
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj instanceof MutableInteger; 
	}

	@Override
	public void setValue(Object obj, int value) throws BindingException {
		MutableInteger result = (MutableInteger) obj;
		result.value = value;
	}

	@Override
	public void setValue(Object obj, Number value) throws BindingException {
		MutableInteger result = (MutableInteger) obj;
		result.value = value.intValue();
	}

	
	
}

