/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.StringType;

/**
 * StringBindingDefault is a binding to java.lang.String class.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class StringBindingDefault extends StringBinding {

	public StringBindingDefault(StringType type) {
		super(type);
	}
	
	public Object create(String value) 
	{
		return value;
	}
	
	public String getValue(Object o) 
	throws BindingException 
	{
		return (String)o;
	}
	
	public void setValue(Object o, String newValue) 
	throws BindingException 
	{
		throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.String");
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj instanceof String;
	}		
	
	@Override
	public boolean isImmutable() {
		return true;
	}
	
	
}

