/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.databoard.accessor.Accessor.Listener;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ModificationEvent;

/**
 * Event Collection is a {@link Listener} implementation that collects events.
 *
 * @see ModificationEvent
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class EventCollection implements Listener {

	public List<Event> events = new ArrayList<Event>();
	
	public synchronized void addEvent(Event event) {
		this.events.add(event);
	}
		
	public synchronized void addEvents(Collection<Event> events) {
		this.events.addAll(events);
	}
		
	/**
	 * Returns events and clears change set.
	 * 
	 * @return the list of events
	 */
	public synchronized List<Event> getAndClearEvents() {
		List<Event> result = events;
		events = new ArrayList<Event>();
		return result;
	}
	
	public synchronized boolean isEmpty() {
		return events.isEmpty();
	}
	
	/**
	 * Get a snapshot of events.
	 * 
	 * @return a copy of events
	 */
	public synchronized List<Event> getEvents() {
		return new ArrayList<Event>( events );
	}

	@Override
	public void onEvents(Collection<Event> events) {
		addEvents(events);
	}
	
	@Override
	public synchronized String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append('[');
		int len = events.size();
		if (len>1) sb.append("\n ");
		for (int i=0; i<len; i++) {
			Event e = events.get(i);
			if (i>0) sb.append("\n ");
			sb.append(e.toString());
		}
		if (len>1) sb.append('\n');
		sb.append(']');
		return sb.toString();
	}

	public synchronized void clear() {
		events.clear();
	}
	
}

