/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetComboProperty;
import org.simantics.g3d.property.annotations.GetComboPropertyValue;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.SetComboPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.tools.NodeTools;
import org.simantics.objmap.graph.annotations.DynamicGraphType;
import org.simantics.objmap.graph.annotations.GetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.objmap.graph.annotations.SetType;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.controlpoint.ControlPointFactory;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;

@DynamicGraphType(value="http://www.simantics.org/Plant3D-0.1/TurnComponent")
public class TurnComponent
extends PipelineComponent {
    private String type;
    private PipeControlPoint controlPoint;
    private Integer turnRadiusIndex;

    @Override
    @GetType(value="http://www.simantics.org/Plant3D-0.1/TurnComponent")
    public String getType() {
        return this.type;
    }

    @Override
    @SetType(value="http://www.simantics.org/Plant3D-0.1/TurnComponent")
    public void setType(String type) throws Exception {
        this.type = type;
        this.controlPoint = ControlPointFactory.create(this);
        this.syncNext();
        this.syncPrevious();
        this.syncBranch0();
    }

    @Override
    public PipeControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public void setParent(ParentNode<?> parent, String name) {
        super.setParent(parent, name);
        this.setPipeRun((PipeRun)parent);
    }

    @Override
    public Map<String, Object> updateParameterMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.getPipeRun() != null) {
            map.put("turnRadius", this.getTurnRadius());
            map.put("radius", this.getDiameter() * 0.5);
        }
        if (this.controlPoint != null && this.controlPoint.getTurnAngle() != null && !Double.isNaN(this.controlPoint.getTurnAngle())) {
            map.put("turnAngle", this.controlPoint.getTurnAngle());
        }
        return map;
    }

    public boolean isVariableAngle() {
        return !this.controlPoint.isFixed();
    }

    @Override
    public void updateParameters() {
        super.updateParameters();
        if (this.controlPoint.asFixedAngle()) {
            Map<String, Object> calculated = this.getCalculatedParameters();
            if (calculated.containsKey("length")) {
                this.controlPoint.setLength((Double)calculated.get("length"));
            }
            this.getControlPoint().requestUpdate();
        }
    }

    public Double getTurnAngle() {
        return this.getControlPoint().getTurnAngle();
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnAngle")
    public Double _getTurnAngle() {
        if (!this.getControlPoint().asFixedAngle()) {
            return null;
        }
        return this.getControlPoint().getTurnAngle();
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnAngle")
    public void setTurnAngle(Double a) {
        if (!this.getControlPoint().asFixedAngle()) {
            return;
        }
        this.getControlPoint().setTurnAngle(a);
    }

    @GetPropertyValue(name="Turn Angle", value="turn angle", tabId="Default")
    public Double getTurnAngleDeg() {
        Double d = this.getControlPoint().getTurnAngle();
        if (d == null) {
            return null;
        }
        return MathTools.radToDeg((double)d);
    }

    public Vector3d getTurnAxis() {
        return this.getControlPoint().getTurnAxis();
    }

    public Double getTurnRadius() {
        if (this.turnRadiusIndex != null) {
            return this.getPipeRun().getTurnRadiusArray()[this.turnRadiusIndex];
        }
        return this.getPipeRun().getTurnRadiusArray()[0];
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")
    @GetComboPropertyValue(name="Turn Radius", value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex", tabId="Default")
    public Integer getTurnRadiusIndex() {
        if (this.turnRadiusIndex == null) {
            return 0;
        }
        return this.turnRadiusIndex;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")
    @SetComboPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")
    public void setTurnRadiusIndex(Integer turnRadiusIndex) {
        if (this.turnRadiusIndex == turnRadiusIndex) {
            return;
        }
        if (turnRadiusIndex == null || turnRadiusIndex < 0) {
            return;
        }
        if (turnRadiusIndex != null && this.getPipeRun() != null && this.getPipeRun().getTurnRadiusArray().length <= turnRadiusIndex) {
            return;
        }
        this.turnRadiusIndex = turnRadiusIndex;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex");
        this.getControlPoint().requestUpdate();
    }

    @GetComboProperty(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")
    public List<Double> _getTurnRadii() {
        ArrayList<Double> values = new ArrayList<Double>();
        double[] dArray = this.getPipeRun().getTurnRadiusArray();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            values.add(d);
            ++n2;
        }
        return values;
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle")
    @GetPropertyValue(name="Rotation Angle", value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle", tabId="Default")
    public Double getRotationAngle() {
        if (!this.controlPoint.asFixedAngle()) {
            return null;
        }
        Double d = this.controlPoint.getRotationAngle();
        if (d == null) {
            return 0.0;
        }
        return MathTools.radToDeg((double)d);
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle")
    @SetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle")
    public void setRotationAngle(Double angle) {
        if (!this.controlPoint.asFixedAngle()) {
            return;
        }
        if (angle == null || Double.isInfinite(angle) || Double.isNaN(angle)) {
            return;
        }
        angle = MathTools.degToRad((double)angle);
        if (this.controlPoint.getRotationAngle() != null && Math.abs(this.controlPoint.getRotationAngle() - angle) < MathTools.NEAR_ZERO) {
            return;
        }
        this.controlPoint.setRotationAngle(angle);
        this.getControlPoint().requestUpdate();
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/IsReversed")
    @GetPropertyValue(name="Reverse", value="http://www.simantics.org/Plant3D-0.1/IsReversed", tabId="Default")
    public Boolean isReversed() {
        if (!this.controlPoint.asFixedAngle()) {
            return null;
        }
        Boolean d = this.controlPoint._getReversed();
        return d;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/IsReversed")
    public void setReversed(Boolean reverse) {
        if (!this.controlPoint.asFixedAngle()) {
            return;
        }
        if (reverse == null) {
            return;
        }
        this.controlPoint.setReversed(reverse);
        this.getControlPoint().requestUpdate();
    }

    @Override
    protected double[] getColor() {
        if (this.getControlPoint() == null || !this.getControlPoint().isFixed()) {
            return new double[]{0.6, 0.6, 0.6};
        }
        return new double[]{1.0, 0.0, 0.0};
    }

    public Vector3d getCenterPosition() {
        double t = Math.tan((Math.PI - this.getControlPoint().getTurnAngle()) * 0.5);
        double tr = this.getTurnRadius();
        double R = 0.0;
        if (t > MathTools.NEAR_ZERO) {
            R = tr / t;
        }
        Vector3d localC = new Vector3d(-R, 0.0, -tr);
        Vector3d worldC = NodeTools.getWorldPosition((IG3DNode)this, (Vector3d)localC);
        return worldC;
    }

    public Vector3d getMiddlePosition() {
        Vector3d pos = this.getWorldPosition();
        Vector3d worldC = this.getCenterPosition();
        pos.sub((Tuple3d)worldC);
        pos.normalize();
        pos.scale(this.getTurnRadius().doubleValue());
        pos.add((Tuple3d)worldC);
        return pos;
    }

    @Override
    public void setParameterMap(Map<String, Object> parameters) {
        Double turnAngle;
        super.setParameterMap(parameters);
        if (this.getControlPoint() != null && (turnAngle = (Double)parameters.get("turnAngle")) != null) {
            this.getControlPoint().setTurnAngle(turnAngle);
        }
    }
}

