/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.plant3d.geometry.BuiltinGeometryProvider;

public class CheckValveGeometryProvider
extends BuiltinGeometryProvider {
    private double radius = 0.01;

    public CheckValveGeometryProvider(Resource resource) {
        super(resource);
    }

    public Collection<TopoDS_Shape> getModel() throws Exception {
        if (this.radius < MathTools.NEAR_ZERO) {
            return Collections.emptyList();
        }
        double l = this.radius * 0.2;
        TopoDS_Shape cyl = OccTriangulator.makeCylinder((double[])new double[]{this.radius - l, 0.0, 0.0}, (double[])new double[]{1.0, 0.0, 0.0}, (double)this.radius, (double)l);
        TopoDS_Shape con = OccTriangulator.makeCone((double[])new double[]{-this.radius, 0.0, 0.0}, (double[])new double[]{1.0, 0.0, 0.0}, (double)this.radius, (double)(this.radius * 0.1), (double)(this.radius * 2.0));
        TopoDS_Shape shape = OccTriangulator.makeFuse((TopoDS_Shape)cyl, (TopoDS_Shape)con);
        cyl.delete();
        con.delete();
        return Collections.singletonList(shape);
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("radius")) {
            this.radius = (Double)props.get("radius");
        }
        if (this.radius < MathTools.NEAR_ZERO) {
            this.radius = MathTools.NEAR_ZERO;
        }
    }

    @Override
    public void updateCalculatedProperties(Map<String, Object> returnProps) {
        returnProps.put("length", this.radius * 2.0);
    }
}

