/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.vtk.common.AbstractVTKNodeMap;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.objmap.graph.IMapping;
import org.simantics.plant3d.ontology.Plant3D;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.IP3DVisualNode;
import org.simantics.plant3d.scenegraph.P3DParentNode;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.ParameterizedNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import vtk.vtkProp;
import vtk.vtkProp3D;

public class P3DNodeMap
extends AbstractVTKNodeMap<Resource, INode> {
    private static final boolean DEBUG = false;

    public P3DNodeMap(Session session, IMapping<Resource, INode> mapping, VtkView panel, P3DRootNode rootNode) {
        super(session, mapping, panel, (ParentNode)rootNode);
        rootNode.setNodeMap((NodeMap<Resource, vtkProp, INode>)this);
    }

    protected void updateActor(INode n, Set<String> ids) {
        if (!(n instanceof IP3DVisualNode)) {
            if (n instanceof PipeControlPoint) {
                if ((n = ((PipeControlPoint)n).getPipelineComponent()) == null) {
                    return;
                }
            } else {
                return;
            }
        }
        IP3DVisualNode node = (IP3DVisualNode)n;
        if (ids.contains("http://www.simantics.org/Plant3D-0.1/hasGeometry")) {
            node.visualize(this.view);
            this.updateRenderObjectsFor((INode)node);
            this.updateTransform(node);
        }
        if (n instanceof ParameterizedNode) {
            ParameterizedNode geom = (ParameterizedNode)n;
            for (String id : geom.getParameterMap().keySet()) {
                if (!ids.contains(id)) continue;
                node.visualize(this.view);
                this.updateRenderObjectsFor((INode)node);
                break;
            }
        } else if (n instanceof PipeRun) {
            PipeRun run = (PipeRun)n;
            if (ids.contains("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray") || ids.contains("http://www.simantics.org/Plant3D-0.1/HasTurnRadius")) {
                this.requestTurnUpdates(run);
            }
            HashSet<String> ids2 = new HashSet<String>();
            ids2.add("http://www.simantics.org/Plant3D-0.1/hasGeometry");
            for (PipeControlPoint pcp : run.getControlPoints()) {
                this.updateActor((INode)pcp, ids2);
            }
        }
        if (ids.contains("http://www.simantics.org/G3D-0.1/hasPosition") || ids.contains("http://www.simantics.org/G3D-0.1/hasOrientation") || ids.contains("http://www.simantics.org/G3D-0.1/hasWorldPosition") || ids.contains("http://www.simantics.org/G3D-0.1/hasWorldOrientation")) {
            this.updateTransform(node);
        }
        if (ids.contains("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")) {
            node.visualize(this.view);
            this.updateRenderObjectsFor((INode)node);
        }
    }

    private void requestTurnUpdates(PipeRun run) {
        for (PipeControlPoint pcp : run.getControlPoints()) {
            if (!pcp.isTurn()) continue;
            pcp.requestUpdate();
        }
    }

    private void updateTransform(IP3DNode node) {
        node.update(this.view.getRenderer());
        if (node instanceof ParentNode) {
            ParentNode p = (ParentNode)node;
            for (IP3DNode n : p.getNodes()) {
                this.updateTransform(n);
            }
        }
    }

    protected Collection<vtkProp> getActors(INode n) {
        ArrayList<vtkProp> props = new ArrayList<vtkProp>();
        if (!(n instanceof IP3DVisualNode)) {
            return props;
        }
        IP3DVisualNode node = (IP3DVisualNode)n;
        for (vtkProp3D p : node.getActors()) {
            props.add((vtkProp)p);
        }
        return props;
    }

    protected void removeActor(INode n) {
        if (!(n instanceof IP3DVisualNode)) {
            return;
        }
        IP3DVisualNode node = (IP3DVisualNode)n;
        this.remActor(node);
        if (node instanceof P3DParentNode) {
            for (IP3DNode n2 : ((P3DParentNode)node).getNodes()) {
                if (!(n2 instanceof IP3DVisualNode)) continue;
                this.removeActor((INode)((IP3DVisualNode)n2));
            }
        }
    }

    protected void addActor(INode n) {
        if (!(n instanceof IP3DVisualNode)) {
            return;
        }
        IP3DVisualNode node = (IP3DVisualNode)n;
        if (this.hasActor(node)) {
            return;
        }
        if (Thread.currentThread() != this.view.getThreadQueue().getThread()) {
            throw new RuntimeException("Illegal thread.");
        }
        this.view.lock();
        node.visualize(this.view);
        this.map((INode)node, node.getActors());
        if (node instanceof P3DParentNode) {
            for (IP3DNode n2 : ((P3DParentNode)node).getNodes()) {
                if (!(n2 instanceof IP3DVisualNode)) continue;
                this.addActor((INode)((IP3DVisualNode)n2));
            }
        }
        this.updateTransform(node);
        this.view.unlock();
    }

    private boolean hasActor(IP3DVisualNode node) {
        Collection list = this.getRenderObjects((INode)node);
        return list != null && list.size() != 0;
    }

    private void remActor(IP3DVisualNode node) {
        if (Thread.currentThread() != this.view.getThreadQueue().getThread()) {
            throw new RuntimeException("Illegal thread.");
        }
        Collection list = this.getRenderObjects((INode)node);
        if (list.size() > 0) {
            this.removeMap((INode)node);
            this.view.lock();
            node.stopVisualize();
            this.view.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ReadGraph graph) throws DatabaseException {
        Object object = this.editMutex;
        synchronized (object) {
            this.validate();
            super.update(graph);
            this.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(String commitMessage) {
        Object object = this.editMutex;
        synchronized (object) {
            this.validate();
        }
        super.commit(commitMessage);
    }

    protected void commit(WriteGraph graph) throws DatabaseException {
        try {
            ((P3DRootNode)this.rootNode).updatePipingRules();
        }
        catch (Exception e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)((Object)e);
            }
            throw new DatabaseException("Updating piping rules failed", (Throwable)e);
        }
        super.commit(graph);
        this.validateGraph((ReadGraph)graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() {
        Object object = this.editMutex;
        synchronized (object) {
            this.validate();
        }
        super.doCommit();
    }

    private void validate() {
        for (INode node : this.rootNode.getNodes()) {
            if (!(node instanceof PipeRun)) continue;
            ((P3DRootNode)this.rootNode).validate((PipeRun)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preRender() {
        try {
            Object object = this.editMutex;
            synchronized (object) {
                boolean b = true;
                while (b) {
                    this.updateCycle();
                    b = ((P3DRootNode)this.getRootNode()).updatePipingRules();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void validateGraph(ReadGraph graph) throws DatabaseException {
        Plant3D P3D = Plant3D.getInstance((ReadGraph)graph);
        Resource root = (Resource)this.mapping.inverseGet((Object)this.rootNode);
        if (!graph.isInstanceOf(root, P3D.Plant)) {
            throw new DatabaseException("Root is not a Plant");
        }
        HashSet<Resource> equipment = new HashSet<Resource>();
        HashSet<Resource> pipeRuns = new HashSet<Resource>();
        for (Resource r : graph.getObjects(root, P3D.children)) {
            if (graph.isInstanceOf(r, P3D.Equipment)) {
                equipment.add(r);
                continue;
            }
            if (graph.isInstanceOf(r, P3D.PipeRun)) {
                pipeRuns.add(r);
                continue;
            }
            throw new DatabaseException("Unknown resource " + r + " " + this.mapping.get((Object)r));
        }
        HashSet<Resource> nozzles = new HashSet<Resource>();
        for (Resource e : equipment) {
            for (Resource n : graph.getObjects(e, P3D.HasNozzle)) {
                if (graph.isInstanceOf(n, P3D.Nozzle)) {
                    nozzles.add(n);
                    continue;
                }
                throw new DatabaseException("Unknown nozzle resource " + n + " " + this.mapping.get((Object)n));
            }
        }
        HashSet<Resource> components = new HashSet<Resource>();
        for (Resource run : pipeRuns) {
            for (Resource c : graph.getObjects(run, P3D.children)) {
                if (graph.isInstanceOf(c, P3D.PipelineComponent)) {
                    components.add(c);
                    continue;
                }
                throw new DatabaseException("Unknown component resource " + c + " " + this.mapping.get((Object)c));
            }
        }
        for (Resource c : components) {
            for (Resource connected : graph.getObjects(c, P3D.Connects)) {
                if (!components.contains(connected) && !nozzles.contains(connected)) {
                    throw new DatabaseException("Unbrowsable component resource " + connected + " " + this.mapping.get((Object)connected) + " connected to " + c + " " + this.mapping.get((Object)c));
                }
                Collection connectedConnected = graph.getObjects(connected, P3D.Connects);
                if (connectedConnected.contains(c)) continue;
                throw new DatabaseException("Component resource " + c + " " + this.mapping.get((Object)c) + " is connected to " + connected + " " + this.mapping.get((Object)connected) + ", but its has no connection back.");
            }
        }
    }
}

