/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.dialog.ComponentContentProvider;
import org.simantics.plant3d.dialog.ComponentLabelProvider;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.utils.Item;
import org.simantics.plant3d.utils.P3DUtil;
import org.simantics.utils.ui.ExceptionUtils;

public class ComponentSelectionDialog
extends Dialog
implements ISelectionChangedListener {
    private static final String DIALOG = "ComponentSelectionDialog";
    private IDialogSettings dialogSettings;
    private double lengthFactor = 1.0;
    private String lengthUnit = "m";
    private ResourceManager resourceManager;
    private String libUri;
    private Item selected;
    private Set<PipeControlPoint.PositionType> allowed;
    private Set<PipeControlPoint.PositionType> filterAllowed;
    private PipelineComponent component;
    private boolean insertAdjustable;
    private boolean lenghtAdjustable;
    private PipeControlPoint.PositionType insertPosition = PipeControlPoint.PositionType.NEXT;
    private Double angle;
    private Double length;
    private Double rotationAngle;
    private String name;
    private Text nameText;
    private Text lengthText;
    private Text angleText;
    private Text rotationAngleText;
    private Double diameter;
    private Double thickness;
    private Double turnRadius;
    private Text diameterText;
    private Text thicknessText;
    private Text turnRadiusText;
    private Label validationLabel;
    private Button startButton;
    private Button middleButton;
    private Button endButton;
    private boolean inlineSplit = false;
    ListViewer inlineViewer;
    ListViewer turnViewer;
    ListViewer endViewer;
    private Set<String> usedNames;
    private String selectedItemUri;
    private List<Item> ends;
    private List<Item> turns;
    private List<Item> inlines;
    private ExpandBar expandBar;

    public ComponentSelectionDialog(Shell parentShell, Set<PipeControlPoint.PositionType> allowed, PipelineComponent component) {
        this(parentShell, allowed, component, "http://www.simantics.org/Plant3D-0.1/Builtin");
    }

    public ComponentSelectionDialog(Shell parentShell, Set<PipeControlPoint.PositionType> allowed, PipelineComponent component, String libUri) {
        super(parentShell);
        this.allowed = allowed;
        this.component = component;
        this.filterAllowed = new HashSet<PipeControlPoint.PositionType>();
        this.insertAdjustable = component instanceof InlineComponent ? ((InlineComponent)component).isVariableLength() : false;
        this.lenghtAdjustable = false;
        this.libUri = libUri;
        this.usedNames = new HashSet<String>();
        this.setShellStyle(this.getShellStyle() | 0x10);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(DIALOG);
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(DIALOG);
        }
        if (component.getNext() != null && component.getPrevious() != null) {
            this.insertPosition = PipeControlPoint.PositionType.PREVIOUS;
        }
    }

    public void setSelectedItem(String selectedTypeUri) {
        this.selectedItemUri = selectedTypeUri;
    }

    private void copyPipeRunParameters() {
        PipeRun run = this.component.getPipeRun();
        if (this.component.getNext() == null && this.component.getAlternativePipeRun() != null) {
            run = this.component.getAlternativePipeRun();
        }
        if (run == null) {
            return;
        }
        this.diameter = run.getPipeDiameter();
        this.thickness = run.getPipeThickness();
        this.turnRadius = run.getTurnRadius();
        this.diameterText.setText(Double.toString(this.diameter * this.lengthFactor));
        this.thicknessText.setText(Double.toString(this.thickness * this.lengthFactor));
        this.turnRadiusText.setText(Double.toString(this.turnRadius * this.lengthFactor));
    }

    public void setLengthFactor(double lengthFactor) {
        this.lengthFactor = lengthFactor;
    }

    public void setLengthUnit(String lengthUnit) {
        this.lengthUnit = lengthUnit;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogSettings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create pipeline component");
    }

    public void addUsedNames(Collection<String> names) {
        this.usedNames.addAll(names);
    }

    protected List<Item> getItems(Class<?> c, String libUri) throws DatabaseException {
        Session session = Simantics.getSession();
        if (InlineComponent.class.equals(c)) {
            return P3DUtil.getInlines((RequestProcessor)session, libUri);
        }
        if (TurnComponent.class.equals(c)) {
            return P3DUtil.getTurns((RequestProcessor)session, libUri);
        }
        if (EndComponent.class.equals(c)) {
            return P3DUtil.getEnds((RequestProcessor)session, libUri);
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        boolean isOpen;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ComponentSelectionDialog.applyDialogFont((Control)composite);
        GridDataFactory horizFillData = GridDataFactory.fillDefaults().grab(true, false).align(4, 128);
        try {
            this.ends = this.getItems(EndComponent.class, this.libUri);
            this.turns = this.getItems(TurnComponent.class, this.libUri);
            this.inlines = this.getItems(InlineComponent.class, this.libUri);
        }
        catch (DatabaseException e) {
            Label label = new Label(composite, 0);
            label.setText("Cannot load pipeline components: " + e.getMessage());
            ExceptionUtils.logError((Throwable)e);
            return composite;
        }
        this.ends = P3DUtil.filterUserComponents(this.ends);
        this.turns = P3DUtil.filterUserComponents(this.turns);
        this.inlines = P3DUtil.filterUserComponents(this.inlines);
        this.expandBar = new ExpandBar(composite, 512);
        boolean bl = isOpen = this.component.getNext() == null || this.component.getPrevious() == null;
        if (!this.inlines.isEmpty()) {
            if (!isOpen) {
                ListIterator<Item> it = this.inlines.listIterator();
                while (it.hasNext()) {
                    Item item = it.next();
                    if (!item.isVariable()) continue;
                    it.remove();
                }
            }
            this.inlineViewer = this.createItemList(this.expandBar, this.inlines, "Inline");
        }
        if (isOpen) {
            if (!this.turns.isEmpty()) {
                this.turnViewer = this.createItemList(this.expandBar, this.turns, "Elbow");
            }
            if (!this.ends.isEmpty()) {
                this.turnViewer = this.createItemList(this.expandBar, this.ends, "End");
            }
        }
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(3, 1).applyTo((Control)this.expandBar);
        GridDataFactory.fillDefaults().grab(true, true).minSize(300, 500).hint(300, 500).applyTo((Control)composite);
        ExpandItem[] expandBarItems = this.expandBar.getItems();
        if (expandBarItems.length == 1) {
            expandBarItems[0].setExpanded(true);
        }
        Label label = new Label(composite, 0);
        label.setText("Position");
        Composite buttonComposite = new Composite(composite, 0);
        this.startButton = new Button(buttonComposite, 2);
        this.middleButton = new Button(buttonComposite, 2);
        this.endButton = new Button(buttonComposite, 2);
        this.startButton.setImage(this.resourceManager.createImage((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.simantics.plant3d", (String)"icons/insert_start.png").get()));
        this.middleButton.setImage(this.resourceManager.createImage((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.simantics.plant3d", (String)"icons/insert_middle.png").get()));
        this.endButton.setImage(this.resourceManager.createImage((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.simantics.plant3d", (String)"icons/insert_end.png").get()));
        this.startButton.setToolTipText("Overlapping insert");
        this.middleButton.setToolTipText("Cutting insert");
        this.endButton.setToolTipText("Adding insert");
        horizFillData.copy().span(2, 1).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonComposite);
        this.startButton.setSelection(this.insertPosition == PipeControlPoint.PositionType.PREVIOUS);
        this.middleButton.setSelection(this.insertPosition == PipeControlPoint.PositionType.SPLIT);
        this.endButton.setSelection(this.insertPosition == PipeControlPoint.PositionType.NEXT);
        this.startButton.setEnabled(false);
        this.middleButton.setEnabled(false);
        this.endButton.setEnabled(false);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionDialog.this.updateInsertPosition(PipeControlPoint.PositionType.PREVIOUS);
            }
        });
        this.middleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionDialog.this.updateInsertPosition(PipeControlPoint.PositionType.SPLIT);
            }
        });
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelectionDialog.this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
            }
        });
        if (!this.hasInsertPosition()) {
            label.setVisible(false);
            buttonComposite.setVisible(false);
        }
        label = new Label(composite, 0);
        label.setText("Name");
        this.nameText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText("");
        label = new Label(composite, 0);
        label.setText("Length");
        this.lengthText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText(this.lengthUnit);
        label = new Label(composite, 0);
        label.setText("Angle");
        this.angleText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText("\u00b0");
        label = new Label(composite, 0);
        label.setText("Rotation angle");
        this.rotationAngleText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText("\u00b0");
        label = new Label(composite, 0);
        label.setText("Diameter");
        this.diameterText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText(this.lengthUnit);
        label = new Label(composite, 0);
        label.setText("Wall thickness");
        this.thicknessText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText(this.lengthUnit);
        label = new Label(composite, 0);
        label.setText("Elbow radius");
        this.turnRadiusText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label.setText(this.lengthUnit);
        this.validationLabel = new Label(composite, 0);
        this.validationLabel.setText("");
        this.lengthText.setEnabled(false);
        this.angleText.setEnabled(false);
        this.rotationAngleText.setEnabled(false);
        this.turnRadiusText.setEnabled(false);
        this.diameterText.setEnabled(false);
        this.thicknessText.setEnabled(false);
        this.copyPipeRunParameters();
        this.nameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ComponentSelectionDialog.this.name = ComponentSelectionDialog.this.nameText.getText();
                ComponentSelectionDialog.this.validate();
            }
        });
        this.lengthText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.length = Double.parseDouble(ComponentSelectionDialog.this.lengthText.getText()) / ComponentSelectionDialog.this.lengthFactor;
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.length = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.angleText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.angle = Double.parseDouble(ComponentSelectionDialog.this.angleText.getText());
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.angle = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.rotationAngleText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.rotationAngle = Double.parseDouble(ComponentSelectionDialog.this.rotationAngleText.getText());
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.rotationAngle = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.diameterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.diameter = Double.parseDouble(ComponentSelectionDialog.this.diameterText.getText()) / ComponentSelectionDialog.this.lengthFactor;
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.diameter = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.thicknessText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.thickness = Double.parseDouble(ComponentSelectionDialog.this.thicknessText.getText()) / ComponentSelectionDialog.this.lengthFactor;
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.thickness = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        this.turnRadiusText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    ComponentSelectionDialog.this.turnRadius = Double.parseDouble(ComponentSelectionDialog.this.turnRadiusText.getText()) / ComponentSelectionDialog.this.lengthFactor;
                }
                catch (NumberFormatException err) {
                    ComponentSelectionDialog.this.turnRadius = null;
                }
                ComponentSelectionDialog.this.validate();
            }
        });
        horizFillData.applyTo((Control)this.nameText);
        horizFillData.applyTo((Control)this.lengthText);
        horizFillData.applyTo((Control)this.angleText);
        horizFillData.applyTo((Control)this.rotationAngleText);
        horizFillData.applyTo((Control)this.diameterText);
        horizFillData.applyTo((Control)this.thicknessText);
        horizFillData.applyTo((Control)this.turnRadiusText);
        GridDataFactory.fillDefaults().span(3, 1).align(0x1000008, 0x1000008).grab(true, false).applyTo((Control)this.validationLabel);
        if (!this.allowed.contains((Object)PipeControlPoint.PositionType.NEXT) && !this.allowed.contains((Object)PipeControlPoint.PositionType.PREVIOUS)) {
            if (this.turnViewer != null) {
                this.turnViewer.getList().setEnabled(false);
            }
            if (this.endViewer != null) {
                this.endViewer.getList().setEnabled(false);
            }
            this.inlineSplit = true;
        }
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        if (this.selectedItemUri != null) {
            ExpandItem[] expandItemArray = this.expandBar.getItems();
            int n = expandItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExpandItem item = expandItemArray[n2];
                Control control = item.getControl();
                if (this.inlineViewer != null && control == this.inlineViewer.getList()) {
                    ComponentSelectionDialog.activateSelectedItem(this.inlineViewer, item, this.inlines, this.selectedItemUri);
                } else if (this.turnViewer != null && control == this.turnViewer.getList()) {
                    ComponentSelectionDialog.activateSelectedItem(this.turnViewer, item, this.turns, this.selectedItemUri);
                } else if (this.endViewer != null && control == this.endViewer.getList()) {
                    ComponentSelectionDialog.activateSelectedItem(this.endViewer, item, this.ends, this.selectedItemUri);
                }
                ++n2;
            }
            this.nameText.setFocus();
            this.nameText.selectAll();
        }
        return result;
    }

    private static void activateSelectedItem(ListViewer viewer, ExpandItem expandItem, List<Item> items, String selectedItemUri) {
        if (viewer == null) {
            return;
        }
        for (Item item : items) {
            if (!item.getUri().equals(selectedItemUri)) continue;
            viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
            expandItem.setExpanded(true);
            break;
        }
    }

    private ListViewer createItemList(ExpandBar expandBar, List<Item> items, String name) {
        ExpandItem expandItem = new ExpandItem(expandBar, 0);
        expandItem.setText(name);
        ListViewer viewer = new ListViewer((Composite)expandBar);
        viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        viewer.setContentProvider((IContentProvider)new ComponentContentProvider());
        expandItem.setControl((Control)viewer.getList());
        viewer.setInput(items);
        expandItem.setHeight(viewer.getList().computeSize((int)-1, (int)-1).y);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return viewer;
    }

    private boolean hasInsertPosition() {
        return this.component.getNext() == null || this.component.getPrevious() == null;
    }

    private void updateInsertPosition(PipeControlPoint.PositionType type) {
        if (this.insertPosition == type) {
            return;
        }
        this.startButton.setSelection(type == PipeControlPoint.PositionType.PREVIOUS);
        this.middleButton.setSelection(type == PipeControlPoint.PositionType.SPLIT);
        this.endButton.setSelection(type == PipeControlPoint.PositionType.NEXT);
        this.insertPosition = type;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Item i = (Item)sel.getFirstElement();
        if (i != null) {
            this.selected = i;
            if (this.inlineViewer != null && event.getSource() == this.inlineViewer) {
                this.clearSelection(this.turnViewer);
                this.clearSelection(this.endViewer);
            } else if (this.turnViewer != null && event.getSource() == this.turnViewer) {
                this.clearSelection(this.inlineViewer);
                this.clearSelection(this.endViewer);
            } else if (this.endViewer != null && event.getSource() == this.endViewer) {
                this.clearSelection(this.inlineViewer);
                this.clearSelection(this.turnViewer);
            }
            this.name = this.generateUniqueName(this.selected.getName());
            this.nameText.setText(this.name);
            this.validate();
        }
    }

    private void clearSelection(ListViewer possibleListViewer) {
        if (possibleListViewer != null) {
            possibleListViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    private void validate() {
        String msg;
        boolean ok;
        HashSet<PipeControlPoint.PositionType> filterAllowed;
        block49: {
            block52: {
                block53: {
                    block51: {
                        block50: {
                            block48: {
                                this.filterAllowed.clear();
                                filterAllowed = new HashSet<PipeControlPoint.PositionType>();
                                ok = true;
                                msg = null;
                                if (this.name.isEmpty() || this.usedNames.contains(this.name)) {
                                    ok = false;
                                    if (msg == null) {
                                        msg = this.name.isEmpty() ? "Please provide a valid name" : "Name \"" + this.name + "\" is already in use";
                                    }
                                }
                                if (this.selected != null) break block48;
                                ok = false;
                                break block49;
                            }
                            if (!this.selected.isCode()) break block50;
                            ok = false;
                            break block49;
                        }
                        boolean bl = this.lenghtAdjustable = this.selected.getType() == Item.Type.INLINE && (this.selected.isVariable() || this.selected.isModifiable());
                        if (this.hasInsertPosition()) break block51;
                        this.startButton.setEnabled(false);
                        this.middleButton.setEnabled(false);
                        this.endButton.setEnabled(false);
                        this.updateInsertPosition(PipeControlPoint.PositionType.PREVIOUS);
                        break block52;
                    }
                    if (!this.insertAdjustable) break block53;
                    switch (this.selected.getType()) {
                        case END: {
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(false);
                            this.endButton.setEnabled(true);
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                            break;
                        }
                        case INLINE: {
                            if (!this.selected.isVariable()) {
                                this.startButton.setEnabled(true);
                                this.middleButton.setEnabled(true);
                                this.endButton.setEnabled(true);
                                break;
                            }
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(false);
                            this.endButton.setEnabled(true);
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                            break;
                        }
                        case NOZZLE: {
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(false);
                            this.endButton.setEnabled(true);
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                            break;
                        }
                        case TURN: {
                            this.startButton.setEnabled(false);
                            this.middleButton.setEnabled(true);
                            this.endButton.setEnabled(true);
                            if (this.insertPosition == PipeControlPoint.PositionType.PREVIOUS) {
                                this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                                break;
                            }
                            break block52;
                        }
                        case EQUIPMENT: {
                            throw new RuntimeException("Expected component, got equipment " + this.selected);
                        }
                    }
                    break block52;
                }
                if (this.lenghtAdjustable) {
                    if (this.component instanceof InlineComponent) {
                        this.startButton.setEnabled(true);
                        this.middleButton.setEnabled(true);
                        this.endButton.setEnabled(true);
                    } else if (this.component instanceof TurnComponent) {
                        this.startButton.setEnabled(false);
                        this.middleButton.setEnabled(true);
                        this.endButton.setEnabled(true);
                        if (this.insertPosition == PipeControlPoint.PositionType.PREVIOUS) {
                            this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                        }
                    } else if (this.component instanceof EndComponent || this.component instanceof Nozzle) {
                        this.startButton.setEnabled(false);
                        this.middleButton.setEnabled(false);
                        this.endButton.setEnabled(true);
                        this.updateInsertPosition(PipeControlPoint.PositionType.NEXT);
                    }
                } else {
                    this.startButton.setEnabled(false);
                    this.middleButton.setEnabled(false);
                    this.endButton.setEnabled(true);
                }
            }
            if (this.selected.isVariable() || this.selected.isModifiable()) {
                if (this.selected.getType() == Item.Type.INLINE) {
                    filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                    filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                    if (this.inlineSplit && this.selected.isVariable()) {
                        this.lengthText.setEnabled(false);
                        this.angleText.setEnabled(false);
                        this.rotationAngleText.setEnabled(this.selected.isRotated());
                        ok = false;
                        if (msg == null) {
                            msg = "Cannot split a straight pipe with a straight pipe";
                        }
                    } else {
                        this.lengthText.setEnabled(true);
                        this.angleText.setEnabled(false);
                        this.rotationAngleText.setEnabled(this.selected.isRotated());
                        if (this.length == null || this.length <= 0.0) {
                            ok = false;
                            if (msg == null) {
                                msg = "Please provide a valid length";
                            }
                        }
                    }
                } else if (this.selected.getType() == Item.Type.TURN) {
                    filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                    filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                    this.lengthText.setEnabled(false);
                    this.angleText.setEnabled(true);
                    this.rotationAngleText.setEnabled(true);
                    if (this.angle == null) {
                        ok = false;
                        if (msg == null) {
                            msg = "Please provide a turn angle";
                        }
                    }
                } else {
                    this.lengthText.setEnabled(false);
                    this.angleText.setEnabled(false);
                    this.rotationAngleText.setEnabled(false);
                }
            } else {
                this.lengthText.setEnabled(false);
                this.angleText.setEnabled(false);
                this.rotationAngleText.setEnabled(this.selected.getType() == Item.Type.TURN || this.selected.isRotated());
            }
            if (this.selected.isSizeChange()) {
                this.turnRadiusText.setEnabled(true);
                this.diameterText.setEnabled(true);
                this.thicknessText.setEnabled(true);
                if (this.diameter == null || this.diameter <= 0.0) {
                    ok = false;
                    if (msg == null) {
                        msg = "Please provide a valid diameter";
                    }
                }
                if (this.turnRadius == null || this.diameter != null && this.turnRadius < this.diameter / 2.0) {
                    ok = false;
                    if (msg == null) {
                        msg = "Please provide a valid turn radius";
                    }
                }
                if (this.thickness == null || this.thickness < 0.0 || this.diameter != null && this.thickness >= this.diameter / 2.0) {
                    ok = false;
                    if (msg == null) {
                        msg = "Please provide a valid wall thickness";
                    }
                }
            } else {
                this.turnRadiusText.setEnabled(false);
                this.diameterText.setEnabled(false);
                this.thicknessText.setEnabled(false);
            }
            if (!this.selected.isVariable()) {
                switch (this.selected.getType()) {
                    case END: {
                        filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                        filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                        break;
                    }
                    case EQUIPMENT: 
                    case NOZZLE: {
                        break;
                    }
                    case INLINE: {
                        filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                        filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                        filterAllowed.add(PipeControlPoint.PositionType.SPLIT);
                    }
                    case TURN: {
                        filterAllowed.add(PipeControlPoint.PositionType.NEXT);
                        filterAllowed.add(PipeControlPoint.PositionType.PREVIOUS);
                    }
                }
            }
        }
        for (PipeControlPoint.PositionType t : filterAllowed) {
            if (!this.allowed.contains((Object)t)) continue;
            this.filterAllowed.add(t);
        }
        this.validationLabel.setText(msg != null ? msg : "");
        this.validationLabel.requestLayout();
        this.getButton(0).setEnabled(ok);
    }

    private String generateUniqueName(String name) {
        String newName;
        int i = 1;
        while (this.usedNames.contains(newName = String.valueOf(name) + "_" + i)) {
            ++i;
        }
        return newName;
    }

    public Item getSelected() {
        return this.selected;
    }

    public String getName() {
        return this.name;
    }

    public Double getAngle() {
        return this.angle;
    }

    public Double getLength() {
        return this.length;
    }

    public Double getRotationAngle() {
        return this.rotationAngle;
    }

    public Double getDiameter() {
        return this.diameter;
    }

    public Double getTurnRadius() {
        return this.turnRadius;
    }

    public Set<PipeControlPoint.PositionType> filterAllowed() {
        return this.filterAllowed;
    }

    public PipeControlPoint.PositionType getInsertPosition() {
        return this.insertPosition;
    }

    public boolean isInsertAdjustable() {
        return this.insertAdjustable;
    }

    public boolean isLenghtAdjustable() {
        return this.lenghtAdjustable;
    }

    public Double getThickness() {
        return this.thickness;
    }
}

