package org.simantics.views.swt.client.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.utils.ui.jface.BasePostSelectionProvider;
import org.simantics.views.ViewUtils.LayoutBean;
import org.simantics.views.swt.client.base.ISWTViewNode;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTTabFolder extends SingleSWTViewNode<CTabFolder> {
	
	private static final long serialVersionUID = -8003676031533344133L;

	public List<String> childNames;

	public LayoutBean layout;
	
	final BasePostSelectionProvider selectionProvider = new BasePostSelectionProvider();

	ISelectionChangedListener selectionListener = new ISelectionChangedListener() {
		
		@Override
		public void selectionChanged(SelectionChangedEvent event) {
			selectionProvider.firePostSelection(event.getSelection());
		}
		
	};
	
	private CTabItem createItem(int index, CTabFolder folder, Control control) {
		
		CTabItem item = new CTabItem(folder, SWT.NONE, index);
		item.setControl(control);
		return item;
		
	}
	
	@Override
	public void createControls(Composite parent) {
		control = new CTabFolder(parent, SWT.BOTTOM | SWT.FLAT);
		setProperties();
		createChildComposites();
		updateFolder();
	}
	
	protected void childrenChanged() {
	    // FIXME: this is probably not what is intended, just modified it like this to get rid of the NPE it was producing.
	    if (control != null && !control.isDisposed())
	        updateFolder();
	}

	protected void updateFolder() {
		
		assert(childNames != null);
		
	    HashSet<Control> existing = new HashSet<Control>();

	    for(CTabItem c : control.getItems()) {
	        existing.add(c.getControl());
	    }

	    int index = existing.size();
	    boolean hasSomeSelectionProviders = false;

	    for(ISWTViewNode node : getChildComposites()) {

	        Control c = node.getControl();
	        if(c != null && !existing.contains(c)) {

	            CTabItem item = createItem(index, control, c);
	            item.setText(childNames.get(index++));

	            for(Control c2 : getControls(item)) {
	                if(c2 instanceof GraphExplorerComposite) {
	                    GraphExplorerComposite gec = (GraphExplorerComposite)c2;
	                    ISelectionProvider sp = (ISelectionProvider)gec.getAdapter(ISelectionProvider.class);
	                    sp.addSelectionChangedListener(selectionListener);
	                    hasSomeSelectionProviders = true;
	                }
	            }

	        }
	    }

	    if(hasSomeSelectionProviders) {
	        // We use our combined selection provider
	        getSite().setSelectionProvider(selectionProvider);
	    }

	    control.setSelection(0);
	    control.update();
	}

    Set<Control> getControls(CTabItem item) {
		HashSet<Control> result = new HashSet<Control>();
		forControl(item.getControl(), result);
		return result;
	}
	
	void forControl(Control control, HashSet<Control> controls) {
		controls.add(control);
		if(control instanceof Composite) {
			Composite composite = (Composite)control;
			for(Control child : composite.getChildren()) forControl(child, controls);
		}
	}
	
	public void synchronizeChildNames(List<String> childNames) {
		
	}
	
	final public void synchronizeLayout(LayoutBean layout) {
	}
	
}
