package org.simantics.views.swt.client.impl;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.simantics.views.ViewUtils;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTStyledText extends SingleSWTViewNode<StyledText> {
	
	private static final long serialVersionUID = 7932335224632082902L;
	
	@Override
	public void createControls(Composite parent) {
		
		control = new StyledText(parent, style);
		control.setEnabled(false);
		setProperties();
		
		control.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String selectionText = control.getSelectionText();
				ViewUtils.setWorkbenchSelection(new StructuredSelection(selectionText));
			}
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
		});
		
	}
	
	@Override
	public void synchronizeText(String text) {
		if(text != null) {
			// Try to keep the vertical scroll position of the text widget
			int caretOffset = control.getCaretOffset();
			int charCount = control.getCharCount();
			int topIndex = control.getTopIndex();
			int diff = text.length() - charCount;
			control.setText(text);
			caretOffset = Math.max(0, Math.min(caretOffset + diff, text.length()));
			control.setTopIndex(topIndex);
			control.setCaretOffset(caretOffset);
			control.setEnabled(true);
		} else {
			control.setText("");
			control.setEnabled(false);
		}
	}
	
	public String readText() {
		return control.getText();
	}
	
	public Point readSelection() {
		return control.getSelection();
	}

}
