/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 7.6.2006
 */
package org.simantics.ui.workbench.dialogs;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;

/**
 * ResourceListDialog
 * @author Toni Kalajainen
 */
public class ResourceListDialog extends ElementListSelectionDialog {
    
    public static final String DEFAULT_LABEL_SUFFIX = " (? = any character, * = any String)";
    
    public ResourceListDialog(Shell parent, ILabelProvider labelProvider) {
        super(parent, labelProvider);
    }

    public ResourceListDialog(Shell parent, String title, String label, ILabelProvider labelProvider) {
        this(parent, labelProvider);
        this.setTitle(title);
        this.setMessage(label);
    }

    public ResourceListDialog(Shell parent, String title, ILabelProvider labelProvider) {
        this(parent, labelProvider);
        this.setTitle(title);
        this.setMessage(title+DEFAULT_LABEL_SUFFIX);
    }
    
    @Override
    protected Control createDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }
    
    public Resource[] getResultResources()
    {
        Object res[] = getResult();
        Resource result[] = new Resource[res.length];
        for (int i=0; i<res.length; i++)
            result[i] = (Resource) res[i];
        return result;
    }

    public Resource getSingleResultResource()
    {
        return (Resource) getSingleResult();
    }
    
    public Object getSingleResult()
    {
        Object res[] = getResult();
        if (res==null) return null;
        if (res.length!=1) return null;
        return res[0];
    }
    
}
