/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.eclipse.ui.IEditorInput;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * An IProject service for naming editors while working on a project.
 * 
 * @author Tuukka Lehtonen
 */
public interface IEditorNamingService2 extends IEditorNamingService {

    /**
     * Get the tool tip text that should be shown on an editor with the specified
     * id and the specified input.
     * 
     * @param graph a graph for reading information for constructing a name
     * @param editorId the ID of the editor to be named
     * @param input the input of the editor to be named
     * @return the service-preferred tool tip text for the editor
     * @throws DatabaseException on any errors that occur while reading the
     *         graph
     */
    String getToolTipText(ReadGraph graph, String editorId, IEditorInput input) throws DatabaseException;

}
