/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.ui.IMemento;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.SessionReference;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.ui.workbench.StringMemento;

/**
 * Transferable that contains a set of resource path references.
 *
 * @author Toni Kalajainen
 */
public class ResourceTransferData extends ArrayList<ResourceArray> {

    private static final long serialVersionUID = -6980850210973439012L;
    private String purpose;

    public ResourceTransferData() {
        super();
    }

    public ResourceTransferData(Collection<? extends ResourceArray> c) {
        super(c);        // TODO Auto-generated constructor stub
    }

    public ResourceTransferData(ResourceArray...arrays) {
        super();
        addAll(arrays);
    }

    public ResourceTransferData(Session s, Collection<? extends ResourceArray> c) {
        super(c);        // TODO Auto-generated constructor stub
    }

    public ResourceTransferData(Session s, ResourceArray...arrays) {
        super();
        addAll(arrays);
    }

    public ResourceTransferData(SessionReference s, Collection<? extends ResourceArray> c) {
        super(c);        // TODO Auto-generated constructor stub
    }

    public ResourceTransferData(SessionReference s, ResourceArray...arrays) {
        super();
        addAll(arrays);
    }

    public ResourceTransferData(SessionReference s) {
        super();
    }

    public ResourceTransferData(Session s) {
        super();
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void addAll(ResourceArray[] array)
    {
        for (ResourceArray a : array)
            add(a);
    }

    public ResourceArray[] toResourceArrayArray()
    {
        return toArray(ResourceArray.NONE);
    }

    //////////// SERIALIZATION //////////////

    /** Key to resource array of memento child */
    private static final String RES_KEY = "res";
    /** Key to purpose string of a memento */
    private static final String PURPOSE_KEY = "purpose";

    public void readFromMemento(SerialisationSupport serializer, IMemento memento)
    throws DatabaseException
    {
//        String sessionReference = memento.getString("SessionReference");

        String purpose = memento.getString(PURPOSE_KEY);

        List<ResourceArray> res = new ArrayList<ResourceArray>();
        for (IMemento child : memento.getChildren(RES_KEY))
        {
            ResourceArray array = readResourceArrayFromMemento(serializer, child);
            res.add(array);
        }

        addAll(res);
//        setSessionReference(sessionReference);
        setPurpose(purpose);
    }

    public static ResourceArray readResourceArrayFromMemento(SerialisationSupport serializer, IMemento memento)
    throws DatabaseException
    {
        List<Resource> result = new ArrayList<Resource>();
        int index = 0;
        while (memento.getString(""+index)!=null) {
            String randomAccessId = memento.getString(""+index);
            long id = Long.parseLong(randomAccessId);
            Resource r = serializer.getResource(id);
            result.add(r);
            index++;
        }
        return new ResourceArray( result );
    }

    public void writeToMemento(SerialisationSupport serializer, IMemento memento)
    throws DatabaseException
    {
        int index = 0;
        if (purpose != null)
            writePurpose(memento);
        for (ResourceArray array : this)
        {
            String id = ""+index++;
            StringMemento child = (StringMemento) memento.createChild(RES_KEY, id);
            writeResourceArrayToMemento(serializer, array, child);
        }
    }

    private void writePurpose(IMemento memento) {
        assert purpose != null;
        memento.putString(PURPOSE_KEY, purpose);
    }

    public static void writeResourceArrayToMemento(SerialisationSupport serializer, ResourceArray array, IMemento sm)
    throws DatabaseException
    {
        for (int i=0; i<array.resources.length; i++)
        {
            Resource r = array.resources[i];
            String rai = "" + serializer.getRandomAccessId(r);
            sm.putString(""+i, rai);
        }
    }
}
