/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;

/**
 * @author Tuukka Lehtonen
 */
public class ResourceReferenceTransfer extends ByteArrayTransfer {

    private static final String                    TYPENAME = "ResourceReferenceTransfer";

    private static final int                       TYPEID   = registerType(TYPENAME);

    private static final ResourceReferenceTransfer INSTANCE = createInstance((String) null);

    private String                                 purpose;
    private Session                                session;

    public static ResourceReferenceTransfer getInstance() {
        return INSTANCE;
    }

    public static ResourceReferenceTransfer createInstance(Session session) {
        ResourceReferenceTransfer result = new ResourceReferenceTransfer(null);
        result.session = session;
        return result;
    }

    public static ResourceReferenceTransfer createInstance(String purpose) {
        ResourceReferenceTransfer result = new ResourceReferenceTransfer(purpose);
        return result;
    }

    ResourceReferenceTransfer(String purpose) {
        this.purpose = purpose;
    }

    private Session getSession() {
        // NOTE return SimanticsUI is a big HAXXX
        return session == null ? Simantics.getSession() : session;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!checkResourceReference(object) || !isSupportedType(transferData)) {
            DND.error(DND.ERROR_INVALID_DATA);
        }
        ResourceArray[] resources = null;
        if (object instanceof Resource)
            resources = new ResourceArray[] {new ResourceArray((Resource) object)};
        if (object instanceof Resource[])
            resources = new ResourceArray[] {new ResourceArray((Resource[]) object)};
        if (object instanceof ResourceArray)
            resources = new ResourceArray[] {(ResourceArray) object};
        if (object instanceof ResourceArray[])
            resources = (ResourceArray[]) object;
        if (resources==null)
            DND.error(DND.ERROR_INVALID_DATA);
        //throw new IllegalArgumentException();

        // write data to a byte array and then ask super to convert to
        // pMedium
        Session s = getSession();
        SerialisationSupport support = s.getService(SerialisationSupport.class);
        ResourceTransferData rtd = new ResourceTransferData(s, resources);
        rtd.setPurpose(purpose);

        Object buffer;
        try {
            buffer = ResourceTransferUtils.createStringTransferable(support, rtd);
        } catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        TextTransfer.getInstance().javaToNative(buffer, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        if (isSupportedType(transferData)) {
            String buffer = (String) TextTransfer.getInstance().nativeToJava(transferData);
            if (buffer == null)
                return null;

            Session s = getSession();
            SerialisationSupport support = s.getService(SerialisationSupport.class);
            ResourceTransferData rtd;
            try {
                rtd = ResourceTransferUtils.readStringTransferable(support, buffer);
            } catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            } catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
            // FIXME: the transferred "purpose" data cannot be passed further
            // because this method is currently assumed to return
            // ResourceArray[] instead of ResourceTransferData
            return rtd.toResourceArrayArray();
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[] { TYPENAME };
    }

    protected int[] getTypeIds() {
        return new int[] { TYPEID };
    }

    boolean checkResourceReference(Object object) {
        System.out.println("o = " + object);
        if (object == null) return false;
        if ( !(object instanceof ResourceArray[]) || ((ResourceArray[]) object).length == 0) {
            return false;
        }
//        ResourceReference[] ResourceReferences = (ResourceReference[]) object;
//        for (int i = 0; i < ResourceReferences.length; i++) {
//            // Check each reference if there is something to check
//        }
        return true;
    }

    protected boolean validate(Object object) {
        return checkResourceReference(object);
    }

}
