/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ui.ExceptionUtils;

public class DoubleClickExtension implements IDoubleClickExtension {

    /**
     * A fallback action for replacing {@link #cachedAction} if action
     * instantiation fails.
     */
    private static final IDoubleClickAction NO_ACTION = new IDoubleClickAction() {
        @Override
        public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        }
    };

    private final IConfigurationElement config;

    private final String                name;

    private final double                priority;

    private IDoubleClickAction          cachedAction;

    DoubleClickExtension(IConfigurationElement config, String name, double priority) {
        this.config = config;
        this.name = name;
        this.priority = priority;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public double getPriority() {
        return priority;
    }

    @Override
    public synchronized IDoubleClickAction getAction() {
        if (cachedAction == null) {
            try {
                cachedAction = (IDoubleClickAction) config.createExecutableExtension("class");
            } catch (CoreException e) {
                ExceptionUtils.logError("Failed to instantiate " + config.getName()
                        + " extension with name \"" + config.getAttribute("name") + "\": "
                        + e.getMessage(), e);
                // This prevents informing of an error in the extension.
                cachedAction = NO_ACTION;
            }
        }
        return cachedAction;
    }

    @Override
    public String toString() {
        return "DoubleClickExtension [name=" + name + ", class=" + config.getAttribute("class") + ", priority=" + priority + "]";
    }

}
