/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;

import javax.swing.JRadioButton;

public class RadioButtonNode extends ComponentNode<JRadioButton> implements ActionListener {

    private static final long serialVersionUID = 3161843367263793336L;

    protected String text;
    protected Font font = null;
    protected Color color = null;

    protected transient Set<ActionListener> actionListeners = new HashSet<ActionListener>();
    
    @Override
    public void render(Graphics2D g2d) {
    	if(component != null && component.getText() != null && component.getText().equals(text) == false)
    		component.setText(text);
    	super.render(g2d);
    }

    @SyncField("bounds")
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @SyncField("text")
    public void setText(String text) {
    	this.text = text;
    }
    
    @SyncField("font")
    public void setFont(Font font) {
        this.font = font;
        if (component != null) {
            setComponentFont(font);
        }
    }

    @SyncField("color")
    public void setColor(Color color) {
        this.color = color;
        if (component != null) {
            component.setForeground(color);
        }
    }
    
    public Font getFont() {
    	return font;
    }

    @ServerSide
	@Override
	public void actionPerformed(ActionEvent e) {
		for(ActionListener listener : actionListeners)
			listener.actionPerformed(e);
	}
	
    public void addActionListener(ActionListener l) {
    	actionListeners.add(l);
    }
    
    public void removeActionListener(ActionListener l) {
    	actionListeners.remove(l);
    }

    @Override
    public void init() {
    	component = new JRadioButton();
		component.addActionListener(this);
        super.init();
    }
}
