package org.simantics.scenegraph.swing;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import org.simantics.scenegraph.INode;

public class JTableSG extends JTable implements JComponentSG {

	private static final long serialVersionUID = -8307824148871305452L;
	
	final private INode node;
	
	public JTableSG(TableModel model, INode node) {
		super(model);
		this.node = node;
	}

	@Override
	public boolean contains(int eventX, int eventY) {
		return JComponentUtils.contains(eventX, eventY, this, node);
	}
	
	@Override
	public boolean containsTransformed(Point p) {
		return super.contains(p.x, p.y);
	}
	
	@Override
	public JComponent getComponent() {
		return this;
	}
	
	@Override
	protected void processEvent(AWTEvent e) {
		super.processEvent(JComponentUtils.relocate(e, this, node));
	}
	
	private boolean isDragging = false;
	
	protected void mouseDragFinished() {
		
	}
	
	@Override
    protected JTableHeader createDefaultTableHeader() {
    	
    	class TableHeaderSG extends JTableHeader implements JComponentSG {

    		private static final long serialVersionUID = 209426441282352819L;

    		TableHeaderSG(TableColumnModel model) {
    			super(model);
    		}

    		@Override
    		public boolean contains(int eventX, int eventY) {
    			return JComponentUtils.contains(eventX, eventY, this, node);
    		}
    		
    		@Override
    		public boolean containsTransformed(Point p) {
    			return super.contains(p.x, p.y);
    		}
    		
    		@Override
    		public JComponent getComponent() {
    			return this;
    		}
    		
    		@Override
    		protected void processEvent(AWTEvent e) {
    			super.processEvent(JComponentUtils.relocate(e, this, node));
    		}
    		
    		@Override
    		protected void processMouseMotionEvent(MouseEvent e) {
                int id = e.getID();
                switch(id) {
                  case MouseEvent.MOUSE_DRAGGED:
                	  isDragging = true;
                      break;
                }
    			super.processMouseMotionEvent(e);
    		}
    		
    		@Override
    		protected void processMouseEvent(MouseEvent e) {
                int id = e.getID();
                switch(id) {
                  case MouseEvent.MOUSE_RELEASED:
                	  if(isDragging) mouseDragFinished();
                	  isDragging = false;
                      break;
                }
    			super.processMouseEvent(e);
    		}
    		
    	}
    	
        return new TableHeaderSG(columnModel);
        
    }
	
}
