package org.simantics.scenegraph.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;

import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;

import org.simantics.scenegraph.INode;

public class JScrollPaneSG extends JScrollPane implements JComponentSG {

	private static final long serialVersionUID = 1941565557888406721L;

	final private INode node;
	
	public JScrollPaneSG(Component view, INode node) {
		
		this.node = node;
        setLayout(new ScrollPaneLayout.UIResource());
        setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_AS_NEEDED);
        setHorizontalScrollBarPolicy(HORIZONTAL_SCROLLBAR_AS_NEEDED);
        setViewport(createViewport());
        setVerticalScrollBar(createVerticalScrollBar());
        setHorizontalScrollBar(createHorizontalScrollBar());
        if (view != null) {
            setViewportView(view);
        }
        
        setOpaque(true);

        updateUI();

        if (!this.getComponentOrientation().isLeftToRight()) {
            viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
		
	}

	class ScrollBarSG extends ScrollBar implements JComponentSG {

		private static final long serialVersionUID = 209426441282352819L;

		ScrollBarSG(int flags) {
			super(flags);
		}

		@Override
		public boolean contains(int eventX, int eventY) {
			return JComponentUtils.contains(eventX, eventY, this, node);
		}
		
		@Override
		public boolean containsTransformed(Point p) {
			return super.contains(p.x, p.y);
		}
		
		@Override
		public JComponent getComponent() {
			return this;
		}
		
		@Override
		protected void processEvent(AWTEvent e) {
			super.processEvent(JComponentUtils.relocate(e, this, node));
		}
		
	}
	
	@Override
	public JScrollBar createVerticalScrollBar() {
		return new ScrollBarSG(JScrollBar.VERTICAL);
	}

	@Override
	public JScrollBar createHorizontalScrollBar() {
		return new ScrollBarSG(JScrollBar.HORIZONTAL);
	}

	@Override
	public boolean contains(int eventX, int eventY) {
		return JComponentUtils.contains(eventX, eventY, this, node);
	}
	
	@Override
	public boolean containsTransformed(Point p) {
		return super.contains(p.x, p.y);
	}
	
	@Override
	public JComponent getComponent() {
		return this;
	}
	
	@Override
	protected JViewport createViewport() {
		return new JViewportSG(node);
	}
	
}
