/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.example;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.VolatileImage;

import javax.swing.JComponent;

import org.simantics.scenegraph.g2d.G2DFocusManager;
import org.simantics.scenegraph.g2d.G2DSceneGraph;

public class SGCanvas extends JComponent implements MouseListener, MouseMotionListener, MouseWheelListener, KeyListener, FocusListener {
	/**
	 * 
	 */
	private static final long serialVersionUID = -7835590396125816119L;
	
	private G2DSceneGraph scenegraph = null;
    private VolatileImage buffer = null;
    
	public SGCanvas() {
		setFocusable(true);	
	}
	
	public void initListeners() {
        addKeyListener(this);
        addMouseWheelListener(this);
        addMouseListener(this);
        addMouseMotionListener(this);
        addFocusListener(this);
	}
	
	@Override
    public void paintComponent(Graphics g) {
        if (scenegraph == null) return;        
        Graphics2D	g2d		= (Graphics2D) g;
        Rectangle	b		= getBounds();

        int newWidth = b.width;
        int newHeight = b.height;

        if (buffer == null) {
            buffer = createVolatileImage(newWidth, newHeight);
        } else {
            int w = buffer.getWidth();
            int h = buffer.getHeight();
            if (w != newWidth || h != newHeight) {
                buffer = createVolatileImage(newWidth, newHeight);
            } else {
                int valid = buffer.validate(g2d.getDeviceConfiguration());
                if (valid == VolatileImage.IMAGE_INCOMPATIBLE) {
                    buffer = createVolatileImage(newWidth, newHeight);
                }
            }
        }

        Graphics2D bg = (Graphics2D) buffer.getGraphics();

        bg.setClip((int)b.getMinX(), (int)b.getMinY(), (int)b.getWidth(), (int)b.getHeight());
        scenegraph.render(bg);
        g2d.drawImage(buffer, 0, 0, null);
    }
	
	public void setSceneGraph(G2DSceneGraph scenegraph) {
		this.scenegraph = scenegraph;
		scenegraph.setRootPane(this);
	}
	
	public G2DSceneGraph getSceneGraph() {
		return scenegraph;
	}

	@Override
	public void mouseWheelMoved(MouseWheelEvent event) {
		if(scenegraph != null) {
			scenegraph.getEventDelegator().mouseWheelMoved(event);
			repaint();
		}
	}

	@Override
	public void keyPressed(KeyEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().keyPressed(event);
	}

	@Override
	public void keyReleased(KeyEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().keyReleased(event);
	}

	@Override
	public void keyTyped(KeyEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().keyTyped(event);
	}

	@Override
	public void focusGained(FocusEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().focusGained(event);
	}

	@Override
	public void focusLost(FocusEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().focusLost(event);
	}

	@Override
	public void mouseClicked(MouseEvent event) {
		if(scenegraph != null) {
			scenegraph.getEventDelegator().mouseClicked(event);
			repaint();
		}
	}

	@Override
	public void mouseEntered(MouseEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().mouseEntered(event);
	}

	@Override
	public void mouseExited(MouseEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().mouseExited(event);
	}

	@Override
	public void mousePressed(MouseEvent event) {
		if(scenegraph != null) {
			G2DFocusManager.INSTANCE.clearFocus();
			scenegraph.getEventDelegator().mousePressed(event);
			if(G2DFocusManager.INSTANCE.getFocusOwner() == null) {
				this.requestFocusInWindow();
			}
			repaint();
		}
	}

	@Override
	public void mouseReleased(MouseEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().mouseReleased(event);
	}

	@Override
	public void mouseDragged(MouseEvent event) {
		if(scenegraph != null) {
			scenegraph.getEventDelegator().mouseDragged(event);
			repaint();
		}
	}

	@Override
	public void mouseMoved(MouseEvent event) {
		if(scenegraph != null)
			scenegraph.getEventDelegator().mouseMoved(event);
	}

}
