/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.internal;

import gnu.trove.map.hash.THashMap;

import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardLinkType;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.forward.IForwardMappingSchema;

public class MonotoneForwardMapping<Domain, Range> implements IForwardMapping<Domain, Range> {

    IForwardMappingSchema<Domain, Range> schema;
    THashMap<Domain, Range> map = new THashMap<Domain, Range>();
    
    public MonotoneForwardMapping(IForwardMappingSchema<Domain, Range> schema) {
        this.schema = schema;
    }

    @Override
    public Set<Domain> getDomain() {
        return Collections.unmodifiableSet(map.keySet());
    }

    @Override
    public Range get(Domain domainElement) {
        return map.get(domainElement);
    }

    @Override
    public Range map(ReadGraph graph, Domain domainElement) throws MappingException {
        Range result = get(domainElement);
        if(result == null) {
            IForwardLinkType<Domain, Range> linkType = 
                    schema.linkTypeOfDomainElement(graph, domainElement);
            // Two phase creation makes cyclic references possible
            Range rangeElement = linkType.createRangeElement(graph, domainElement);
            map.put(domainElement, rangeElement);
            linkType.createRange(graph, this, domainElement, rangeElement);
        }
        return result;
    }

}
