/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum oy - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.domain;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Accesses the set of objects attached to the element by the given relation.
 * @author Hannu Niemist
 */
public class LinkedListAccessor implements IDomainAccessor<Resource,Collection<Resource>> {

	static Logger LOGGER = LoggerFactory.getLogger(LinkedListAccessor.class);

	Resource relation;
	Resource listType;
	boolean deleteExtraObjects;

	public LinkedListAccessor(Resource relation, Resource listType, boolean deleteExtraObjects) {
		super();
		this.relation = relation;
		this.listType = listType;
		this.deleteExtraObjects = deleteExtraObjects;
	}

	@Override
	public Collection<Resource> get(ReadGraph g, Resource element) throws MappingException {
		try {
			LOGGER.trace("        LinkdedListAccessor.get");
			return ListUtils.toList(g, g.getPossibleObject(element, relation));
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
	}

	@Override
	public boolean set(WriteGraph g, Resource element, Collection<Resource> value)
			throws MappingException {
		try {
			LOGGER.trace("        LinkdedListAccessor.set");
			return MappingUtils.synchronizeList(g, element, relation, listType, new ArrayList<Resource>(value), deleteExtraObjects);
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}

	}

}
