/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph;

/**
 * Listens modifications in a mapping.
 * @author Hannu Niemist
 */
public interface IMappingListener {
    /**
     * Called when some domain element is modified or created
     * and the mapping was previously up to date.
     */
	void domainModified();
	
	/**
     * Called when some range element is modified or created
     * and the mapping was previously up to date.
     */
	void rangeModified();
}
