/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.utils.ui.validators.URLValidator;

/**
 * Dialog for adding URL links with additional information
 * 
 * Note: AnnotationConfigurator must be disposed manually.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class UrlDetailDialog extends TextInputDialog{

	private String url;
	private String name;
	
	Text urlText;
	Text nameText;
	
	IInputValidator urlValidator;
	IInputValidator nameValidator;
	
	Composite annotationComposite;
	
	AnnotationConfigurator annotationConfigurator;

	//PropertyTable annotationTable;
	

	
	public UrlDetailDialog(Shell parentShell, Resource lib) {
		super(parentShell);
		try {
			annotationConfigurator = new AnnotationConfigurator(DocumentResource.getInstance(Simantics.getSession()).UrlDocument,lib);
		} catch (DatabaseException e) {
			
		}
	}
	
	public String getUrl() {
		return url;
	}
	
	public String getName() {
		return name;
	}
	
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		GridLayout layout = new GridLayout(2,false);
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		composite.setLayout(layout);
		GridDataFactory.fillDefaults().hint(500, 500).applyTo(composite);
		
		Label label = new Label(composite, SWT.NONE);
		label.setText(Messages.UrlDetailDialog_URL);
		urlText = new Text(composite, SWT.SINGLE|SWT.BORDER);
		label = new Label(composite, SWT.NONE);
		label.setText(Messages.UrlDetailDialog_Name);
		nameText = new Text(composite, SWT.SINGLE|SWT.BORDER);
		label = new Label(composite, SWT.NONE);
		label.setText(Messages.UrlDetailDialog_Annotations);
		annotationComposite = new Composite(composite, SWT.BORDER);
		annotationComposite.setLayout(new FillLayout());
//		
		
		GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).grab(true, false).applyTo(urlText);
		GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).grab(true, false).applyTo(nameText);
		GridDataFactory.fillDefaults().align(SWT.FILL, SWT.FILL).grab(true, true).applyTo(annotationComposite);
		
		urlValidator = new URLValidator();
		
		
		urlText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				if (validate(urlText, urlValidator)) {
					url = urlText.getText();
					updateName();
				}
				
			}
		});
		
		nameText.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				if (validate(nameText,nameValidator)) {
					name = nameText.getText();
				}
				
			}
		});
		
		annotationConfigurator.createComposite(annotationComposite);
		
		//annotationHolder = createAnnotationHolder();
		
		
		
		

		
		return composite;
	}
	
	private void updateName() {
		if (url.length() > 0 ) {
			String newName = updateName(url, name);
			if (newName != null) {
				name = newName;
				nameText.setText(name);
			}
		}
	}
	
	public void setUrlValidator(IInputValidator urlValidator) {
		this.urlValidator = urlValidator;
	}
	
	public void setNameValidator(IInputValidator nameValidator) {
		this.nameValidator = nameValidator;
	}
	
	public AnnotationConfigurator getAnnotationConfigurator() {
		return annotationConfigurator;
	}
	

	
}
