/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.xml.sax.ui.wizard.SchemaConversionWizard;

public class ImportProcessPage
extends WizardPage {
    private Composite composite;
    private Button button;
    private Label label;
    private boolean doneImport = false;
    private boolean importing = false;
    private Exception exception;

    public ImportProcessPage() {
        super("XML Schema conversion", "Conversion Summary", null);
        this.setPageComplete(false);
    }

    public boolean isDoneImport() {
        return this.doneImport;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, true));
        Label fileLabel = new Label(this.composite, 0);
        fileLabel.setText("File: ");
        this.label = new Label(this.composite, 0);
        this.label.setText("Import has not been started.");
        GridDataFactory.fillDefaults().align(4, 1024).grab(true, false).applyTo((Control)this.label);
        this.button = new Button(this.composite, 8);
        this.button.setText("Import");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.button);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProcessPage.this.doImport();
            }
        });
        this.setControl((Control)this.composite);
    }

    private void doImport() {
        this.button.setEnabled(false);
        this.label.setText("Import started.");
        this.importing = true;
        try {
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Database import", -1);
                        SchemaConversionWizard wizard = (SchemaConversionWizard)ImportProcessPage.this.getWizard();
                        wizard.doConversion();
                    }
                    catch (Exception err) {
                        ImportProcessPage.this.exception = err;
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException err) {
            this.exception = err;
        }
        catch (InterruptedException err) {
            this.exception = err;
        }
        if (this.exception != null) {
            this.setErrorMessage("Conversion failed: " + this.exception.getMessage());
            ErrorLogger.defaultLogError((String)"Schema conversion failed.", (Throwable)this.exception);
            this.label.setText("Schema conversion failed.");
        } else {
            this.label.setText("Schema conversion done.");
        }
        this.doneImport = true;
        this.importing = false;
        this.setPreviousPage(null);
        this.setPageComplete(true);
        this.getContainer().updateButtons();
    }

    public boolean isImporting() {
        return this.importing;
    }
}

