/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkActorCollection;
import vtk.vtkCamera;
import vtk.vtkJavaDep;
import vtk.vtkLight;
import vtk.vtkPropPicker;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;
import vtk.vtkTIFFWriter;
import vtk.vtkWindowToImageFilter;

public class vtkPanel
extends Canvas
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected vtkRenderWindow rw = new vtkRenderWindow();
    protected vtkRenderer ren = new vtkRenderer();
    protected vtkCamera cam = null;
    protected vtkLight lgt = new vtkLight();
    protected int lastX;
    protected int lastY;
    protected int windowset = 0;
    protected int lightingset = 0;
    protected int LightFollowCamera = 1;
    protected int InteractionMode = 1;
    protected boolean rendering = false;

    static {
        vtkJavaDep.load();
    }

    public void lock() {
        this.Lock();
    }

    public void unlock() {
        this.UnLock();
    }

    public void Delete() {
        if (this.rendering) {
            return;
        }
        this.rendering = true;
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.ren = null;
        this.cam = null;
        this.lgt = null;
        if (!this.rw.GetClassName().equals("vtkXOpenGLRenderWindow")) {
            this.rw = null;
        } else {
            System.out.println("The renderwindow has been kept around to prevent a crash");
        }
    }

    protected native int RenderCreate(vtkRenderWindow var1);

    protected native int Lock();

    protected native int UnLock();

    public vtkPanel() {
        this.rw.AddRenderer(this.ren);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        super.setSize(200, 200);
        this.rw.SetSize(200, 200);
    }

    public vtkPanel(vtkRenderWindow renwin) {
        this.rw = renwin;
        this.rw.AddRenderer(this.ren);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        super.setSize(200, 200);
        this.rw.SetSize(200, 200);
    }

    public void Report() {
        Runnable updateAComponent = new Runnable(){

            @Override
            public void run() {
                vtkPanel.this.Lock();
                System.out.println("direct rendering = " + (vtkPanel.this.rw.IsDirect() == 1));
                System.out.println("opengl supported = " + (vtkPanel.this.rw.SupportsOpenGL() == 1));
                System.out.println("report = " + vtkPanel.this.rw.ReportCapabilities());
                vtkPanel.this.UnLock();
            }
        };
        SwingUtilities.invokeLater(updateAComponent);
    }

    public vtkRenderer GetRenderer() {
        return this.ren;
    }

    public vtkRenderWindow GetRenderWindow() {
        return this.rw;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        if (this.windowset == 1) {
            this.Lock();
            this.rw.SetSize(x, y);
            this.UnLock();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.windowset = 0;
        this.rw.SetForceMakeCurrent();
        this.rendering = false;
    }

    @Override
    public void removeNotify() {
        this.rendering = true;
        super.removeNotify();
    }

    public synchronized void Render() {
        if (!this.rendering) {
            this.rendering = true;
            if (this.ren.VisibleActorCount() == 0) {
                this.rendering = false;
                return;
            }
            if (this.rw != null) {
                if (this.windowset == 0) {
                    this.cam = this.ren.GetActiveCamera();
                    if (this.lightingset == 0) {
                        this.ren.AddLight(this.lgt);
                        this.lgt.SetPosition(this.cam.GetPosition());
                        this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
                        this.lightingset = 1;
                    }
                    this.RenderCreate(this.rw);
                    this.Lock();
                    this.rw.SetSize(this.getWidth(), this.getHeight());
                    this.UnLock();
                    this.windowset = 1;
                    this.setSize(this.getWidth(), this.getHeight());
                }
                this.Lock();
                this.rw.Render();
                this.UnLock();
                this.rendering = false;
            }
        }
    }

    public boolean isWindowSet() {
        return this.windowset == 1;
    }

    @Override
    public void paint(Graphics g) {
        this.Render();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void LightFollowCameraOn() {
        this.LightFollowCamera = 1;
    }

    public void LightFollowCameraOff() {
        this.LightFollowCamera = 0;
    }

    public void InteractionModeRotate() {
        this.InteractionMode = 1;
    }

    public void InteractionModeTranslate() {
        this.InteractionMode = 2;
    }

    public void InteractionModeZoom() {
        this.InteractionMode = 3;
    }

    public void UpdateLight() {
        this.lgt.SetPosition(this.cam.GetPosition());
        this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
    }

    public void resetCameraClippingRange() {
        this.Lock();
        this.ren.ResetCameraClippingRange();
        this.UnLock();
    }

    public void resetCamera() {
        this.Lock();
        this.ren.ResetCamera();
        this.UnLock();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.rw.SetDesiredUpdateRate(5.0);
        this.lastX = e.getX();
        this.lastY = e.getY();
        if (e.getModifiers() == 8 || e.getModifiers() == 17) {
            this.InteractionModeTranslate();
        } else if (e.getModifiers() == 4) {
            this.InteractionModeZoom();
        } else {
            this.InteractionModeRotate();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.rw.SetDesiredUpdateRate(0.01);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.InteractionMode == 1) {
            this.cam.Azimuth(this.lastX - x);
            this.cam.Elevation(y - this.lastY);
            this.cam.OrthogonalizeViewUp();
            this.resetCameraClippingRange();
            if (this.LightFollowCamera == 1) {
                this.lgt.SetPosition(this.cam.GetPosition());
                this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
            }
        }
        if (this.InteractionMode == 2) {
            double[] APoint = new double[3];
            double[] FPoint = this.cam.GetFocalPoint();
            double[] PPoint = this.cam.GetPosition();
            this.ren.SetWorldPoint(FPoint[0], FPoint[1], FPoint[2], 1.0);
            this.ren.WorldToDisplay();
            double focalDepth = this.ren.GetDisplayPoint()[2];
            APoint[0] = (double)this.rw.GetSize()[0] / 2.0 + (double)(x - this.lastX);
            APoint[1] = (double)this.rw.GetSize()[1] / 2.0 - (double)(y - this.lastY);
            APoint[2] = focalDepth;
            this.ren.SetDisplayPoint(APoint);
            this.ren.DisplayToWorld();
            double[] RPoint = this.ren.GetWorldPoint();
            if (RPoint[3] != 0.0) {
                RPoint[0] = RPoint[0] / RPoint[3];
                RPoint[1] = RPoint[1] / RPoint[3];
                RPoint[2] = RPoint[2] / RPoint[3];
            }
            this.cam.SetFocalPoint((FPoint[0] - RPoint[0]) / 2.0 + FPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + FPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + FPoint[2]);
            this.cam.SetPosition((FPoint[0] - RPoint[0]) / 2.0 + PPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + PPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + PPoint[2]);
            this.resetCameraClippingRange();
        }
        if (this.InteractionMode == 3) {
            double zoomFactor = Math.pow(1.02, y - this.lastY);
            if (this.cam.GetParallelProjection() == 1) {
                this.cam.SetParallelScale(this.cam.GetParallelScale() / zoomFactor);
            } else {
                this.cam.Dolly(zoomFactor);
                this.resetCameraClippingRange();
            }
        }
        this.lastX = x;
        this.lastY = y;
        this.Render();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.ren.VisibleActorCount() == 0 || e.getWheelRotation() == 0) {
            return;
        }
        int exponent = -10 * e.getWheelRotation() / Math.abs(e.getWheelRotation());
        double zoomFactor = Math.pow(1.02, exponent);
        if (this.cam.GetParallelProjection() == 1) {
            this.cam.SetParallelScale(this.cam.GetParallelScale() / zoomFactor);
        } else {
            this.cam.Dolly(zoomFactor);
            this.resetCameraClippingRange();
        }
        this.Render();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        vtkActor anActor;
        int i;
        vtkActorCollection ac;
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        char keyChar = e.getKeyChar();
        if ('r' == keyChar) {
            this.resetCamera();
            this.Render();
        }
        if ('u' == keyChar) {
            this.pickActor(this.lastX, this.lastY);
        }
        if ('w' == keyChar) {
            ac = this.ren.GetActors();
            ac.InitTraversal();
            i = 0;
            while (i < ac.GetNumberOfItems()) {
                anActor = ac.GetNextActor();
                anActor.GetProperty().SetRepresentationToWireframe();
                ++i;
            }
            this.Render();
        }
        if ('s' == keyChar) {
            ac = this.ren.GetActors();
            ac.InitTraversal();
            i = 0;
            while (i < ac.GetNumberOfItems()) {
                anActor = ac.GetNextActor();
                anActor.GetProperty().SetRepresentationToSurface();
                ++i;
            }
            this.Render();
        }
    }

    public void HardCopy(String filename, int mag) {
        this.Lock();
        vtkWindowToImageFilter w2if = new vtkWindowToImageFilter();
        w2if.SetInput(this.rw);
        w2if.SetScale(mag);
        w2if.Update();
        vtkTIFFWriter writer = new vtkTIFFWriter();
        writer.SetInputConnection(w2if.GetOutputPort());
        writer.SetFileName(filename);
        writer.Write();
        this.UnLock();
    }

    public void pickActor(int x, int y) {
        vtkPropPicker picker = new vtkPropPicker();
        this.Lock();
        picker.PickProp(x, this.rw.GetSize()[1] - y, this.ren);
        this.UnLock();
        if (picker.GetActor() != null) {
            System.out.println(picker.GetActor().GetClassName());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

