/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkAxes;
import vtk.vtkConeSource;
import vtk.vtkPolyDataMapper;
import vtk.vtkRenderer;
import vtk.vtkTextActor;
import vtk.vtkTubeFilter;

public class AxesActor
extends vtkAssembly {
    private vtkRenderer ren;
    private double axisLength = 0.8;
    private vtkTextActor xactor;
    private vtkTextActor yactor;
    private vtkTextActor zactor;

    public AxesActor(vtkRenderer _ren) {
        this.ren = _ren;
        this.createAxes();
    }

    public void createAxes() {
        vtkAxes axes = new vtkAxes();
        axes.SetOrigin(0.0, 0.0, 0.0);
        axes.SetScaleFactor(this.axisLength);
        this.xactor = new vtkTextActor();
        this.yactor = new vtkTextActor();
        this.zactor = new vtkTextActor();
        this.xactor.SetInput("X");
        this.yactor.SetInput("Y");
        this.zactor.SetInput("Z");
        this.xactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.yactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.zactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.xactor.GetPositionCoordinate().SetValue(this.axisLength, 0.0, 0.0);
        this.yactor.GetPositionCoordinate().SetValue(0.0, this.axisLength, 0.0);
        this.zactor.GetPositionCoordinate().SetValue(0.0, 0.0, this.axisLength);
        this.xactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.xactor.GetTextProperty().ShadowOn();
        this.xactor.GetTextProperty().ItalicOn();
        this.xactor.GetTextProperty().BoldOff();
        this.yactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.yactor.GetTextProperty().ShadowOn();
        this.yactor.GetTextProperty().ItalicOn();
        this.yactor.GetTextProperty().BoldOff();
        this.zactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.zactor.GetTextProperty().ShadowOn();
        this.zactor.GetTextProperty().ItalicOn();
        this.zactor.GetTextProperty().BoldOff();
        this.xactor.SetMaximumLineHeight(0.25);
        this.yactor.SetMaximumLineHeight(0.25);
        this.zactor.SetMaximumLineHeight(0.25);
        vtkTubeFilter tube = new vtkTubeFilter();
        tube.SetInputConnection(axes.GetOutputPort());
        tube.SetRadius(0.05);
        tube.SetNumberOfSides(8);
        vtkPolyDataMapper tubeMapper = new vtkPolyDataMapper();
        tubeMapper.SetInputConnection(tube.GetOutputPort());
        vtkActor tubeActor = new vtkActor();
        tubeActor.SetMapper(tubeMapper);
        tubeActor.PickableOff();
        int coneRes = 12;
        double coneScale = 0.3;
        vtkConeSource xcone = new vtkConeSource();
        xcone.SetResolution(coneRes);
        vtkPolyDataMapper xconeMapper = new vtkPolyDataMapper();
        xconeMapper.SetInputConnection(xcone.GetOutputPort());
        vtkActor xconeActor = new vtkActor();
        xconeActor.SetMapper(xconeMapper);
        xconeActor.GetProperty().SetColor(1.0, 0.0, 0.0);
        xconeActor.SetScale(coneScale, coneScale, coneScale);
        xconeActor.SetPosition(this.axisLength, 0.0, 0.0);
        vtkConeSource ycone = new vtkConeSource();
        ycone.SetResolution(coneRes);
        vtkPolyDataMapper yconeMapper = new vtkPolyDataMapper();
        yconeMapper.SetInputConnection(ycone.GetOutputPort());
        vtkActor yconeActor = new vtkActor();
        yconeActor.SetMapper(yconeMapper);
        yconeActor.GetProperty().SetColor(1.0, 1.0, 0.0);
        yconeActor.RotateZ(90.0);
        yconeActor.SetScale(coneScale, coneScale, coneScale);
        yconeActor.SetPosition(0.0, this.axisLength, 0.0);
        vtkConeSource zcone = new vtkConeSource();
        zcone.SetResolution(coneRes);
        vtkPolyDataMapper zconeMapper = new vtkPolyDataMapper();
        zconeMapper.SetInputConnection(zcone.GetOutputPort());
        vtkActor zconeActor = new vtkActor();
        zconeActor.SetMapper(zconeMapper);
        zconeActor.GetProperty().SetColor(0.0, 1.0, 0.0);
        zconeActor.RotateY(-90.0);
        zconeActor.SetScale(coneScale, coneScale, coneScale);
        zconeActor.SetPosition(0.0, 0.0, this.axisLength);
        this.ren.AddActor2D(this.xactor);
        this.ren.AddActor2D(this.yactor);
        this.ren.AddActor2D(this.zactor);
        this.AddPart(tubeActor);
        this.AddPart(xconeActor);
        this.AddPart(yconeActor);
        this.AddPart(zconeActor);
        this.ren.AddActor(this);
    }

    public void setAxesVisibility(boolean ison) {
        this.SetVisibility(ison ? 1 : 0);
        this.xactor.SetVisibility(ison ? 1 : 0);
        this.yactor.SetVisibility(ison ? 1 : 0);
        this.zactor.SetVisibility(ison ? 1 : 0);
    }
}

