/*
 * Decompiled with CFR 0.152.
 */
package vtk.rendering;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.internal.DPIUtil;
import vtk.rendering.vtkComponent;
import vtk.rendering.vtkInteractorForwarder;
import vtk.vtkAxesActor;
import vtk.vtkCamera;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorObserver;
import vtk.vtkInteractorStyle;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkOrientationMarkerWidget;
import vtk.vtkProp;
import vtk.vtkRenderWindow;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;

public abstract class vtkAbstractComponent<T>
implements vtkComponent<T> {
    protected vtkRenderWindow renderWindow;
    protected vtkRenderer renderer;
    protected vtkCamera camera;
    protected vtkGenericRenderWindowInteractor windowInteractor;
    protected vtkInteractorForwarder eventForwarder;
    protected ReentrantLock lock;
    protected boolean inRenderCall = false;

    public vtkAbstractComponent() {
        this(new vtkRenderWindow());
    }

    public vtkAbstractComponent(vtkRenderWindow renderWindowToUse) {
        this.renderWindow = renderWindowToUse;
        this.renderer = new vtkRenderer();
        this.windowInteractor = new vtkGenericRenderWindowInteractor();
        this.lock = new ReentrantLock();
        this.windowInteractor.SetRenderWindow(this.renderWindow);
        this.windowInteractor.TimerEventResetsTimerOff();
        this.windowInteractor.SetSize(200, 200);
        this.windowInteractor.ConfigureEvent();
        vtkInteractorStyleTrackballCamera style = new vtkInteractorStyleTrackballCamera();
        this.windowInteractor.SetInteractorStyle((vtkInteractorObserver)style);
        this.eventForwarder = new vtkInteractorForwarder(this);
        this.windowInteractor.AddObserver("CreateTimerEvent", (Object)this.eventForwarder, "StartTimer");
        this.windowInteractor.AddObserver("DestroyTimerEvent", (Object)this.eventForwarder, "DestroyTimer");
        this.renderWindow.AddRenderer(this.renderer);
        this.camera = this.renderer.GetActiveCamera();
    }

    @Override
    public ReentrantLock getVTKLock() {
        return this.lock;
    }

    @Override
    public void resetCamera() {
        if (this.renderer == null) {
            return;
        }
        try {
            try {
                this.lock.lockInterruptibly();
                this.renderer.ResetCamera();
            }
            catch (InterruptedException interruptedException) {
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetCameraClippingRange() {
        if (this.renderWindow == null) {
            return;
        }
        try {
            try {
                this.lock.lockInterruptibly();
                this.renderer.ResetCameraClippingRange();
            }
            catch (InterruptedException interruptedException) {
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public vtkCamera getActiveCamera() {
        return this.camera;
    }

    @Override
    public vtkRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public vtkRenderWindow getRenderWindow() {
        return this.renderWindow;
    }

    @Override
    public vtkGenericRenderWindowInteractor getRenderWindowInteractor() {
        return this.windowInteractor;
    }

    @Override
    public void setInteractorStyle(vtkInteractorStyle style) {
        if (this.windowInteractor != null) {
            this.lock.lock();
            this.windowInteractor.SetInteractorStyle((vtkInteractorObserver)style);
            this.lock.unlock();
        }
    }

    @Override
    public void setSize(int w, int h) {
        if (this.renderWindow == null || this.windowInteractor == null) {
            return;
        }
        w = DPIUtil.autoScaleUp((int)w);
        h = DPIUtil.autoScaleUp((int)h);
        try {
            try {
                this.lock.lockInterruptibly();
                this.renderWindow.SetSize(w, h);
                this.windowInteractor.SetSize(w, h);
            }
            catch (InterruptedException interruptedException) {
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void Delete() {
        this.lock.lock();
        this.renderer.DrawOff();
        this.renderer.Delete();
        this.renderer = null;
        this.camera.Delete();
        this.camera = null;
        this.windowInteractor.Delete();
        this.windowInteractor = null;
        this.lock.unlock();
    }

    @Override
    public vtkInteractorForwarder getInteractorForwarder() {
        return this.eventForwarder;
    }

    @Override
    public abstract T getComponent();

    public static void attachOrientationAxes(vtkComponent<?> component) {
        vtkAxesActor axes = new vtkAxesActor();
        vtkOrientationMarkerWidget axesWidget = new vtkOrientationMarkerWidget();
        axesWidget.SetOutlineColor(0.93, 0.57, 0.13);
        axesWidget.SetOrientationMarker((vtkProp)axes);
        axesWidget.SetInteractor((vtkRenderWindowInteractor)component.getRenderWindowInteractor());
        axesWidget.SetDefaultRenderer(component.getRenderer());
        axesWidget.SetViewport(0.0, 0.0, 0.2, 0.2);
        axesWidget.EnabledOn();
        axesWidget.InteractiveOff();
    }
}

