/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.nio.charset.Charset;
import java.util.Random;

public class StringTest {
	
	static final Charset UTF8 = Charset.forName("utf-8");
	static final Random r = new Random(); 
	
	static public String getRandomString()
	{
		int len = r.nextInt(600);
		StringBuilder sb = new StringBuilder(len);
		for (int i=0; i<len; i++)
		{
			char c = (char) r.nextInt();
			sb.append(c);
		}		
		return sb.toString();
	}

	static public String getStringWithC(char c )
	{
		int len = 3;
		StringBuilder sb = new StringBuilder(len);
		for (int i=0; i<len; i++)
		{
			sb.append(c);
		}		
		return sb.toString();
	}
	
	
	public static int getStringUTF8EncodedByteLength1(String string)
	{
		return string.getBytes(UTF8).length;		
	}

	public static int getStringUTF8EncodedByteLength2(String string)
	{
		int result = 0;
		int length = string.length();
		for (int i=0; i<length; i++)
		{
			char c = string.charAt(i);
			if (c>=0 && c<=0x7f) {
				result += 1;
			} else if (c>=0x80 && c<=0x07ff) {
				result += 2;
			} else if (c>=0xD800 && c<=0xDFFF) {
				result += 1;
			} else if (c>=0x800 && c<=0xffff) {
				result += 3;
			} else if (c>=0x10000 && c<=0x10ffff) {
				result += 4;
			} else if (c>=0x110000 && c<=0x1FFFFF) {
				result += 4;
			} else {
				// NOT IN RFC 3629
				// Lets guess 5 bytes anyhow
				result += 4;
			}
		}
		return result;		
	}
	
	
	public static void main(String[] args) {
		char c = (char) 0x66778899;
		int j = (int) c;
		System.out.println(j );
		
		for (int i=1000000; i<0x7fffffff; i++)
		{
			String str = getStringWithC((char)i);
			int len1 = getStringUTF8EncodedByteLength1(str);
			int len2 = getStringUTF8EncodedByteLength2(str);
			if (len1!=len2) {
				System.out.printf("i=%d, Correct=%d, My=%d, Chars=%d, %s\n", i, len1, len2, str.length(), str);
				throw new RuntimeException("length mismatch");
			}
			if ((i & 0xFFFF) == 0) 
				System.out.printf("i=%d, Correct=%d, My=%d, Chars=%d, %s\n", i, len1, len2, str.length(), str);
				
		}
	}
	
}

