/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz.java;

public class FastLZImpl {
    private static final int MAX_LEN = 264;
    private static final int MAX_COPY = 32;
    private static final int MAX_DISTANCE = 8192;
    private static final int MAX_DISTANCE2 = 8191;
    private static final int MAX_FARDISTANCE = 73725;
    private static final boolean FASTLZ_SAFE = false;
    public static final int FASTLZ_VERSION = 256;
    public static final int FASTLZ_VERSION_MAJOR = 0;
    public static final int FASTLZ_VERSION_MINOR = 1;
    public static final int FASTLZ_VERSION_REVISION = 0;
    public static final String FASTLZ_VERSION_STRING = "0.1.0";
    private static final int HASH_LOG = 13;
    private static final int HASH_SIZE = 8192;
    private static final int HASH_MASK = 8191;

    private static final int FASTLZ_READU16(byte[] array, int offset) {
        int b0 = array[offset] & 0xFF;
        int b1 = array[offset + 1] & 0xFF;
        return b0 | b1 << 8;
    }

    private static final int HASH_FUNCTION(byte[] array, int offset) {
        int b0 = array[offset] & 0xFF;
        int b1 = array[offset + 1] & 0xFF;
        int b2 = array[offset + 2] & 0xFF;
        int v = b0 | b1 << 8;
        int v2 = b1 | b2 << 8;
        v ^= v2 ^ v >>> 3;
        return v &= 0x1FFF;
    }

    public static int fastlz_compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) {
        if (length < 65536) {
            return FastLZImpl.fastlz1_compress(input, inputOffset, length, output, outputOffset);
        }
        return FastLZImpl.fastlz2_compress(input, inputOffset, length, output, outputOffset);
    }

    public static int fastlz_decompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset, int maxout) {
        int level = ((input[0] & 0xFF) >>> 5) + 1;
        if (level == 1) {
            return FastLZImpl.fastlz1_decompress(input, inputOffset, length, output, outputOffset, maxout);
        }
        if (level == 2) {
            return FastLZImpl.fastlz2_decompress(input, inputOffset, length, output, outputOffset, maxout);
        }
        return 0;
    }

    public static int fastlz_compress_level(int level, byte[] input, int inputOffset, int length, byte[] output, int outputOffset) {
        if (level == 1) {
            return FastLZImpl.fastlz1_compress(input, inputOffset, length, output, outputOffset);
        }
        if (level == 2) {
            return FastLZImpl.fastlz2_compress(input, inputOffset, length, output, outputOffset);
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static int fastlz1_compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) {
        ip = inputOffset;
        ip_bound = inputOffset + length - 2;
        ip_limit = inputOffset + length - 12;
        op = outputOffset;
        htab = new int[8192];
        if (length < 4) {
            if (length != 0) {
                output[op++] = (byte)(length - 1);
                ++ip_bound;
                while (ip <= ip_bound) {
                    output[op++] = input[ip++];
                }
                return length + 1;
            }
            return 0;
        }
        hslot = 0;
        while (hslot < 8192) {
            htab[hslot] = ip;
            ++hslot;
        }
        copy = 2;
        output[op++] = 31;
        output[op++] = input[ip++];
        output[op++] = input[ip++];
        while (ip < ip_limit) {
            block18: {
                block19: {
                    len = 3;
                    anchor = ip;
                    hslot = hval = FastLZImpl.HASH_FUNCTION(input, ip);
                    ref = htab[hval];
                    distance = anchor - ref;
                    htab[hslot] = anchor;
                    if (distance == 0 || distance >= 8192 || input[ref++] != input[ip++] || input[ref++] != input[ip++] || input[ref++] != input[ip++]) {
                        output[op++] = input[anchor++];
                        ip = anchor;
                        if (++copy != 32) continue;
                        copy = 0;
                        output[op++] = 31;
                        continue;
                    }
                    ip = anchor + len;
                    if (--distance != 0) break block19;
                    x = input[ip - 1];
                    while (ip < ip_bound) {
                        if (input[ref++] == x) {
                            ++ip;
                            continue;
                        }
                        break block18;
                    }
                    break block18;
                }
                if (input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++]) ** GOTO lbl-1000
                break block18;
                while (input[ref++] == input[ip++]) lbl-1000:
                // 2 sources

                {
                    if (ip < ip_bound) continue;
                }
            }
            if (copy != 0) {
                output[op - copy - 1] = (byte)(copy - 1);
            } else {
                --op;
            }
            copy = 0;
            len = (ip -= 3) - anchor;
            if (len > 262) {
                while (len > 262) {
                    output[op++] = (byte)(224 + (distance >>> 8));
                    output[op++] = -3;
                    output[op++] = (byte)(distance & 255);
                    len -= 262;
                }
            }
            if (len < 7) {
                output[op++] = (byte)((len << 5) + (distance >>> 8));
                output[op++] = (byte)(distance & 255);
            } else {
                output[op++] = (byte)(224 + (distance >>> 8));
                output[op++] = (byte)(len - 7);
                output[op++] = (byte)(distance & 255);
            }
            hval = FastLZImpl.HASH_FUNCTION(input, ip);
            htab[hval] = ip++;
            hval = FastLZImpl.HASH_FUNCTION(input, ip);
            htab[hval] = ip++;
            output[op++] = 31;
        }
        ++ip_bound;
        while (ip <= ip_bound) {
            output[op++] = input[ip++];
            if (++copy != 32) continue;
            copy = 0;
            output[op++] = 31;
        }
        if (copy != 0) {
            output[op - copy - 1] = (byte)(copy - 1);
        } else {
            --op;
        }
        return op - outputOffset;
    }

    /*
     * Unable to fully structure code
     */
    private static int fastlz2_compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) {
        ip = inputOffset;
        ip_bound = ip + length - 2;
        ip_limit = ip + length - 12;
        op = outputOffset;
        htab = new int[8192];
        if (length < 4) {
            if (length != 0) {
                output[op++] = (byte)(length - 1);
                ++ip_bound;
                while (ip <= ip_bound) {
                    output[op++] = input[ip++];
                }
                return length + 1;
            }
            return 0;
        }
        hslot = 0;
        while (hslot < 8192) {
            htab[hslot] = ip;
            ++hslot;
        }
        copy = 2;
        output[op++] = 31;
        output[op++] = input[ip++];
        output[op++] = input[ip++];
        while (ip < ip_limit) {
            block38: {
                block41: {
                    block39: {
                        block37: {
                            block40: {
                                len = 3;
                                anchor = ip;
                                if (input[ip] != input[ip - 1] || FastLZImpl.FASTLZ_READU16(input, ip - 1) != FastLZImpl.FASTLZ_READU16(input, ip + 1)) break block39;
                                distance = 1;
                                ip += 3;
                                ref = anchor - 1 + 3;
                                ip = anchor + len;
                                if (--distance != 0) break block40;
                                x = input[ip - 1];
                                while (ip < ip_bound) {
                                    if (input[ref++] == x) {
                                        ++ip;
                                        continue;
                                    }
                                    break block37;
                                }
                                break block37;
                            }
                            if (input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++]) ** GOTO lbl-1000
                            break block37;
                            while (input[ref++] == input[ip++]) lbl-1000:
                            // 2 sources

                            {
                                if (ip < ip_bound) continue;
                            }
                        }
                        if (copy != 0) {
                            output[op - copy - 1] = (byte)(copy - 1);
                        } else {
                            --op;
                        }
                        copy = 0;
                        len = (ip -= 3) - anchor;
                        if (distance < 8191) {
                            if (len < 7) {
                                output[op++] = (byte)((len << 5) + (distance >>> 8));
                                output[op++] = (byte)(distance & 255);
                            } else {
                                output[op++] = (byte)(224 + (distance >>> 8));
                                len -= 7;
                                while (len >= 255) {
                                    output[op++] = -1;
                                    len -= 255;
                                }
                                output[op++] = (byte)len;
                                output[op++] = (byte)(distance & 255);
                            }
                        } else if (len < 7) {
                            output[op++] = (byte)((len << 5) + 31);
                            output[op++] = -1;
                            output[op++] = (byte)((distance -= 8191) >>> 8);
                            output[op++] = (byte)(distance & 255);
                        } else {
                            distance -= 8191;
                            output[op++] = -1;
                            len -= 7;
                            while (len >= 255) {
                                output[op++] = -1;
                                len -= 255;
                            }
                            output[op++] = (byte)len;
                            output[op++] = -1;
                            output[op++] = (byte)(distance >>> 8);
                            output[op++] = (byte)(distance & 255);
                        }
                        hval = FastLZImpl.HASH_FUNCTION(input, ip);
                        htab[hval] = ip++;
                        hval = FastLZImpl.HASH_FUNCTION(input, ip);
                        htab[hval] = ip++;
                        output[op++] = 31;
                        continue;
                    }
                    hslot = hval = FastLZImpl.HASH_FUNCTION(input, ip);
                    ref = htab[hval];
                    distance = anchor - ref;
                    htab[hslot] = anchor;
                    if (distance == 0 || distance >= 73725 || input[ref++] != input[ip++] || input[ref++] != input[ip++] || input[ref++] != input[ip++]) {
                        output[op++] = input[anchor++];
                        ip = anchor;
                        if (++copy != 32) continue;
                        copy = 0;
                        output[op++] = 31;
                        continue;
                    }
                    if (distance >= 8191) {
                        if (input[ip++] != input[ref++] || input[ip++] != input[ref++]) {
                            output[op++] = input[anchor++];
                            ip = anchor;
                            if (++copy != 32) continue;
                            copy = 0;
                            output[op++] = 31;
                            continue;
                        }
                        len += 2;
                    }
                    ip = anchor + len;
                    if (--distance != 0) break block41;
                    x = input[ip - 1];
                    while (ip < ip_bound) {
                        if (input[ref++] == x) {
                            ++ip;
                            continue;
                        }
                        break block38;
                    }
                    break block38;
                }
                if (input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++] && input[ref++] == input[ip++]) ** GOTO lbl-1000
                break block38;
                while (input[ref++] == input[ip++]) lbl-1000:
                // 2 sources

                {
                    if (ip < ip_bound) continue;
                }
            }
            if (copy != 0) {
                output[op - copy - 1] = (byte)(copy - 1);
            } else {
                --op;
            }
            copy = 0;
            len = (ip -= 3) - anchor;
            if (distance < 8191) {
                if (len < 7) {
                    output[op++] = (byte)((len << 5) + (distance >>> 8));
                    output[op++] = (byte)(distance & 255);
                } else {
                    output[op++] = (byte)(224 + (distance >>> 8));
                    len -= 7;
                    while (len >= 255) {
                        output[op++] = -1;
                        len -= 255;
                    }
                    output[op++] = (byte)len;
                    output[op++] = (byte)(distance & 255);
                }
            } else if (len < 7) {
                output[op++] = (byte)((len << 5) + 31);
                output[op++] = -1;
                output[op++] = (byte)((distance -= 8191) >>> 8);
                output[op++] = (byte)(distance & 255);
            } else {
                distance -= 8191;
                output[op++] = -1;
                len -= 7;
                while (len >= 255) {
                    output[op++] = -1;
                    len -= 255;
                }
                output[op++] = (byte)len;
                output[op++] = -1;
                output[op++] = (byte)(distance >>> 8);
                output[op++] = (byte)(distance & 255);
            }
            hval = FastLZImpl.HASH_FUNCTION(input, ip);
            htab[hval] = ip++;
            hval = FastLZImpl.HASH_FUNCTION(input, ip);
            htab[hval] = ip++;
            output[op++] = 31;
        }
        ++ip_bound;
        while (ip <= ip_bound) {
            output[op++] = input[ip++];
            if (++copy != 32) continue;
            copy = 0;
            output[op++] = 31;
        }
        if (copy != 0) {
            output[op - copy - 1] = (byte)(copy - 1);
        } else {
            --op;
        }
        v0 = outputOffset;
        output[v0] = (byte)(output[v0] | 32);
        return op - outputOffset;
    }

    private static int fastlz1_decompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset, int maxout) {
        int ip = inputOffset;
        int ip_limit = ip + length;
        int op = outputOffset;
        int op_limit = op + maxout;
        int ctrl = input[ip++] & 0x1F;
        boolean loop = true;
        do {
            int ref = op;
            int len = ctrl >>> 5;
            int ofs = (ctrl & 0x1F) << 8;
            if (ctrl >= 32) {
                ref -= ofs;
                if (--len == 6) {
                    len += input[ip++] & 0xFF;
                }
                ref -= input[ip++] & 0xFF;
                if (ip < ip_limit) {
                    ctrl = input[ip++] & 0xFF;
                } else {
                    loop = false;
                }
                if (ref == op) {
                    byte b = output[ref - 1];
                    output[op++] = b;
                    output[op++] = b;
                    output[op++] = b;
                    while (len > 0) {
                        output[op++] = b;
                        --len;
                    }
                } else {
                    int n = op++;
                    int n2 = --ref;
                    output[n] = output[n2];
                    int n3 = op++;
                    int n4 = ++ref;
                    output[n3] = output[n4];
                    int n5 = op++;
                    int n6 = ++ref;
                    ++ref;
                    output[n5] = output[n6];
                    while (len > 0) {
                        output[op++] = output[ref++];
                        --len;
                    }
                }
            } else {
                ++ctrl;
                output[op++] = input[ip++];
                --ctrl;
                while (ctrl > 0) {
                    output[op++] = input[ip++];
                    --ctrl;
                }
                boolean bl = loop = ip < ip_limit;
                if (!loop) continue;
                ctrl = input[ip++] & 0xFF;
            }
        } while (loop);
        return op - outputOffset;
    }

    private static int fastlz2_decompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset, int maxout) {
        int ip = inputOffset;
        int ip_limit = ip + length;
        int op = outputOffset;
        int op_limit = op + maxout;
        int ctrl = input[ip++] & 0x1F;
        boolean loop = true;
        do {
            int ref = op;
            int len = ctrl >>> 5;
            int ofs = (ctrl & 0x1F) << 8;
            if (ctrl >= 32) {
                int code;
                ref -= ofs;
                if (--len == 6) {
                    do {
                        code = input[ip++] & 0xFF;
                        len += code;
                    } while (code == 255);
                }
                code = input[ip++] & 0xFF;
                ref -= code;
                if (code == 255 && ofs == 7936) {
                    ofs = (input[ip++] & 0xFF) << 8;
                    ref = op - (ofs += input[ip++] & 0xFF) - 8191;
                }
                if (ip < ip_limit) {
                    ctrl = input[ip++] & 0xFF;
                } else {
                    loop = false;
                }
                if (ref == op) {
                    byte b = output[ref - 1];
                    output[op++] = b;
                    output[op++] = b;
                    output[op++] = b;
                    while (len > 0) {
                        output[op++] = b;
                        --len;
                    }
                } else {
                    int n = op++;
                    int n2 = --ref;
                    output[n] = output[n2];
                    int n3 = op++;
                    int n4 = ++ref;
                    output[n3] = output[n4];
                    int n5 = op++;
                    int n6 = ++ref;
                    ++ref;
                    output[n5] = output[n6];
                    while (len > 0) {
                        output[op++] = output[ref++];
                        --len;
                    }
                }
            } else {
                ++ctrl;
                output[op++] = input[ip++];
                --ctrl;
                while (ctrl > 0) {
                    output[op++] = input[ip++];
                    --ctrl;
                }
                boolean bl = loop = ip < ip_limit;
                if (!loop) continue;
                ctrl = input[ip++] & 0xFF;
            }
        } while (loop);
        return op - outputOffset;
    }
}

