/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.issues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.scl.osgi.internal.Activator;
import org.simantics.scl.osgi.issues.SCLIssueProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCLIssueFactoryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLIssueFactoryProvider.class);

    public static List<SCLIssueProviderFactory> getSCLIssueProviderFactories() {
        ServiceReference[] serviceReferences = new ServiceReference[]{};
        try {
            serviceReferences = Activator.getContext().getAllServiceReferences(SCLIssueProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Could not get service references for " + SCLIssueProviderFactory.class.getName(), (Throwable)e);
        }
        if (serviceReferences == null || serviceReferences.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SCLIssueProviderFactory> services = new ArrayList<SCLIssueProviderFactory>(serviceReferences.length);
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference reference = serviceReferenceArray[n2];
            SCLIssueProviderFactory service = (SCLIssueProviderFactory)Activator.getContext().getService(reference);
            services.add(service);
            ++n2;
        }
        return services;
    }
}

