/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source.repository;

import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ClassModuleSource;
import org.simantics.scl.compiler.source.FileModuleSource;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleBrowsingUtil;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

public class FileModuleSourceRepository
implements ModuleSourceRepository {
    private final File path;
    private final ClassLoader classLoader;
    private final THashSet<String> modules = new THashSet();

    public FileModuleSourceRepository(File path, ClassLoader classLoader) throws IOException {
        this.path = path;
        this.classLoader = classLoader;
        ModuleBrowsingUtil.collectModuleSourcesAt(this.modules, path);
    }

    @Override
    public ModuleSource getModuleSource(String moduleName, UpdateListener listener) {
        if (!this.modules.contains((Object)moduleName)) {
            return null;
        }
        return new FileModuleSource(moduleName, this.classLoader, new File(this.path, String.valueOf(moduleName) + ".scl"), this.getBuiltinImports());
    }

    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
        this.modules.forEach(procedure);
    }

    @Override
    public Collection<String> getModuleNames() {
        return this.modules;
    }

    protected ImportDeclaration[] getBuiltinImports() {
        return ClassModuleSource.DEFAULT_IMPORTS;
    }
}

