/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.regexp;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.parser.regexp.Namer;
import org.simantics.scl.compiler.parser.regexp.Regexp;
import org.simantics.scl.compiler.parser.regexp.automata.NFA;

public class RSeq
extends Regexp {
    public final Regexp[] exps;

    RSeq(Regexp[] exps) {
        this.exps = exps;
    }

    @Override
    protected void buildAutomaton(NFA aut, int inState, int outState) {
        if (this.exps.length == 0) {
            aut.addEpsilonTransition(inState, outState);
            return;
        }
        int i = this.exps.length - 1;
        while (i > 0) {
            int midState = aut.newState();
            this.exps[i].buildAutomaton(aut, midState, outState);
            outState = midState;
            --i;
        }
        this.exps[0].buildAutomaton(aut, inState, outState);
    }

    @Override
    protected void toString(StringBuilder b, int prec) {
        if (prec >= 2) {
            b.append('(');
        }
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            exp.toString(b, 2);
            ++n2;
        }
        if (prec >= 2) {
            b.append(')');
        }
    }

    @Override
    public void toString(StringBuilder b, Namer grammar, int prec) {
        if (prec >= 2) {
            b.append('(');
        }
        boolean first = true;
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(' ');
            }
            exp.toString(b, grammar, 2);
            ++n2;
        }
        if (prec >= 2) {
            b.append(')');
        }
    }

    @Override
    protected int getTypeId() {
        return 3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RSeq other = (RSeq)obj;
        return Arrays.equals(this.exps, other.exps);
    }

    public int hashCode() {
        int r = 31340123;
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            r *= 31;
            r += exp.hashCode();
            ++n2;
        }
        return r;
    }

    @Override
    public Regexp simplify() {
        if (this.exps.length == 0) {
            return this;
        }
        ArrayList<Regexp> l = new ArrayList<Regexp>(this.exps.length);
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            exp = exp.simplify();
            RSeq.seq(l, exp);
            ++n2;
        }
        return RSeq.seq_(l);
    }

    @Override
    public boolean isNullable() {
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            if (!exp.isNullable()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

