/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment.filter;

import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilterIntersection;
import org.simantics.scl.compiler.environment.filter.NamespaceFilterUnion;
import org.simantics.scl.compiler.environment.filter.NegativeNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.PositiveNamespaceFilter;
import org.simantics.scl.compiler.module.ImportDeclaration;

public class NamespaceFilters {
    public static NamespaceFilter createFromSpec(ImportDeclaration.ImportSpec spec) {
        if (spec.hiding) {
            if (spec.values.length == 0) {
                return AcceptAllNamespaceFilter.INSTANCE;
            }
            THashSet names = new THashSet(spec.values.length);
            EVar[] eVarArray = spec.values;
            int n = spec.values.length;
            int n2 = 0;
            while (n2 < n) {
                EVar value = eVarArray[n2];
                names.add((Object)value.name);
                ++n2;
            }
            return new NegativeNamespaceFilter((THashSet<String>)names);
        }
        THashSet names = new THashSet(spec.values.length);
        EVar[] eVarArray = spec.values;
        int n = spec.values.length;
        int n3 = 0;
        while (n3 < n) {
            EVar value = eVarArray[n3];
            names.add((Object)value.name);
            ++n3;
        }
        return new PositiveNamespaceFilter((THashSet<String>)names);
    }

    public static NamespaceFilter union(NamespaceFilter a, NamespaceFilter b) {
        if (a == AcceptAllNamespaceFilter.INSTANCE || b == AcceptAllNamespaceFilter.INSTANCE) {
            return AcceptAllNamespaceFilter.INSTANCE;
        }
        if (a instanceof PositiveNamespaceFilter) {
            if (b instanceof PositiveNamespaceFilter) {
                return NamespaceFilters.unionImpl((PositiveNamespaceFilter)a, (PositiveNamespaceFilter)b);
            }
            if (b instanceof NegativeNamespaceFilter) {
                return NamespaceFilters.unionImpl((NegativeNamespaceFilter)b, (PositiveNamespaceFilter)a);
            }
        } else if (a instanceof NegativeNamespaceFilter) {
            if (b instanceof PositiveNamespaceFilter) {
                return NamespaceFilters.unionImpl((NegativeNamespaceFilter)a, (PositiveNamespaceFilter)b);
            }
            if (b instanceof NegativeNamespaceFilter) {
                return NamespaceFilters.unionImpl((NegativeNamespaceFilter)a, (NegativeNamespaceFilter)b);
            }
        }
        return new NamespaceFilterUnion(a, b);
    }

    private static NamespaceFilter unionImpl(PositiveNamespaceFilter a, PositiveNamespaceFilter b) {
        THashSet includedValues = new THashSet(a.includedValues.size() + b.includedValues.size());
        includedValues.addAll(a.includedValues);
        includedValues.addAll(b.includedValues);
        if (includedValues.size() == a.includedValues.size()) {
            return a;
        }
        if (includedValues.size() == b.includedValues.size()) {
            return b;
        }
        return new PositiveNamespaceFilter((THashSet<String>)includedValues);
    }

    private static NamespaceFilter unionImpl(NegativeNamespaceFilter a, PositiveNamespaceFilter b) {
        THashSet excludedValues = new THashSet(a.excludedValues);
        excludedValues.removeAll(b.includedValues);
        if (excludedValues.size() == a.excludedValues.size()) {
            return a;
        }
        if (excludedValues.isEmpty()) {
            return AcceptAllNamespaceFilter.INSTANCE;
        }
        return new NegativeNamespaceFilter((THashSet<String>)excludedValues);
    }

    private static NamespaceFilter unionImpl(NegativeNamespaceFilter a, NegativeNamespaceFilter b) {
        THashSet excludedValues = new THashSet(a.excludedValues);
        excludedValues.retainAll(b.excludedValues);
        if (excludedValues.size() == a.excludedValues.size()) {
            return a;
        }
        if (excludedValues.size() == b.excludedValues.size()) {
            return b;
        }
        if (excludedValues.isEmpty()) {
            return AcceptAllNamespaceFilter.INSTANCE;
        }
        return new NegativeNamespaceFilter((THashSet<String>)excludedValues);
    }

    public static NamespaceFilter intersection(NamespaceFilter a, NamespaceFilter b) {
        if (a == AcceptAllNamespaceFilter.INSTANCE) {
            return b;
        }
        if (b == AcceptAllNamespaceFilter.INSTANCE) {
            return a;
        }
        if (a instanceof PositiveNamespaceFilter) {
            if (b instanceof PositiveNamespaceFilter) {
                return NamespaceFilters.intersectionImpl((PositiveNamespaceFilter)a, (PositiveNamespaceFilter)b);
            }
            if (b instanceof NegativeNamespaceFilter) {
                return NamespaceFilters.intersectionImpl((PositiveNamespaceFilter)a, (NegativeNamespaceFilter)b);
            }
        } else if (a instanceof NegativeNamespaceFilter) {
            if (b instanceof PositiveNamespaceFilter) {
                return NamespaceFilters.intersectionImpl((PositiveNamespaceFilter)b, (NegativeNamespaceFilter)a);
            }
            if (b instanceof NegativeNamespaceFilter) {
                return NamespaceFilters.intersectionImpl((NegativeNamespaceFilter)a, (NegativeNamespaceFilter)b);
            }
        }
        return new NamespaceFilterIntersection(a, b);
    }

    private static NamespaceFilter intersectionImpl(NegativeNamespaceFilter a, NegativeNamespaceFilter b) {
        THashSet excludedValues = new THashSet(a.excludedValues.size() + b.excludedValues.size());
        excludedValues.addAll(a.excludedValues);
        excludedValues.addAll(b.excludedValues);
        if (excludedValues.size() == a.excludedValues.size()) {
            return a;
        }
        if (excludedValues.size() == b.excludedValues.size()) {
            return b;
        }
        return new NegativeNamespaceFilter((THashSet<String>)excludedValues);
    }

    private static NamespaceFilter intersectionImpl(PositiveNamespaceFilter a, NegativeNamespaceFilter b) {
        THashSet includedValues = new THashSet(a.includedValues);
        includedValues.removeAll(b.excludedValues);
        if (includedValues.size() == a.includedValues.size()) {
            return a;
        }
        return new PositiveNamespaceFilter((THashSet<String>)includedValues);
    }

    private static NamespaceFilter intersectionImpl(PositiveNamespaceFilter a, PositiveNamespaceFilter b) {
        THashSet includedValues = new THashSet(a.includedValues);
        includedValues.retainAll(b.includedValues);
        if (includedValues.size() == a.includedValues.size()) {
            return a;
        }
        if (includedValues.size() == b.includedValues.size()) {
            return b;
        }
        return new PositiveNamespaceFilter((THashSet<String>)includedValues);
    }
}

