/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.AbstractRelation;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class OptionalRelation
extends AbstractRelation {
    public static final OptionalRelation INSTANCE = new OptionalRelation();
    private static final TVar A = Types.var(Kinds.STAR);
    private static final TVar[] TYPE_VARIABLES = new TVar[]{A};
    private static final Type[] PARAMETER_TYPES = new Type[]{A, Types.apply((Type)Types.MAYBE, (Type)A)};

    private OptionalRelation() {
    }

    @Override
    public TVar[] getTypeVariables() {
        return TYPE_VARIABLES;
    }

    @Override
    public Type[] getParameterTypes() {
        return PARAMETER_TYPES;
    }

    @Override
    public int getPhase() {
        return 0;
    }

    @Override
    public double getSelectivity(int boundVariables) {
        switch (boundVariables) {
            case 0: 
            case 1: {
                return Double.POSITIVE_INFINITY;
            }
            case 2: {
                return 0.95;
            }
            case 3: {
                return 0.5;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getRequiredVariablesMask() {
        return 2;
    }

    @Override
    public void generate(long location, QueryCompilationContext context, Type[] typeParameters, Variable[] parameters, int boundVariables) {
        switch (boundVariables) {
            case 2: {
                context.iterateMaybe(parameters[0], new EVariable(parameters[1]));
                break;
            }
            case 3: {
                context.condition(new EApply(context.getConstant(Names.Prelude_elemMaybe, typeParameters), new EVariable(parameters[0]), new EVariable(parameters[1])));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String toString() {
        return "Optional";
    }

    @Override
    public Type getEnforceEffect() {
        return Types.NO_EFFECTS;
    }

    @Override
    public Type getQueryEffect() {
        return Types.NO_EFFECTS;
    }
}

