/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.BlockType;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementGroup;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementVisitor;

public class GuardStatement
extends Statement {
    public Expression value;

    public GuardStatement(Expression value) {
        this.value = value;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, BlockType blockType, Expression in) {
        if (blockType != BlockType.Normal) {
            Variable var = new Variable("_");
            return new EBind(this.location, blockType, new EVariable(this.location, var), this.value, in);
        }
        return new ESimpleLet(this.location, null, this.value, in);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void resolvePattern(TranslationContext context) {
    }

    @Override
    public boolean mayBeRecursive() {
        return false;
    }

    @Override
    public Statement replace(ReplaceContext context) {
        return new GuardStatement(this.value.replace(context));
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StatementGroup getStatementGroup() {
        return null;
    }
}

