/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.List;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EAmbiguous;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.accessor.FieldAccessor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.IdAccessor;
import org.simantics.scl.compiler.internal.header.ModuleHeader;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EFieldAccess
extends SimplifiableExpression {
    private static final Type VARIABLE = Types.con("Simantics/Variables", "Variable");
    public Expression parent;
    public FieldAccessor accessor;
    boolean lastAccessor = true;

    public EFieldAccess(Expression parent, FieldAccessor accessor) {
        this.parent = parent;
        this.accessor = accessor;
        if (parent instanceof EFieldAccess) {
            ((EFieldAccess)parent).lastAccessor = false;
        }
    }

    private boolean returnsValue() {
        return this.accessor.accessSeparator == '#' && !this.accessor.isVariableId();
    }

    @Override
    protected void updateType() throws MatchException {
    }

    private Expression resolveAccessor(TypingContext context, Type requiredType) {
        Expression accessorExpression;
        if (!(this.accessor instanceof IdAccessor)) {
            return null;
        }
        IdAccessor idAccessor = (IdAccessor)this.accessor;
        if (idAccessor.accessSeparator != '.') {
            return null;
        }
        final List<Constant> accessors = context.getEnvironment().getFieldAccessors(idAccessor.fieldName);
        if (accessors == null) {
            context.getErrorLog().log(idAccessor.location, "Couldn't resolve accessor ." + idAccessor.fieldName + ".");
            return new EError(this.location);
        }
        if (accessors.size() == 1) {
            accessorExpression = new ELiteral(accessors.get(0));
        } else {
            EAmbiguous.Alternative[] alternatives = new EAmbiguous.Alternative[accessors.size()];
            int i = 0;
            while (i < alternatives.length) {
                final int index = i;
                alternatives[i] = new EAmbiguous.Alternative(){

                    @Override
                    public Expression realize() {
                        return new ELiteral((Constant)accessors.get(index));
                    }

                    @Override
                    public Type getType() {
                        return ((Constant)accessors.get(index)).getType();
                    }

                    public String toString() {
                        return ((Constant)accessors.get(index)).toString();
                    }
                };
                ++i;
            }
            accessorExpression = new EAmbiguous(alternatives);
            accessorExpression.location = this.location;
        }
        return new EApply(this.location, accessorExpression, this.parent).checkType(context, requiredType);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        Expression expression;
        ModuleHeader header = context.getCompilationContext().header;
        if (header != null && header.fields && (expression = this.resolveAccessor(context, requiredType)) != null) {
            return expression;
        }
        if (this.returnsValue()) {
            this.setType(requiredType);
        } else {
            this.setType(VARIABLE);
            context.subsume(this, requiredType);
        }
        this.parent = this.parent.checkType(context, VARIABLE);
        this.accessor.checkType(context);
        context.declareEffect(this.getLocation(), Types.READ_GRAPH);
        return this;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.parent = this.parent.simplify(context);
        this.accessor.simplify(context);
        if (this.accessor.accessSeparator == '.') {
            return new EApply(this.getLocation(), Types.READ_GRAPH, context.getConstant(Names.Simantics_Variables_child_, new Type[0]), this.parent, this.accessor.asExpression());
        }
        if (!this.lastAccessor) {
            return new EApply(this.getLocation(), Types.READ_GRAPH, context.getConstant(Names.Simantics_Variables_property, new Type[0]), this.parent, this.accessor.asExpression());
        }
        if (this.accessor.isVariableId()) {
            return this.parent;
        }
        return new EApply(this.getLocation(), Types.READ_GRAPH, context.getConstant(Names.Simantics_Variables_untypedPropertyValue, this.getType()), this.parent, this.accessor.asExpression());
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.parent = this.parent.resolve(context);
        this.accessor.resolve(context);
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.parent.setLocationDeep(loc);
            this.accessor.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

