/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.hints;

import gnu.trove.map.hash.THashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;
import org.simantics.utils.threads.ThreadUtils;

public abstract class AbstractHintObservable
implements IHintObservable {
    protected SyncListenerList<IHintListener> listeners = new SyncListenerList(IHintListener.class);
    protected Map<IHintContext.Key, SyncListenerList<IHintListener>> keyListeners = new THashMap(2);
    private static final SyncListenerList<IHintListener> EMPTY_LIST = new SyncListenerList(IHintListener.class);
    private static final Runnable NO_ACTION = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static Method hintChanged = SyncListenerList.getMethod(IHintListener.class, (String)"hintChanged");
    private static Method hintRemoved = SyncListenerList.getMethod(IHintListener.class, (String)"hintRemoved");

    private synchronized SyncListenerList<IHintListener> getOrCreateKeyListeners(IHintContext.Key key) {
        SyncListenerList result = this.keyListeners.get(key);
        if (result == null) {
            result = new SyncListenerList(IHintListener.class);
            this.keyListeners.put(key, (SyncListenerList<IHintListener>)result);
        }
        return result;
    }

    protected synchronized SyncListenerList<IHintListener> getListenerList(IHintContext.Key forKey) {
        return this.keyListeners.get(forKey);
    }

    protected void fireKeyChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        this.createFireKeyChangedRunnable(sender, key, oldValue, newValue).run();
    }

    protected synchronized Executable[] getFireKeyChangedExecutables(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (this.listeners.isEmpty() && this.keyListeners.isEmpty()) {
            return Executable.EMPTY_ARRAY;
        }
        ArrayList<Executable> list = new ArrayList<Executable>();
        this.addFireKeyChangedExecutables(list, sender, key, oldValue, newValue);
        return list.toArray(new Executable[list.size()]);
    }

    protected synchronized Runnable createFireKeyChangedRunnable(final IHintObservable sender, final IHintContext.Key key, final Object oldValue, final Object newValue) {
        SyncListenerList<IHintListener> l1 = this.listeners;
        SyncListenerList<IHintListener> l2 = this.keyListeners.get(key);
        if (l2 == null) {
            l2 = EMPTY_LIST;
        }
        if (l1.isEmpty() && l2.isEmpty()) {
            return NO_ACTION;
        }
        if (!l1.executableInCurrentThread() || !l2.executableInCurrentThread()) {
            final Executable[] e = this.getFireKeyChangedExecutables(sender, key, oldValue, newValue);
            return new Runnable(){

                @Override
                public void run() {
                    ThreadUtils.multiSyncExec((Executable[])e);
                }
            };
        }
        final Map list1 = l1.getSnapshot();
        final Map list2 = l2.getSnapshot();
        return new Runnable(){

            @Override
            public void run() {
                IHintListener l;
                int n;
                int n2;
                IHintListener[] iHintListenerArray;
                IHintListener[] ll;
                Iterator iterator;
                if (list1 != null) {
                    iterator = list1.values().iterator();
                    while (iterator.hasNext()) {
                        iHintListenerArray = ll = (IHintListener[])iterator.next();
                        n2 = ll.length;
                        n = 0;
                        while (n < n2) {
                            l = iHintListenerArray[n];
                            l.hintChanged(sender, key, oldValue, newValue);
                            ++n;
                        }
                    }
                }
                if (list2 != null) {
                    iterator = list2.values().iterator();
                    while (iterator.hasNext()) {
                        iHintListenerArray = ll = (IHintListener[])iterator.next();
                        n2 = ll.length;
                        n = 0;
                        while (n < n2) {
                            l = iHintListenerArray[n];
                            l.hintChanged(sender, key, oldValue, newValue);
                            ++n;
                        }
                    }
                }
            }
        };
    }

    protected synchronized void addFireKeyChangedExecutables(Collection<Executable> list, IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        Object[] args = new Object[]{sender, key, oldValue, newValue};
        SyncListenerList<IHintListener> keyListeners = this.getListenerList(key);
        if (keyListeners != null) {
            keyListeners.addExecutables(list, hintChanged, args);
        }
        this.listeners.addExecutables(list, hintChanged, args);
    }

    protected void fireKeyRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        this.createFireKeyRemovedRunnable(sender, key, oldValue).run();
    }

    protected synchronized Executable[] getFireKeyRemovedExecutables(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        ArrayList<Executable> list = new ArrayList<Executable>();
        this.addFireKeyRemovedExecutables(list, sender, key, oldValue);
        return list.toArray(new Executable[list.size()]);
    }

    protected synchronized Runnable createFireKeyRemovedRunnable(final IHintObservable sender, final IHintContext.Key key, final Object oldValue) {
        SyncListenerList<IHintListener> l1 = this.listeners;
        SyncListenerList<IHintListener> l2 = this.keyListeners.get(key);
        if (l2 == null) {
            l2 = EMPTY_LIST;
        }
        if (l1.isEmpty() && l2.isEmpty()) {
            return NO_ACTION;
        }
        if (!l1.executableInCurrentThread() || !l2.executableInCurrentThread()) {
            final Executable[] e = this.getFireKeyRemovedExecutables(sender, key, oldValue);
            return new Runnable(){

                @Override
                public void run() {
                    ThreadUtils.multiSyncExec((Executable[])e);
                }
            };
        }
        final Map list1 = l1.getSnapshot();
        final Map list2 = l2.getSnapshot();
        return new Runnable(){

            @Override
            public void run() {
                IHintListener l;
                int n;
                int n2;
                IHintListener[] iHintListenerArray;
                IHintListener[] ll;
                Iterator iterator = list1.values().iterator();
                while (iterator.hasNext()) {
                    iHintListenerArray = ll = (IHintListener[])iterator.next();
                    n2 = ll.length;
                    n = 0;
                    while (n < n2) {
                        l = iHintListenerArray[n];
                        l.hintRemoved(sender, key, oldValue);
                        ++n;
                    }
                }
                iterator = list2.values().iterator();
                while (iterator.hasNext()) {
                    iHintListenerArray = ll = (IHintListener[])iterator.next();
                    n2 = ll.length;
                    n = 0;
                    while (n < n2) {
                        l = iHintListenerArray[n];
                        l.hintRemoved(sender, key, oldValue);
                        ++n;
                    }
                }
            }
        };
    }

    protected synchronized void addFireKeyRemovedExecutables(Collection<Executable> list, IHintObservable sender, IHintContext.Key key, Object oldValue) {
        Object[] args = new Object[]{sender, key, oldValue};
        SyncListenerList<IHintListener> keyListeners = this.getListenerList(key);
        if (keyListeners != null) {
            keyListeners.addExecutables(list, hintRemoved, args);
        }
        this.listeners.addExecutables(list, hintRemoved, args);
    }

    protected void fireKeyChanged(IHintContext.Key key, Object oldValue, Object newValue) {
        this.fireKeyChanged(this, key, oldValue, newValue);
    }

    protected void fireKeyRemoved(IHintContext.Key key, Object oldValue) {
        this.fireKeyRemoved(this, key, oldValue);
    }

    public synchronized boolean hasListeners() {
        return !this.listeners.isEmpty() || !this.keyListeners.isEmpty();
    }

    @Override
    public void addHintListener(IHintListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addKeyHintListener(IHintContext.Key key, IHintListener listener) {
        this.getOrCreateKeyListeners(key).add((Object)listener);
    }

    @Override
    public void removeHintListener(IHintListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public synchronized void removeKeyHintListener(IHintContext.Key key, IHintListener listener) {
        SyncListenerList<IHintListener> list = this.keyListeners.get(key);
        if (list == null) {
            return;
        }
        list.remove((Object)listener);
        if (list.isEmpty()) {
            this.keyListeners.remove(key);
        }
    }

    @Override
    public void addHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        this.listeners.add(threadAccess, (Object)listener);
    }

    @Override
    public void removeHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        this.listeners.remove(threadAccess, (Object)listener);
    }

    @Override
    public void addKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        this.getOrCreateKeyListeners(key).add(threadAccess, (Object)listener);
    }

    @Override
    public void removeKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        SyncListenerList<IHintListener> list = this.keyListeners.get(key);
        if (list == null) {
            return;
        }
        list.remove(threadAccess, (Object)listener);
        if (list.isEmpty()) {
            this.keyListeners.remove(key);
        }
    }
}

