/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.variable;

import java.util.List;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.Realm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class DebugNodeManager<Node>
implements NodeManager<Node> {
    protected NodeManager<Node> delegate;

    public DebugNodeManager(NodeManager<Node> delegate) {
        this.delegate = delegate;
    }

    protected long println(String msg) {
        long ts = System.nanoTime();
        double time = (double)ts * 1.0E-6;
        System.out.format("[%s @%f] %s\n", this.delegate.getClass().getSimpleName(), time, msg);
        return ts;
    }

    protected long println(long previousTime, String msg) {
        long ts = System.nanoTime();
        long dt = ts - previousTime;
        double time = (double)ts * 1.0E-6;
        double dtime = (double)dt * 1.0E-6;
        System.out.format("[%s @%f, took %f ms] %s\n", this.delegate.getClass().getSimpleName(), time, dtime, msg);
        return ts;
    }

    protected void format(String msg, Object ... args) {
        this.println(String.format(msg, args));
    }

    @Override
    public Realm getRealm() {
        this.println("getRealm");
        return this.delegate.getRealm();
    }

    @Override
    public String getName(Node node) {
        long ts = this.println("enter getName(" + node + ")");
        String name = this.delegate.getName(node);
        this.println(ts, "return getName(" + node + ") = " + name);
        return name;
    }

    @Override
    public void addNodeListener(Node node, Runnable listener) {
        long ts = this.println("enter addNodeListener(" + node + ", " + listener + ")");
        this.delegate.addNodeListener(node, listener);
        this.println(ts, "exit addNodeListener(" + node + ", " + listener + ")");
    }

    @Override
    public void removeNodeListener(Node node, Runnable listener) {
        long ts = this.println("enter removeNodeListener(" + node + ", " + listener + ")");
        this.delegate.removeNodeListener(node, listener);
        this.println(ts, "exit removeNodeListener(" + node + ", " + listener + ")");
    }

    @Override
    public Node getNode(String path) throws NodeManagerException {
        long ts = this.println("enter getNode(" + path + ")");
        Node node = this.getNode(path);
        this.println(ts, "return getNode(" + path + ") = " + node);
        return node;
    }

    @Override
    public Node getChild(Node node, String name) throws NodeManagerException {
        long ts = this.println("enter getChild(" + node + ", " + name + ")");
        Node child = this.getChild(node, name);
        this.println(ts, "return getChild(" + node + ", " + name + ") = " + child);
        return child;
    }

    @Override
    public Node getProperty(Node node, String name) throws NodeManagerException {
        long ts = this.println("enter getProperty(" + node + ", " + name + ")");
        Node property = this.delegate.getProperty(node, name);
        this.println(ts, "return getProperty(" + node + ", " + name + ") = " + property);
        return property;
    }

    @Override
    public List<String> getChildNames(Node node) throws NodeManagerException {
        long ts = this.println("enter getChildNames(" + node + ")");
        List<String> childNames = this.delegate.getChildNames(node);
        this.println(ts, "return getChildNames(" + node + ") = " + childNames);
        return childNames;
    }

    @Override
    public List<String> getPropertyNames(Node node) throws NodeManagerException {
        long ts = this.println("enter getPropertyNames(" + node + ")");
        List<String> propertyNames = this.delegate.getPropertyNames(node);
        this.println(ts, "return getPropertyNames(" + node + ") = " + propertyNames);
        return propertyNames;
    }

    @Override
    public List<Node> getChildren(Node node) throws NodeManagerException {
        long ts = this.println("enter getChildren(" + node + ")");
        List<Node> children = this.delegate.getChildren(node);
        this.println(ts, "return getChildren(" + node + ") = " + children);
        return children;
    }

    @Override
    public List<Node> getProperties(Node node) throws NodeManagerException {
        long ts = this.println("enter getProperties(" + node + ")");
        List<Node> properties = this.delegate.getProperties(node);
        this.println(ts, "return getProperties(" + node + ") = " + properties);
        return properties;
    }

    @Override
    public Datatype getDatatype(Node node) throws NodeManagerException {
        long ts = this.println("enter getValue(" + node + ")");
        Datatype datatype = this.delegate.getDatatype(node);
        this.println(ts, "return getValue(" + node + ") = " + datatype);
        return datatype;
    }

    @Override
    public Object getValue(Node node, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter getValue(" + node + ", " + binding + ")");
        Object value = this.delegate.getValue(node, binding);
        this.println(ts, "return getValue(" + node + ", " + binding + ") = " + value);
        return value;
    }

    @Override
    public Variant getValue(Node node) throws NodeManagerException {
        long ts = this.println("enter getValue(" + node + ")");
        Variant value = this.delegate.getValue(node);
        this.println(ts, "return getValue(" + node + ") = " + value);
        return value;
    }

    @Override
    public Object getValue(Node node, String property, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter getValue(" + node + ", " + property + ", " + binding + ")");
        Object value = this.delegate.getValue(node, property, binding);
        this.println(ts, "return getValue(" + node + ", " + property + ", " + binding + ") = " + value);
        return value;
    }

    @Override
    public Variant getValue(Node node, String property) throws NodeManagerException {
        long ts = this.println("enter getValue(" + node + ", " + property + ")");
        Variant value = this.delegate.getValue(node, property);
        this.println(ts, "return getValue(" + node + ", " + property + ") = " + value);
        return value;
    }

    @Override
    public void setValue(Node node, Object value, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter setValue(" + node + ", " + value + ", " + binding + ")");
        this.delegate.setValue(node, value, binding);
        this.println(ts, "exit setValue(" + node + ", " + value + ", " + binding + ")");
    }

    @Override
    public void setValue(Node node, String property, Object value, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter setValue(" + node + ", " + property + ", " + value + ", " + binding + ")");
        this.delegate.setValue(node, property, value, binding);
        this.println(ts, "exit setValue(" + node + ", " + property + ", " + value + ", " + binding + ")");
    }

    @Override
    public String getPropertyURI(Node parent, Node property) {
        long ts = this.println("enter getPropertyURI(" + parent + ", " + property + ")");
        String result = this.delegate.getPropertyURI(parent, property);
        this.println(ts, "return getPropertyURI(" + parent + ", " + property + ") = " + result);
        return result;
    }

    @Override
    public Set<String> getClassifications(Node node) throws NodeManagerException {
        long ts = this.println("enter getClassifications(" + node + ")");
        Set<String> result = this.delegate.getClassifications(node);
        this.println(ts, "return getClassifications(" + node + ") = " + result);
        return result;
    }
}

