/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

public class LEInt {
    public static byte[] toBytes(int value) {
        byte[] array = new byte[4];
        array[3] = (byte)(value & 0xFF);
        array[2] = (byte)(value >> 8 & 0xFF);
        array[1] = (byte)(value >> 16 & 0xFF);
        array[0] = (byte)(value >> 24 & 0xFF);
        return array;
    }

    public static void write(int value, byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        array[3 + offset] = (byte)(value & 0xFF);
        array[2 + offset] = (byte)(value >> 8);
        array[1 + offset] = (byte)(value >> 16);
        array[0 + offset] = (byte)(value >> 24);
    }

    public static void write(int value, byte[] array) {
        if (array.length < 4) {
            throw new IndexOutOfBoundsException();
        }
        array[3] = (byte)(value & 0xFF);
        array[2] = (byte)(value >> 8);
        array[1] = (byte)(value >> 16);
        array[0] = (byte)(value >> 24);
    }

    public static int toInt(byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int value = array[3 + offset] & 0xFF | (array[2 + offset] & 0xFF) << 8 | (array[1 + offset] & 0xFF) << 16 | (array[0 + offset] & 0xFF) << 24;
        return value;
    }

    public static int toInt(byte[] array) {
        if (4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int value = array[3] & 0xFF | (array[2] & 0xFF) << 8 | (array[1] & 0xFF) << 16 | (array[0] & 0xFF) << 24;
        return value;
    }

    public static void main(String[] args) {
        System.out.println("min=-2147483648 max=2147483647");
        int value = -1290000000;
        byte[] array = LEInt.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        LEInt.printByteArray(array);
        System.out.println();
        LEInt.write(value, array, 0);
        System.out.print(value);
        System.out.print(" = ");
        LEInt.printByteArray(array);
        System.out.println();
        value = LEInt.toInt(array, 0);
        LEInt.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        value = LEInt.toInt(array);
        LEInt.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }
}

