/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

public class BEShort {
    public static byte[] toBytes(short value) {
        byte[] array = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        return array;
    }

    public static void write(short value, byte[] array, int offset) {
        if (offset + 2 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        array[0 + offset] = (byte)(value & 0xFF);
        array[1 + offset] = (byte)(value >> 8);
    }

    public static void write(short value, byte[] array) {
        if (array.length < 2) {
            throw new IndexOutOfBoundsException();
        }
        array[0] = (byte)(value & 0xFF);
        array[1] = (byte)(value >> 8);
    }

    public static short toShort(byte[] array, int offset) {
        if (offset + 2 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        short value = (short)((short)array[0 + offset] & 0xFF | ((short)array[1 + offset] & 0xFF) << 8);
        return value;
    }

    public static short toShort(byte[] array) {
        if (2 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        short value = (short)((short)array[0] & 0xFF | ((short)array[1] & 0xFF) << 8);
        return value;
    }

    public static int toInt(byte[] array, int offset) {
        if (offset + 2 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        short value = (short)((short)array[0 + offset] & 0xFF | ((short)array[1 + offset] & 0xFF) << 8);
        return value;
    }

    public static void main(String[] args) {
        System.out.println("min=-32768 max=32767");
        short value = -513;
        byte[] array = BEShort.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        BEShort.printByteArray(array);
        System.out.println();
        BEShort.write(value, array, 0);
        System.out.print(value);
        System.out.print(" = ");
        BEShort.printByteArray(array);
        System.out.println();
        BEShort.write(value, array);
        System.out.print(value);
        System.out.print(" = ");
        BEShort.printByteArray(array);
        System.out.println();
        value = BEShort.toShort(array, 0);
        BEShort.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        value = BEShort.toShort(array);
        BEShort.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            i = (short)(i + 1);
        }
    }
}

