/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils;

import java.util.Collection;

public class GroupRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private RuntimeException[] errors;

    private GroupRuntimeException(RuntimeException[] errors) {
        super(GroupRuntimeException.getAsText(errors));
        this.errors = errors;
    }

    public static RuntimeException group(RuntimeException ... errors) {
        if (errors.length == 0) {
            throw new IllegalArgumentException("zero exceptions for GroupRuntimeException");
        }
        if (errors.length == 1) {
            return errors[0];
        }
        return new GroupRuntimeException(errors);
    }

    public static RuntimeException group(Collection<RuntimeException> collection) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("zero exceptions for GroupRuntimeException");
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return new GroupRuntimeException(collection.toArray(new RuntimeException[collection.size()]));
    }

    private static String getAsText(Throwable[] errors) {
        String result = "";
        Throwable[] throwableArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable error = throwableArray[n2];
            result = String.valueOf(result) + error.getClass().getName() + ": " + error.getMessage() + "\n";
            ++n2;
        }
        return result;
    }

    public RuntimeException[] getErrors() {
        return this.errors;
    }
}

