/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import org.simantics.databoard.Units;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.databoard.units.internal.UnitParseException;

public class UnitsExample {

    public static void main(String[] args) {
        try {
        	IUnitConverter c;
        	
        	String sourceUnit = "cl";
        	String targetUnit = "l";
        	c = Units.createConverter(sourceUnit, targetUnit);
        	
        	double sourceValue = 100;
        	
            System.out.println(c);
            System.out.println(sourceValue+" "+sourceUnit+" = "+c.convert(sourceValue)+" "+targetUnit);
            
//            System.out.println( Magnitude.getSuitable(50000) );
            
            
            System.out.println( "150 mph = "+Units.convert(150, "mph", "km/h") +" km/h");
            System.out.println( "100 hp = "+Units.convert(100, "hp(M)", "kW") +" kW");
            System.out.println( "100 lbs = "+Units.convert(100, "lbs", "kg") +" kg");

            
//            c = Units.createConverter("in2", "cm2");
//            System.out.println();
        } catch (UnitParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    
}
