/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example;

import java.util.ArrayList;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;

public class DeepCompare {

	public static void main(String[] args) throws BindingException {
		
		// Binding can compare any two instances. The compare function is deep. 		
		Binding binding = Bindings.getBindingUnchecked( int[].class );
		
		int[] array1 = new int[] { 1, 2, 3 };
		int[] array2 = new int[] { 1, 2, 3 };
		int[] array3 = new int[] { 2, 3, 4 };
		
		if ( binding.compare(array1, array2) == 0 ) {
			System.out.println( "array1 is equal to array2" );
		} else {
			System.out.println( "array1 is not equal to array2" );
		}
		
		if ( binding.compare(array1, array3) == 0 ) {
			System.out.println( "array1 is equal to array3" );
		} else {
			System.out.println( "array1 is not equal to array3" );
		}
		
		
		
		
		
		// Two bindings can compare instances of same datatype, even if they are of
		// different classes		
		ArrayList<Integer> array4 = new ArrayList<Integer>();
		Binding binding2 = Bindings.getBindingUnchecked( ArrayList.class, Integer.class );
		array4.add( 1 );
		array4.add( 2 );
		array4.add( 3 );
		
		if ( Bindings.compare(binding, array1, binding2, array4) == 0 ) {
			System.out.println( "array1 is equal to array4" );
		} else {
			System.out.println( "array1 is not equal to array4" );
		}
		
	}
	
}
