/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.collections;

import java.util.Arrays;

public class LightweightList {
    public static final Object EMPTY = new LL0();
    static final Object[] EMPTY_ARRAY = new Object[0];

    public static Object add(Object list, Object value) {
        if (list instanceof LL) {
            return ((LL)list).add(value);
        }
        return new LL2(list, value);
    }

    public static Object remove(Object list, Object value) {
        if (list instanceof LL) {
            return ((LL)list).remove(value);
        }
        return value.equals(list) ? EMPTY : list;
    }

    public static int size(Object list) {
        if (list instanceof LL) {
            return ((LL)list).size();
        }
        return 1;
    }

    public static boolean isEmpty(Object list) {
        return list == EMPTY;
    }

    public static Object[] toArray(Object list) {
        if (list == null) {
            return EMPTY_ARRAY;
        }
        if (list instanceof LL) {
            return ((LL)list).toArray();
        }
        return new Object[]{list};
    }

    public static void forEach(Object list, IProcedure proc) {
        if (list == null) {
            return;
        }
        if (list instanceof LL) {
            ((LL)list).forEach(proc);
        } else {
            proc.exec(list);
        }
    }

    public static interface IProcedure {
        public void exec(Object var1);
    }

    private static interface LL {
        public Object add(Object var1);

        public Object remove(Object var1);

        public int size();

        public Object[] toArray();

        public void forEach(IProcedure var1);
    }

    private static class LL0
    implements LL {
        private LL0() {
        }

        @Override
        public Object add(Object value) {
            return value;
        }

        @Override
        public Object remove(Object value) {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public void forEach(IProcedure proc) {
        }
    }

    private static class LL2
    implements LL {
        Object v0;
        Object v1;

        public LL2(Object v0, Object v1) {
            this.v0 = v0;
            this.v1 = v1;
        }

        @Override
        public Object add(Object value) {
            return new LL3(this.v0, this.v1, value);
        }

        @Override
        public Object remove(Object value) {
            if (value.equals(this.v0)) {
                return this.v1;
            }
            if (value.equals(this.v1)) {
                return this.v0;
            }
            return this;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.v0, this.v1};
        }

        @Override
        public void forEach(IProcedure proc) {
            proc.exec(this.v0);
            proc.exec(this.v1);
        }
    }

    private static class LL3
    implements LL {
        Object v0;
        Object v1;
        Object v2;

        public LL3(Object v0, Object v1, Object v2) {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public Object add(Object value) {
            return new LLN(this.v0, this.v1, this.v2, value);
        }

        @Override
        public Object remove(Object value) {
            if (value.equals(this.v0)) {
                return new LL2(this.v1, this.v2);
            }
            if (value.equals(this.v1)) {
                return new LL2(this.v0, this.v2);
            }
            if (value.equals(this.v2)) {
                return new LL2(this.v0, this.v1);
            }
            return this;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.v0, this.v1, this.v2};
        }

        @Override
        public void forEach(IProcedure proc) {
            proc.exec(this.v0);
            proc.exec(this.v1);
            proc.exec(this.v2);
        }
    }

    private static class LLN
    implements LL {
        Object[] array;
        int size;

        public LLN(Object v0, Object v1, Object v2, Object v3) {
            Object[] objectArray = new Object[6];
            objectArray[0] = v0;
            objectArray[1] = v1;
            objectArray[2] = v2;
            objectArray[3] = v3;
            this.array = objectArray;
            this.size = 4;
        }

        @Override
        public Object add(Object value) {
            if (this.size == this.array.length) {
                this.array = Arrays.copyOf(this.array, this.size * 3 / 2 + 1);
            }
            this.array[this.size++] = value;
            return this;
        }

        @Override
        public Object remove(Object value) {
            int i = 0;
            while (i < this.size) {
                if (value.equals(this.array[i])) {
                    while (i < this.size - 1) {
                        this.array[i] = this.array[i + 1];
                        ++i;
                    }
                    this.array[--this.size] = null;
                    if (this.size == 3) {
                        return new LL3(this.array[0], this.array[1], this.array[2]);
                    }
                    return this;
                }
                ++i;
            }
            return this;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.array, this.size);
        }

        @Override
        public void forEach(IProcedure proc) {
            int i = 0;
            while (i < this.size) {
                proc.exec(this.array[i]);
                ++i;
            }
        }
    }
}

