/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.cache;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.simantics.utils.datastructures.cache.IMapProvider;

public class WeakCachedMapProvider<K, V>
implements IMapProvider<K, V> {
    private Map<K, WeakReference<V>> cache = new HashMap<K, WeakReference<V>>();
    private final IMapProvider<K, V> provider;

    public WeakCachedMapProvider(IMapProvider<K, V> provider) {
        assert (provider != null);
        this.provider = provider;
    }

    @Override
    public synchronized V get(K key) {
        WeakReference<V> ref = this.cache.get(key);
        if (ref != null) {
            Object result = ref.get();
            if (result != null) {
                return (V)result;
            }
            this.cache.remove(ref);
        }
        V value = this.provider.get(key);
        assert (value != null);
        ref = new WeakReference<V>(value);
        this.cache.put(key, ref);
        return value;
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

