/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.lang.reflect.Array;
import java.util.Collection;

public class Arrays {
    public static <T> boolean contains(T[] array, T object) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (o.equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> int indexOf(T[] array, T object) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> void addAll(Collection<T> collection, T[] array) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            collection.add(o);
            ++n2;
        }
    }

    public static <T> T[] append(T[] src, T t) {
        int len = src.length;
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), len + 1);
        System.arraycopy(src, 0, result, 0, len);
        result[len] = t;
        return result;
    }

    public static <T> T[] append(T[] src, T ... ts) {
        if (ts.length == 0) {
            return src;
        }
        int len = src.length;
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), len + ts.length);
        System.arraycopy(src, 0, result, 0, len);
        System.arraycopy(ts, 0, result, len, ts.length);
        return result;
    }

    public static <T> T[] remove(T[] src, int index) {
        int len = src.length;
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("cannot remove negative index: " + index);
        }
        if (index >= len) {
            throw new ArrayIndexOutOfBoundsException("cannot remove array element " + index + ", array has " + len + " elements");
        }
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), len - 1);
        System.arraycopy(src, 0, result, 0, index);
        System.arraycopy(src, index + 1, result, index, len - index - 1);
        return result;
    }

    public static <T> T[] appendIfMissing(T[] src, T t) {
        int len = src.length;
        int i = 0;
        while (i < len) {
            if (t.equals(src[i])) {
                return src;
            }
            ++i;
        }
        return Arrays.append(src, t);
    }

    public static <T> T[] remove(T[] src, T t) {
        int len = src.length;
        int i = 0;
        while (i < len) {
            if (t.equals(src[i])) {
                return Arrays.remove(src, i);
            }
            ++i;
        }
        return src;
    }
}

