/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Arrays;

public final class Array<T> {
    private final T[] array;
    private final int hashCode;

    public Array(T[] array) {
        this.array = (Object[])array.clone();
        this.hashCode = Array.makeHashCode(this.array);
    }

    private static <T> int makeHashCode(T[] array) {
        int hash = 1;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                hash = 31 * hash ^ array[i].hashCode();
            }
            ++i;
        }
        return hash;
    }

    public T[] toArray() {
        return (Object[])this.array.clone();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        return Arrays.equals(this.array, ((Array)obj).array);
    }

    public int size() {
        return this.array.length;
    }
}

