/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.internal;

import gnu.trove.map.hash.TCharObjectHashMap;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class HtmlEscape {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final TCharObjectHashMap<String> ESCAPED_CHARS = new TCharObjectHashMap();
    private static final boolean[] URL_CAN_CONTAIN;

    static {
        ESCAPED_CHARS.put('<', (Object)"&lt;");
        ESCAPED_CHARS.put('>', (Object)"&gt;");
        ESCAPED_CHARS.put('\"', (Object)"&quot;");
        ESCAPED_CHARS.put('&', (Object)"&amp;");
        boolean[] blArray = new boolean[128];
        blArray[33] = true;
        blArray[35] = true;
        blArray[36] = true;
        blArray[37] = true;
        blArray[40] = true;
        blArray[41] = true;
        blArray[42] = true;
        blArray[43] = true;
        blArray[44] = true;
        blArray[45] = true;
        blArray[46] = true;
        blArray[47] = true;
        blArray[48] = true;
        blArray[49] = true;
        blArray[50] = true;
        blArray[51] = true;
        blArray[52] = true;
        blArray[53] = true;
        blArray[54] = true;
        blArray[55] = true;
        blArray[56] = true;
        blArray[57] = true;
        blArray[58] = true;
        blArray[59] = true;
        blArray[61] = true;
        blArray[63] = true;
        blArray[64] = true;
        blArray[65] = true;
        blArray[66] = true;
        blArray[67] = true;
        blArray[68] = true;
        blArray[69] = true;
        blArray[70] = true;
        blArray[71] = true;
        blArray[72] = true;
        blArray[73] = true;
        blArray[74] = true;
        blArray[75] = true;
        blArray[76] = true;
        blArray[77] = true;
        blArray[78] = true;
        blArray[79] = true;
        blArray[80] = true;
        blArray[81] = true;
        blArray[82] = true;
        blArray[83] = true;
        blArray[84] = true;
        blArray[85] = true;
        blArray[86] = true;
        blArray[87] = true;
        blArray[88] = true;
        blArray[89] = true;
        blArray[90] = true;
        blArray[95] = true;
        blArray[97] = true;
        blArray[98] = true;
        blArray[99] = true;
        blArray[100] = true;
        blArray[101] = true;
        blArray[102] = true;
        blArray[103] = true;
        blArray[104] = true;
        blArray[105] = true;
        blArray[106] = true;
        blArray[107] = true;
        blArray[108] = true;
        blArray[109] = true;
        blArray[110] = true;
        blArray[111] = true;
        blArray[112] = true;
        blArray[113] = true;
        blArray[114] = true;
        blArray[115] = true;
        blArray[116] = true;
        blArray[117] = true;
        blArray[118] = true;
        blArray[119] = true;
        blArray[120] = true;
        blArray[121] = true;
        blArray[122] = true;
        URL_CAN_CONTAIN = blArray;
    }

    public static CharSequence escape(CharSequence text) {
        int length = text.length();
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            String esc = (String)ESCAPED_CHARS.get(c);
            if (esc != null) {
                StringBuilder b = new StringBuilder(length + 16);
                b.append(text, 0, i);
                b.append(esc);
                ++i;
                while (i < length) {
                    c = text.charAt(i);
                    esc = (String)ESCAPED_CHARS.get(c);
                    if (esc != null) {
                        b.append(esc);
                    } else {
                        b.append(c);
                    }
                    ++i;
                }
                return b.toString();
            }
            ++i;
        }
        return text;
    }

    public static StringBuilder escapeURL(CharSequence str) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < '\u0000' || c >= '\u0080') {
                ByteBuffer bs = UTF8.encode(CharBuffer.wrap(new char[]{c}));
                int j = 0;
                while (j < bs.limit()) {
                    result.append(HtmlEscape.percentEncode(bs.get()));
                    ++j;
                }
            } else if (URL_CAN_CONTAIN[c]) {
                result.append(c);
            } else if (c == '&') {
                result.append("&amp;");
            } else {
                result.append(HtmlEscape.percentEncode(c));
            }
            ++i;
        }
        return result;
    }

    private static String percentEncode(int c) {
        String hex;
        if (c < 0) {
            c += 256;
        }
        if ((hex = Integer.toHexString(c).toUpperCase()).length() == 1) {
            return "%0" + hex;
        }
        return "%" + hex;
    }
}

